/*	$NetBSD: compat_openbsd.h,v 1.3 2005/03/15 16:28:29 peter Exp $	*/

/*-
 * Copyright (c)2004 YAMAMOTO Takashi,
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * misc OpenBSD compatibility hacks.
 */

#include <sys/cdefs.h>

/*
 * syslog.h
 */

#include <stdarg.h>
#include <syslog.h>

#define	openlog_r(ident, logopt, fac, data)	/* nothing */

struct syslog_data {
#if !defined(__GNUC__)
	/* empty structure is gcc extension */
	char dummy;
#endif
};
#define	SYSLOG_DATA_INIT	{}

static __inline void syslog_r(int pri, struct syslog_data *data,
    const char *fmt, ...) __unused;

static __inline void
syslog_r(int pri, struct syslog_data *data, const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vsyslog(pri, fmt, ap);
	va_end(ap);
}

/*
 * sys/queue.h
 */

#define	TAILQ_END(h)	NULL


/*
 * libc/stdlib/strtonum.c
 */

#include <limits.h>
#include <stdlib.h>

static __inline long long
strtonum(const char *, long long, long long, const char **) __unused;

static __inline long long
strtonum(const char *numstr, long long minval, long long maxval,
    const char **errstrp)
{
	char *p;
	long long n;

	n = strtol(numstr, &p, 10);
	if (*p != '\0' || *numstr == '\0') {
		*errstrp = "invalid";
		n = 0;
	}
	return (n);
}
