dnl
dnl $Heimdal: broken-realloc.m4,v 1.1.12.1 2004/04/01 07:27:32 joda Exp $
dnl $NetBSD: broken-realloc.m4,v 1.3 2004/04/02 14:59:47 lha Exp $
dnl
dnl Test for realloc that doesn't handle NULL as first parameter
dnl
AC_DEFUN([rk_BROKEN_REALLOC], [
AC_CACHE_CHECK(if realloc if broken, ac_cv_func_realloc_broken, [
ac_cv_func_realloc_broken=no
AC_TRY_RUN([
#include <stddef.h>
#include <stdlib.h>

int main()
{
	return realloc(NULL, 17) == NULL;
}
],:, ac_cv_func_realloc_broken=yes, :)
])
if test "$ac_cv_func_realloc_broken" = yes ; then
	AC_DEFINE(BROKEN_REALLOC, 1, [Define if realloc(NULL) doesn't work.])
fi
AH_BOTTOM([#ifdef BROKEN_REALLOC
#define realloc(X, Y) isoc_realloc((X), (Y))
#define isoc_realloc(X, Y) ((X) ? realloc((X), (Y)) : malloc(Y))
#endif])
])
