.\" Id: grap2graph.man,v 1.3 2003/10/28 07:46:23 wlemb Exp
.\" This documentation is released to the public domain.
.
.
.TH GRAP2GRAPH @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.IX grap2graph
.SH NAME
grap2graph \- convert a grap diagram into a cropped bitmap image
.
.
.SH SYNOPSIS
.B grap2graph
[
.B \-unsafe
]
[
.BI \-resolution\  M\fR|\fPMxN
]
[
.BI \-format\  fmt
]
.
.
.SH DESCRIPTION
Reads a grap program as input; produces an image file (by default in
Portable Network Graphics format) suitable for the Web as output.
For a description of the grap language, see
.BR grap (1).
.P
Your graph specification should \fInot\fR be wrapped with the \&.G1 and
\&.G2 macros that normally guard it within
.BR groff (@MAN1EXT@)
macros.
.P
The output image will be a black-on-white graphic clipped to the
smallest possible bounding box that contains all the black pixels.
By specifying command-line options to be passed to 
.BR convert (1)
you can give it a border, set the background transparent, set the
image's pixel density, or perform other useful transformations.
.P
This program uses 
.BR grap (1),
.BR @g@pic (@MAN1EXT@),
.BR groff (@MAN1EXT@),
and the ImageMagick 
.BR convert (1)
program.
These programs must be installed on your system and accessible on your
$PATH for \fBgrap2graph\fR to work.
.
.
.SH OPTIONS
.TP
.B \-unsafe
Run 
.BR @g@pic (@MAN1EXT@)
and
.BR groff (@MAN1EXT@)
in the `unsafe' mode enabling the PIC macro
.B sh
to execute arbitrary commands.
The default is to forbid this.
.TP
.BI \-format\  fmt
Specify an output format; the default is PNG (Portable Network Graphics).
Any format that
.BR convert (1)
can emit is supported.
.PP
Command-line switches and arguments not listed above are passed to
.BR convert (1).
.
.
.SH ENVIRONMENT
.TP
.B GROFF_TMPDIR
The directory in which temporary files will be created.
If this is not set
.B grap2graph
searches the environment variables
.BR \%TMPDIR ,
.BR TMP ,
and
.B TEMP
(in that order).
Otherwise, temporary files will be created in
.BR /tmp .
.
.
.SH "SEE ALSO"
.BR pic2graph (@MAN1EXT@),
.BR eqn2graph (@MAN1EXT@),
.BR @g@pic (@MAN1EXT@),
.BR groff (@MAN1EXT@),
.BR gs (1),
.BR convert (1).
.
.
.SH AUTHOR
Eric S. Raymond <esr@thyrsus.com>
.
.\" Local Variables:
.\" mode: nroff
.\" End:
