/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: share.h,v $
 *
 * HISTORY
 * $\Log: share.h,v $
 * Revision 1.3  1998/01/31 18:43:16  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.1  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 */

#ifndef _MGR_SHARE_H
#define _MGR_SHARE_H

#ifdef MOVIE

#include <mgr/bitblit.h>
#include <stdio.h>

/* types */

#define OP_MASK		0xF		/* opcode part of type */
#define TYPE_MASK	0xF0

#define T_NOP		0x00		/* do a nop */
#define T_BLIT		0x10		/* do a bit-blt */
#define T_WRITE		0x20		/* do a bit-blt */
#define T_LINE		0x30		/* do a line */
#define T_POINT		0x40		/* do a point */
#define T_DATA		0x50		/* send some data */
#define T_KILL		0x60		/* destroy a bitmap */
#define T_SCREEN	0x70		/* define the screen */
#define T_TIME		0x80		/* current time (100'th of a second) */
#define T_BLIT2		0x90		/* compressed bit-blit for chars */
#define T_MARK		0xa0      	/* network marks */
#define T_BYTESCROLL	0xb0		/* do scrolling using fast scroll */

struct share_msg
{
	unsigned short type;		/* message type */
	unsigned short stuff[8];	/* other stuff */
};

/* stuff for getting bitmap id's */

#define MAX_MAPS	4000		/* max # bitmap id's */

void log_blit(BITMAP *dst_map, int xd, int yd,int w, int h, int op, BITMAP *src_map, int xs, int ys);
void log_line(BITMAP *dst, int x0, int y0, int x1, int y1, int op);
void log_point(BITMAP *dst, int x, int y, int op);
void log_open(BITMAP *bp);
void log_destroy(BITMAP *bitmap);
void log_alloc(BITMAP *bp);
void log_create(BITMAP *bp);
void send_sync(void);
void log_time(void);
int log_start(FILE *logfile);
int log_end(void);

#endif

#endif /* MGR_SHARE_H */
