/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: shape.c,v $
 *
 * HISTORY
 * $\Log: shape.c,v $
 * Revision 1.4  1998/01/31 18:43:16  mjk
 * replaced copyright
 *
 * Revision 1.3  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.2  1997/06/09 22:12:51  acb
 * Inserted call to wimp_send_move_resize_event().
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 *
 * Revision 1.4  1997/01/14 18:37:02  acb
 * * Clipping works now
 * * Performance enhancement -- terminal emulator avoids reads from
 *   framebuffer
 *
 * Revision 1.3  1997/01/07  15:44:49  acb
 * Added WINDOW_RESIZE_EVENT when window is resized with the mouse.
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */



/* re-shape a window */
#include <oskit/wimpi.h>

#include <bitblit.h>
#include <font.h>
#include <stdio.h>

#include "defs.h"
#include <shape.h>
#include "border.h"
#include "do_button.h"
#include "erase_win.h"
#include "font_subs.h"
#include "icon_server.h"
#include "intersect.h"
#include "subs.h"
#include "clip.h"
#include "get_rect.h"
#include "update.h"

#include <wimp_internal.h>
#include <wimp_wintree.h>


#define WORD int
#define WORD_SZ sizeof (WORD)
/* these should be same as in mem_rop.c */

/*{{{  shape -- reshape a window to specified dimentions*/
int shape(wimpiSession mr, int x, int y, int dx, int dy)
{
  BITMAP *screen = mr->screen;
  int sx,sy,w,h;
  register WINDOW *win;
  int delx;

  /* Makes no sense.  x and y are coordinates of border, but dx and dy
   * are width and height of borderless window.
   */

  if (dx>0)
  {
    sx= x; w = dx;
  }
  else 
  {
    sx= x+dx; w = -dx;
  }
  if (dy>0) 
  {
    sy= y; h = dy;
  }
  else 
  {
    sy= y+dy; h = -dy;
  }

  if (sx < 0) sx = 0;
  if (sy < 0) sy = 0;

  /* hack */
  /* sx is positive */
  delx = ((~(int)sx) + 1) & (WORD) (WORD_SZ-1);
  if (sx == 0)
    sx = 3;
  else
    sx = sx + delx - 1;

  if (sx + w >= BIT_WIDE(screen))
  w = BIT_WIDE(screen) - sx;

  if (sy + h >= BIT_HIGH(screen))
  h = BIT_HIGH(screen) - sy;

  save_win(mr->active);
  erase_win(mr,ACTIVE(mr,border));
  clip_bad (mr->active);
  
  /* redraw remaining windows */
  repair(mr,mr->active);


  /* adjust window state */

  ACTIVE(mr,x0) = sx;
  ACTIVE(mr,y0) = sy;

  bit_destroy(ACTIVE(mr,border));
  bit_destroy(ACTIVE(mr,window));

  ACTIVE(mr,border) = (void *)0;
  ACTIVE(mr,window) = (void *)0;

  ACTIVE(mr,border) = bit_create(screen,sx,sy,
				 w+ACTIVE(mr,borderwid)*2,
				 h+ACTIVE(mr,borderwid)*2);
  ACTIVE(mr,window) = bit_create(ACTIVE(mr,border),
			      ACTIVE(mr,borderwid),
			      ACTIVE(mr,borderwid),
			      w,h);

  for(win=ACTIVE(mr,next);win != (WINDOW *) 0;win=W(next)) 
  {
    if (W(flags)&W_ACTIVE && intersect(mr->active,win))
    save_win(win);
  }

  CLEAR(ACTIVE(mr,window),PUTOP(BIT_CLR,ACTIVE(mr,style)));
  border(mr->active,BORDER_THIN);

  bit_blit(ACTIVE(mr,window),0,0,
	   BIT_WIDE(ACTIVE(mr,save))-2*ACTIVE(mr,borderwid),
	   BIT_HIGH(ACTIVE(mr,save))-2*ACTIVE(mr,borderwid),
	   BIT_SRC,ACTIVE(mr,save),ACTIVE(mr,borderwid),ACTIVE(mr,borderwid));

  /* make sure character cursor is in a good spot */
  if (ACTIVE(mr,x) > BIT_WIDE(ACTIVE(mr,window))) 
    {
      ACTIVE(mr,x) = 0;
      ACTIVE(mr,y) += ((int)(ACTIVE(mr,font)->head.high));
    }
  if (ACTIVE(mr,y) > BIT_HIGH(ACTIVE(mr,window))) 
    {
#ifdef WIERD
      ACTIVE(mr,y) = BIT_HIGH(ACTIVE(mr,window));
      scroll(ACTIVE(mr,window),0,BIT_HIGH(ACTIVE(mr,window)),
	     ((int)(ACTIVE(mr,font)->head.high)),SWAPCOLOR(ACTIVE(mr,style)));
      bit_blit(ACTIVE(mr,window),0,BIT_HIGH(ACTIVE(mr,window))-((int)(ACTIVE(mr,font)->head.h
								igh)),
	       BIT_WIDE(ACTIVE(mr,save)),((int)(ACTIVE(mr,font)->head.high)),
	       BIT_SRC,ACTIVE(mr,save),
	       ACTIVE(mr,borderwid),BIT_HIGH(ACTIVE(mr,save))-
	       ((int)(ACTIVE(mr,font)->head.high))-ACTIVE(mr,borderwid));
#else
      ACTIVE(mr,y) = BIT_HIGH(ACTIVE(mr,window))-
	  ((int)(ACTIVE(mr,font)->head.high));
#endif
    }      

  bit_destroy(ACTIVE(mr,save));
  ACTIVE(mr,save)=(BITMAP *)0;

  /* invalidate clip lists */
  clip_bad(mr->active);
  
  /* un_covered(mr); */

  /*
   *  set_size(active);
   */

  return(0);
}


/*{{{  shape_window -- reshape a window with the mouse*/
void shape_window(wimpiSession mr)
{
  int dx=16 ,dy=16 ;
  WINDOW *win;
  int x,y;
  
  mr->m_rop = mr->mouse_box;
  move_mouse(mr,mr->mouse,&(mr->mousex),&(mr->mousey),0);
  mr->m_rop = DEFAULT_MOUSE_CURSOR(mr);
  get_rect(mr,mr->screen,mr->mouse,mr->mousex,mr->mousey,&dx,&dy,0);
  do_button(mr, 0, mr->screen);

  /* look for shape event here */
  /* XXX  do_event(EVENT_SHAPE,active,E_MAIN);
   */

  /* Find outermost ancestor of active win */
  for (win = mr->active; win->parent != mr->root_win; win = win->parent);
     
  dx -= win->borderwid*2;
  dy -= win->borderwid*2;
  /***
    CA 11/4/97
    fixed bug and correct mouse behavior
    ***/
  x=mr->mousex + (dx < 0 ? dx : 0);
  y=mr->mousey + (dy < 0 ? dy : 0);
  mr->mousex += dx;
  mr->mousey += dy;
  /***/
  wimp_internal_move_resize_window (win, x, y, abs(dx), abs(dy));
  /* shape(mr,mr->mousex,mr->mousey,dx,dy); */

  /* XXX - not sure how to work this */
/*  if (win->wimpi->s.end[0] &&
      win->wimpi->s.end[0]->back) 
  { */
      wimpi_send_move_resize_event(win);
/*  }*/
}
/*}}}  */





