/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: scroll.c,v $
 *
 * HISTORY
 * $\Log: scroll.c,v $
 * Revision 1.3  1998/01/31 18:43:15  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */


/*****************************************************************************
 *	scroll a bitmap
 */
/*}}}  */
/*{{{  #includes*/
#include <bitblit.h>
#include <stdio.h>
#include "clip.h"
#include "defs.h"
#include <scroll.h>
/*}}}  */

/*{{{  scroll -- scroll a bitmap*/
void scroll(win,map,start,end,delta,op)
register WINDOW *win;	/* window to scroll */
register BITMAP *map;	/* bitmap in window to scroll */
int start,end,delta,op;	/* starting line, ending line, # of lines */
   {
   register int ems = end-start;
   if (delta > 0) {
      if (end-start > delta)
#ifdef MGR_ALIGN
         if (win->window == map) {
            dbgprintf('F',(stderr,"fast scroll %s\r\n",W(tty)));
            /* special high-speed byte-aligned scroller */

            bit_bytescroll(map,BIT_X(map),BIT_Y(map) + start,
                     BIT_WIDE(map) + W(borderwid), end-start, delta);
            }
         else
#endif MGR_ALIGN
            bit_blit(map,0,start,BIT_WIDE(map),ems-delta,BIT_SRC,map,0,start+delta);
      bit_blit(map,0,end-delta,BIT_WIDE(map),delta,op,0,0,0);
      }

   else if (delta < 0) {
      if (ems + delta > 0)
         bit_blit(map,0,start-delta,BIT_WIDE(map),ems+delta,
             BIT_SRC,map,0,start);
      bit_blit(map,0,start,BIT_WIDE(map),-delta,op,NULL_DATA,0,0);
      }


   if (Do_clip()) 
      Set_clip(W(text).x,
               W(text).y + start,
               W(text).x + BIT_WIDE(map),
               W(text).y + BIT_HIGH(map)
              );
   }
/*}}}  */
