/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: mem_rop.c,v $
 *
 * HISTORY
 * $\Log: mem_rop.c,v $
 * Revision 1.4  1998/01/31 18:43:11  mjk
 * replaced copyright
 *
 * Revision 1.3  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.2  1997/06/09 22:06:53  acb
 * Added blit for text with transparent background.
 *
 * Revision 1.1  1997/05/30 21:41:24  acb
 * Initial revision
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.5  1997/01/14 18:32:28  acb
 * Fixed routines for lower-right to upper-left copy.
 *
 * Revision 1.4  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.3  1996/12/09 21:47:51  acb
 * Fast_Rop_incr_a_nm() now performs operations on "WORD"-sized chunks in
 * the case where the source and destination are not congruent.
 *
 * Revision 1.2  1996/10/26  04:58:43  davidm
 * (is_congruent): Declare "static inline".
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */


static char	RCSid_[] = "$Source:";

#include <stdio.h>
#include "screen.h"

#define UPLEFT		0x1	 
#define DOWNRIGHT	0x0	 
#define SMALL		0x2	 
#define ALIGNED		0x4	 
#define NOMASK		0x8	 
#define SRC_COLOR	0x10	 
#define TRANS_BG        0x20

extern int bit_debug;

#ifdef OSKIT
typedef oskit_u64_t __u64;
#endif


#define WORD    int
#define WORD_SZ sizeof (WORD) 
#define WORDMASK (((__u64) 1 << (WORD_SZ << LOGBITS)) - 1)


#define dprintf	if(bit_debug)fprintf

static char nsrc[16] = {		 
  0,0,0,0,
  0xf&~DST, 0xf&~DST, 0xf&~DST, 0xf&~DST,
  0xf&DST, 0xf&DST, 0xf&DST, 0xf&DST, 
  0xf, 0xf, 0xf, 0xf
};

static char zsrc[16] = {		 
  1,0,0,0,0,
  1,0,0,0,0,
  1,0,0,0,0,
  1 };	



#define ZERO(d,s)	(0)
#define NOR(d,s)	(~((d)|(s)))
#define AND2(d,s)	((d)&~(s))
#define NPROJ2(d,s)	(~(s))
#define AND1(d,s)	(~(d)&(s))
#define NPROJ1(d,s)	(~(d))
#define XOR(d,s)	((d)^(s))
#define NAND(d,s)	(~((d)&(s)))
#define AND(d,s)	((d)&(s))
#define NXOR(d,s)	(~((d)^(s)))
#define PROJ1(d,s)	((d))
#define OR2(d,s)	((d)|~(s))
#define PROJ2(d,s)	(s)
#define OR1(d,s)	(~(d)|(s))
#define OR(d,s)		((d)|(s))
#define ONE(d,s)	(~0)


#define Rop_s(op)    \
    for (i=count; i>0; i--) {  \
	osrc = src;  \
	src += 1;   \
        *dst = (op(*dst,(GETMSB(*osrc,lshift) | GETLSB(*src,rshift))) \
	          & lmask) | (*dst & ~lmask);       \
        src += s_skip;  dst += d_skip; \
    }



#define Rop_sC(op)    \
    for (i=count; i>0; i--) { \
	*dst = (op(*dst,color) & lmask) | (*dst & ~lmask); \
	dst += d_skip; \
    }



#ifndef BANKED
#define Rop_sC_nm(op)    \
    for (i=count; i>0; i--) { \
        *dst = op(*dst,color); \
        dst += d_skip; \
    }
#else  
#define Rop_sC_nm(op)    \
    for (i=count; i>0; i--) { \
        DATA *dst_wdp = IS_SCREEN( dst_map)? getdatap( dst, \
		dst_map->data, NULL): dst; \
        *dst_wdp = op(*dst_wdp,color); \
        dst += d_skip;   \
    }
#endif



#define Rop_sa(op)    \
    for (i=count; i>0; i--) { \
        *dst = (op(*dst,*src) & lmask) | (*dst & ~lmask); \
        src += s_skip;  dst += d_skip;   \
    }



#ifndef BANKED
#define Rop_sa_nm(op)  \
    for (i=count; i>0; i--) { \
        *dst = op(*dst,*src); \
        src += s_skip;  dst += d_skip; \
    }
#else  
#define Rop_sa_nm(op) \
    for (i=count; i>0; i--) { \
        DATA *src_wdp = IS_SCREEN( src_map)? \
		getdata( src, src_map->data, 1): src; \
        DATA *dst_wdp = IS_SCREEN( dst_map)? \
		getdatap( dst, dst_map->data, NULL): dst;\
        *dst_wdp = op(*dst_wdp,*src_wdp); \
        src += s_skip; \
        dst += d_skip; \
    }
#endif



#define Rop_incr_a(op) \
    for (i=count; i>0; i--) { \
        *dst = (op(*dst,*src) & lmask) | (*dst & ~lmask); \
        src += 1; \
        dst += 1; \
        LOOP(words-2,*dst = op(*dst,*src); src += 1; dst += 1); \
        *dst = (op(*dst,*src) & rmask) | (*dst & ~rmask); \
        src += s_skip + 1; \
        dst += d_skip + 1; \
    }



#ifndef BANKED
#define Rop_incr_a_nm(op) \
    for (i=count; i>0; i--) { \
        LOOP(words,*dst = op(*dst,*src); src += 1; dst += 1); \
        src += s_skip; \
        dst += d_skip; \
    }

#define Fast_Rop_incr_a_nm(op)    \
{ \
for (i=count; i>0; i--) { \
   register WORD src0, src1; \
   register int src_shift, offset; \
   if (words_bef != (offset = ((~((unsigned long)dst)) + 1) & \
                        ((unsigned long)(WORD_SZ-1)))) \
   { \
       words_bef = offset; \
       words_r = (words - words_bef)/WORD_SZ; \
       words_rem = (words - words_bef)%WORD_SZ; \
   } \
   if (is_congruent ((unsigned long)dst, (unsigned long)src)) { \
      LOOP(words_bef, *dst = op(*dst, *src); src ++; dst ++;); \
      LOOP(words_r, *((WORD *)dst) = op(*((WORD *)dst),*((WORD *)src)); \
		src += WORD_SZ; dst += WORD_SZ;); \
      LOOP(words_rem, *dst = op(*dst, *src); src ++; dst ++;); \
   } \
   else { \
      LOOP (words_bef, *dst = op(*dst, *src); src ++; dst ++;); \
      src_shift = (int)((u_long) src) & (WORD_SZ-1); \
      offset = WORD_SZ - src_shift; \
      src0 = *((WORD *)(src - src_shift)); \
      src += offset; \
      offset <<= LOGBITS; \
      src_shift <<= LOGBITS; \
      LOOP(words_r, src1 = *((WORD *)src); \
              src0 = ((src0 & WORDMASK) >> src_shift) | (src1 << offset); \
              *((WORD *) dst) = op(*((WORD *) dst), (WORD) src0); \
              src0 = src1; \
              src += WORD_SZ; \
	      dst += WORD_SZ;); \
      src -= (offset >> LOGBITS); \
      LOOP (words_rem, *dst = op (*dst , *src); src ++;  dst ++;); \
   } \
   src += s_skip; \
   dst += d_skip; \
}}

#else  
#define Rop_incr_a_nm(op) \
    for (i=count; i>0; i--) { \
        DATA *src_wdp = IS_SCREEN( src_map)? \
		getdata( src, src_map->data, words): src; \
        unsigned int bct = words; \
        DATA *dst_wdp = IS_SCREEN( dst_map)?  \
		getdatap( dst, dst_map->data, &bct): dst; \
        unsigned int wlf = words - bct; \
        LOOP(bct,*dst_wdp = op(*dst_wdp,*src_wdp); src_wdp += 1; dst_wdp += 1); \
        if( wlf) { \
		dst_wdp = getdatap( dst+bct, dst_map->data, NULL); \
		LOOP(wlf,*dst_wdp = op(*dst_wdp,*src_wdp); \
			src_wdp += 1; dst_wdp += 1); \
        } \
	src += s_skip + words; \
        dst += d_skip + words;\
    }
#endif



#define Rop_decr_a(op)    \
for (i=count; i>0; i--) { \
      *dst = (op(*dst,*src) & rmask) | (*dst & ~rmask); \
      src -= 1;  dst -= 1; \
      LOOP(words-2,*dst = op(*dst,*src); src -= 1; dst -= 1); \
      *dst = (op(*dst,*src) & lmask) | (*dst & ~lmask); \
      src += s_skip - 1;  dst += d_skip - 1; \
}



#ifndef BANKED
#define Rop_decr_a_nm(op) \
for (i=count; i>0; i--) { \
      LOOP(words,*dst = op(*dst,*src); src -= 1; dst -= 1);  \
      src += s_skip;  dst += d_skip;\
} 

#define Fast_Rop_decr_a_nm(op)    \
for (i=count; i>0; i--) { \
   register WORD src0, src1; \
   register int src_shift, offset; \
   if (words_bef != (offset =  ((unsigned long)dst & \
				(unsigned long)(WORD_SZ-1)))) \
   { \
       words_bef = offset; \
       words_r = (words - words_bef)/WORD_SZ; \
       words_rem = (words - words_bef)%WORD_SZ; \
   } \
   if (is_congruent ((unsigned long)dst, (unsigned long)src)) { \
      LOOP(words_bef, *dst = op(*dst, *src); src --; dst --;); \
      *dst = op (*dst, *src); \
      dst -= WORD_SZ; \
      src -= WORD_SZ; \
      LOOP(words_r, *((WORD *)dst) = op(*((WORD *)dst),*((WORD *)src)); \
		src -= WORD_SZ; dst -= WORD_SZ;); \
      dst += WORD_SZ; \
      src += WORD_SZ; \
      LOOP(words_rem, src --; dst --; *dst = op(*dst, *src); ); \
   } \
   else { \
      LOOP (words_bef, *dst = op(*dst, *src); src --; dst --;); \
      dst -= WORD_SZ; \
      src -= WORD_SZ; \
      src_shift = (int)((u_long) src) & (WORD_SZ-1); \
      offset = WORD_SZ - src_shift; \
      src0 = *((WORD *)(src + offset)); \
      src -= src_shift; \
      offset <<= LOGBITS; \
      src_shift <<= LOGBITS; \
      LOOP(words_r, src1 = *((WORD *)src); \
              src0 = ((src0) << offset) | ((src1 & WORDMASK)>> src_shift); \
              *((WORD *) dst) = op(*((WORD *) dst), (WORD) src0); \
              src0 = src1; \
              src -= WORD_SZ; \
	      dst -= WORD_SZ;); \
      src += ((src_shift >> LOGBITS) + WORD_SZ); \
      dst += WORD_SZ; \
      LOOP(words_rem, src--; dst--; *dst = op(*dst, *src); ); \
   } \
   src += s_skip; \
   dst += d_skip; \
}

/*
#define Fast_Rop_decr_a_nm(op)    \
for (i=count; i>0; i--) { \
      LOOP(words_bef, *dst = op(*dst, *src); \
	   src --;   \
	   dst --;); \
      *dst = op (*dst, *src); \
      dst -= WORD_SZ; \
      src -= WORD_SZ; \
      LOOP(words_r, *((WORD *)dst) = op(*((WORD *)dst),*((WORD *)src)); \
	   src -= WORD_SZ; \
	   dst -= WORD_SZ;); \
      dst += WORD_SZ; \
      src += WORD_SZ; \
      LOOP(words_rem, \
	   src --;   \
	   dst --;   \
	   *dst = op(*dst, *src);); \
      src += s_skip; \
      dst += d_skip; \
}
*/


#else  
#define Rop_decr_a_nm(op)    \
for (i=count; i>0; i--) { \
      DATA *src_wdp = IS_SCREEN( src_map)? \
		  getdata( src+1-words, src_map->data, words)+words-1: src; \
      unsigned int bct = words; \
      DATA *dst_wdp = IS_SCREEN( dst_map)? \
		  getdatabkp( dst, dst_map->data, &bct): dst; \
      unsigned int wlf = words - bct; \
      LOOP(bct,*dst_wdp = op(*dst_wdp,*src_wdp); src_wdp -= 1; dst_wdp -= 1); \
      if( wlf) { \
            dst_wdp = getdatabkp( dst-bct, dst_map->data, NULL); 
            LOOP(wlf,*dst_wdp = op(*dst_wdp,*src_wdp); src_wdp -= 1; \
			dst_wdp -= 1); \
      } \
      src += s_skip - words;  dst += d_skip - words;       \
}
#endif



#define Rop_incr_m(op)    \
for (i=count; i>0; i--) { \
      osrc = src;  src += 1; \
      *dst = (op(*dst,(GETMSB(*osrc,lshift) | GETLSB(*src,rshift))) \
			& lmask) | (*dst & ~lmask); \
      dst += 1;  osrc += 1;  src += 1; \
      LOOP(words-2, \
		*dst = op(*dst,GETMSB(*osrc,lshift) | GETLSB(*src,rshift)); \
		dst += 1; osrc += 1; src += 1); \
      *dst = (op(*dst,(GETMSB(*osrc,lshift) | GETLSB(*src,rshift))) \
			& rmask) | (*dst & ~rmask); \
      src += s_skip;  dst += d_skip;       \
}



#define Rop_C(op)    for (i=count; i>0; i--) { \
      *dst = (op(*dst,color) & lmask) | (*dst & ~lmask); \
      dst += 1; \
      LOOP(words-2,*dst = op(*dst,color); dst += 1); \
      *dst = (op(*dst,color) & rmask) | (*dst & ~rmask); \
      dst += d_skip + 1;       \
}



#ifndef BANKED
#define Rop_C_nm(op)    \
for (i=count; i>0; i--) { \
      LOOP(words,*dst = op(*dst,color); dst += 1); \
      dst += d_skip;       \
}

#define Fast_Rop_C_nm(op) \
for (i=count; i>0; i--) {  \
   register int offset; \
   if (words_bef != (offset = ((~((unsigned long)dst)) + 1) & \
                        ((unsigned long)(WORD_SZ-1)))) \
   { \
       words_bef = offset; \
       words_r = (words - words_bef)/WORD_SZ; \
       words_rem = (words - words_bef)%WORD_SZ; \
   } \
   LOOP(words_bef, *dst = op(*dst, color); \
        dst ++;); \
   LOOP(words_r, *((WORD *)dst) = op(*((WORD *)dst), color_dash); \
	dst += WORD_SZ;); \
   LOOP(words_rem, *dst = op(*dst, color); \
	dst ++;); \
   dst += d_skip; \
}
#else  
#define Rop_C_nm(op) \
for (i=count; i>0; i--) { \
      unsigned int bct = words; \
      DATA *dst_wdp = IS_SCREEN( dst_map)? \
		getdatap( dst, dst_map->data, &bct): dst; \
      unsigned int wlf = words - bct; \
      LOOP(bct,*dst_wdp = op(*dst_wdp,color); dst_wdp += 1); \
      if( wlf) { \
		 dst_wdp = getdatap( dst+bct, dst_map->data, NULL); \
		 LOOP(wlf,*dst_wdp = op(*dst_wdp,color); dst_wdp += 1); \
      } \
      dst += d_skip + words;       \
}
#endif



#define Rop_decr_m(op)    \
for (i=count; i>0; i--) { \
      osrc = src;  osrc -= 1; \
      *dst = (op(*dst,(GETMSB(*osrc,lshift) | GETLSB(*src,rshift))) \
		& rmask) | (*dst & ~rmask); \
      dst -= 1;  osrc -= 1;  src -= 1; \
      LOOP(words-2, \
		*dst = op(*dst,GETMSB(*osrc,lshift) | GETLSB(*src,rshift)); \
		dst -= 1;  osrc -= 1;  src -= 1); \
      *dst = (op(*dst,(GETMSB(*osrc,lshift) | GETLSB(*src,rshift))) \
		& lmask) | (*dst & ~lmask); \
      src += s_skip;  dst += d_skip; \
}

#ifdef UNROLL
#define LOOP(n,s) { \
    register int cnt; \
    for (cnt=(n); cnt>=8; cnt-=8) { \
         s;s;s;s;s;s;s;s; \
    } \
    switch (cnt) { \
       case  7: s; case  6: s; case  5: s; case  4: s; \
       case  3: s; case  2: s; case  1: s; \
    } \
}
#else
#define LOOP(n,s) { \
    register int cnt; \
    for (cnt=(n); cnt>0; cnt--) { \
       s; \
    } \
}
#endif



#define SWITCH(op,func) 	\
switch(op&0xf) { 	\
case OPCODE(ZERO(DST,SRC)):	func(ZERO);	break;\
case OPCODE(NOR(DST,SRC)):	func(NOR);	break;\
case OPCODE(AND2(DST,SRC)):	func(AND2);	break;\
case OPCODE(NPROJ2(DST,SRC)):	func(NPROJ2);	break;\
case OPCODE(AND1(DST,SRC)):	func(AND1);	break;\
case OPCODE(NPROJ1(DST,SRC)):	func(NPROJ1);	break;\
case OPCODE(XOR(DST,SRC)):	func(XOR);	break;\
case OPCODE(NAND(DST,SRC)):	func(NAND);	break;\
case OPCODE(AND(DST,SRC)):	func(AND);	break;\
case OPCODE(NXOR(DST,SRC)):	func(NXOR);	break;\
case OPCODE(PROJ1(DST,SRC)):	                break;\
case OPCODE(OR2(DST,SRC)):	func(OR2);	break;\
case OPCODE(PROJ2(DST,SRC)):	func(PROJ2);	break;\
case OPCODE(OR1(DST,SRC)):	func(OR1);	break;\
case OPCODE(OR(DST,SRC)):	func(OR);	break;\
case OPCODE(ONE(DST,SRC)):	func(ONE);	break;\
} 


#define DO_BYTE(op) 	\
switch(op&0xf) { 	\
case OPCODE(ZERO(DST,SRC)):	*dst=ZERO(*dst,*src);	break;\
case OPCODE(NOR(DST,SRC)):	*dst=NOR(*dst,*src);	break;\
case OPCODE(AND2(DST,SRC)):	*dst=AND2(*dst,*src);	break;\
case OPCODE(NPROJ2(DST,SRC)):	*dst=NPROJ2(*dst,*src);	break;\
case OPCODE(AND1(DST,SRC)):	*dst=AND1(*dst,*src);	break;\
case OPCODE(NPROJ1(DST,SRC)):	*dst=NPROJ1(*dst,*src);	break;\
case OPCODE(XOR(DST,SRC)):	*dst=XOR(*dst,*src);	break;\
case OPCODE(NAND(DST,SRC)):	*dst=NAND(*dst,*src);	break;\
case OPCODE(AND(DST,SRC)):	*dst=AND(*dst,*src);	break;\
case OPCODE(NXOR(DST,SRC)):	*dst=NXOR(*dst,*src);	break;\
case OPCODE(PROJ1(DST,SRC)):	                break;\
case OPCODE(OR2(DST,SRC)):	*dst=OR2(*dst,*src);	break;\
case OPCODE(PROJ2(DST,SRC)):	*dst=PROJ2(*dst,*src);	break;\
case OPCODE(OR1(DST,SRC)):	*dst=OR1(*dst,*src);	break;\
case OPCODE(OR(DST,SRC)):	*dst=OR(*dst,*src);	break;\
case OPCODE(ONE(DST,SRC)):	*dst=ONE(*dst,*src);	break;\
} 


#define XWITCH(op,func)		 


static inline int 
is_congruent (unsigned long dst, unsigned long src) {

    unsigned long  res;
    res = dst ^ src;
    if ((res & ((unsigned long)(WORD_SZ-1))) != 0)
	return 0;
    else
	return 1;
  
}


int
mem_rop(dst_map,x_dst,y_dst,wide,high,op,src_map,x_src,y_src)
     BITMAP *dst_map;				 
     BITMAP *src_map;				 
     int x_dst,y_dst;				 
     int x_src,y_src;				 
     int wide,high;					 
     int op;						 
{
    register DATA *dst;		 
    register DATA *src = (DATA *) 0;		 
    register DATA *osrc;		 
    
    register int d_skip;		 
    register int s_skip;		 
    register int count=high;	 
    register int words;		 
    register int words_r;
    register int words_rem;
    register int words_bef;
    register DATA lmask;		 
    register DATA rmask;		 
    register int lshift;		 
    register int rshift;		 
    register int i;			 
    register DATA color;		 
    register unsigned WORD color_dash;
    
    register int mode=0;		 
    int depth = dst_map -> depth;	 


    if (src_map && zsrc[op&0xf]) {
	dprintf(stderr,"op=%d, setting src_map->NULL\n",op&0xf);
	src_map = BIT_NULL;		 
    }
    
    if (src_map &&  dst_map && depth != src_map->depth) {
	fprintf(stderr,"Incompatable depths: %d -> %d\n",
		src_map->depth, depth);
	return(-1);
    }
    
#ifdef INVERT
	 
    op = SWAPCOLOR(op);
#endif

#ifdef BANKED	 
    printf ("this is banked");
#endif

    if (!src_map && depth>1) {
	switch (OPCODE(op)) {
	  case OPCODE(0):
	    color = GETBCOLOR(op);
	    op = OPCODE(SRC);
	    break;
	  case OPCODE(~0):
	    color = GETFCOLOR(op);
	    op = OPCODE(SRC);
	    break;
	  case OPCODE(~SRC):
	  case OPCODE(~SRC | DST):
	  case OPCODE(~SRC | ~DST):
	  case OPCODE(DST & ~SRC):
	  case OPCODE(~DST & ~SRC):
	  case OPCODE(~SRC ^ DST):	 
	    color = GETBCOLOR(op);
	    op = rop_invert(op);
	    break;
	  default:							 
	    color =  GETFCOLOR(op);
	    break;
	}
#if LOGBITS > 3
	color = color | (color<<8);
#endif
#if LOGBITS > 4
	color = color | (color<<16);
#endif
    }
    
    if (depth==1) {

	if (!src_map)
	    op = PUTOP(nsrc[OPCODE(op)], op);
    }
    
    if (!src_map)
	mode |= SRC_COLOR;
    

#ifndef NOCLIP
	 

    if (wide<0) {
	dprintf(stderr,"Clip: w<0 (%d)\n",wide);
	x_dst += wide;
	wide = - wide;
    }
    
    if (count<0) {
	y_dst += count;
	count = - count;
	dprintf(stderr,"Clip: h<0 (%d)\n",count);
    }

    if (x_dst < 0) {
	dprintf(stderr,"Clip: x_dst<0 (%d)\n",x_dst);
	if (src_map)
	    x_src -= x_dst;
	wide += x_dst;
	x_dst = 0;
    }
    
    if (y_dst < 0) {
	dprintf(stderr,"Clip: y_dst<0 (%d)\n",y_dst);
	if (src_map)
	    y_src -= y_dst;
	count += y_dst;
	y_dst = 0;
    }

    if (src_map) {
	if (x_src < 0) {
	    dprintf(stderr,"Clip: x_src<0 (%d)\n",x_src);
	    x_dst -= x_src;
	    wide += x_src;
	    x_src = 0;
	}
	
	if (y_src < 0) {
	    dprintf(stderr,"Clip: y_src<0 (%d)\n",y_src);
	    y_dst-=y_src;
	    count+=y_src;
	    y_src=0;
	}
	
	if ((i = x_src+wide - src_map->wide) > 0) {
	    dprintf(stderr,"Clip: wide too big for src (%d->%d)\n",wide,wide-i);
	    wide -= i;
	}
	
	if ((i = y_src+count - src_map->high) > 0) {
	    dprintf(stderr,"Clip: high too big for src (%d->%d)\n",count,count-i);
	    count -= i;
	}
    }
    
    if ((i = x_dst + wide - dst_map->wide) > 0) {
	dprintf(stderr,"Clip: wide too big for dst_map (%d->%d)\n",wide,wide-i);
	wide -= i;
    }
    if ((i = y_dst + count - dst_map->high) > 0) {
	dprintf(stderr,"Clip: high too big for dst_map (%d->%d)\n",count,count-i);
	count -= i;
    }
    
    if (wide<1 || count < 1) {
	dprintf(stderr,"Clip: high or wide < 1 (%d,%d)\n",wide,count);
	return(-1);
    }
    

#endif

    /* four case
     * screen to scratch and vice versa 
     * screen to screen
     * scratch to scratch
     */

/*    
 *   if (BIT_STRIDE(dst_map) == stride) {
 */
    if (dst_map->type == _SCREEN) {
	/* bitblt to screen */
	x_dst += dst_map->x0;
	y_dst += dst_map->y0;
	
	wide *= depth;	
	x_dst *= depth;
	
	if (DOFLIP && dst_map->primary->type&_FLIP) {
	    flip(dst_map->data, dst_map->stride*dst_map->primary->high);
	    dst_map->primary->type &= 3;
	}
	
	words = ((x_dst+wide-1)>>LOGBITS) - (x_dst>>LOGBITS) + 1;
	lmask = GETLSB((DATA) ~0, (x_dst&BITS));
	rmask = GETMSB((DATA) ~0, (BITS - ((x_dst+wide-1)&BITS)));
	
	dst = dst_map->data + dst_map->stride*y_dst + (x_dst>>LOGBITS);
	d_skip = dst_map->stride;
	
    } else {
	/* bit blt to a scratch bitmap */
	x_dst += dst_map->x0;
	y_dst += dst_map->y0;
	
	wide *= depth;	
	x_dst *= depth;
	
	if (DOFLIP && dst_map->primary->type&_FLIP) {
	    flip(dst_map->data, BIT_LINE(dst_map)*dst_map->primary->high);
	    dst_map->primary->type &= 3;
	}
	
	words = ((x_dst+wide-1)>>LOGBITS) - (x_dst>>LOGBITS) + 1;
	lmask = GETLSB((DATA) ~0, (x_dst&BITS));
	rmask = GETMSB((DATA) ~0, (BITS - ((x_dst+wide-1)&BITS)));
	
	dst = dst_map->data + BIT_LINE(dst_map)*y_dst + (x_dst>>LOGBITS);
	d_skip = BIT_LINE(dst_map);
	
    }
	

    if (src_map) {


/*	if (BIT_STRIDE(src_map) == stride) { */
	if (src_map->type == _SCREEN) {
	    /* bit map from the screen */
	    if (DOFLIP && src_map->primary->type&_FLIP) {
		flip(src_map->data,src_map->stride*src_map->primary->high);
		src_map->primary->type &= 3;
	    }
	    
	    x_src += src_map->x0;
	    y_src += src_map->y0;
	    x_src *= depth;
	    src = src_map->data + src_map->stride*y_src + (x_src>>LOGBITS);
	    s_skip = src_map->stride;
	    
	} else { /* normal bit map */

	    if (DOFLIP && src_map->primary->type&_FLIP) {
		flip(src_map->data,BIT_LINE(src_map)*src_map->primary->high);
		src_map->primary->type &= 3;
	    }
	    
	    x_src += src_map->x0;
	    y_src += src_map->y0;
	    x_src *= depth;
	    src = src_map->data + BIT_LINE(src_map)*y_src + (x_src>>LOGBITS);
	    s_skip = BIT_LINE(src_map);
	}
	
	
	lshift = (x_src&BITS) - (x_dst&BITS);
	if (lshift > 0) {
	    rshift = (BITS+1) - lshift;
	} else  if (lshift < 0){
	    rshift = -lshift;
	    lshift = (BITS+1) - rshift;
	    src--;
	} else {
	    mode |= ALIGNED;
	}
	
	if (src_map->primary->data == dst_map->primary->data)
	    if (y_dst > y_src || (y_dst == y_src && x_dst > x_src))
		mode |= UPLEFT;
	
    }		 

    if (words <=1 ) {
	mode |= SMALL;
	lmask &= rmask;
    }
    if(mode & (SRC_COLOR|ALIGNED))	 
	if(lmask==(DATA)~0 && rmask==(DATA)~0)
	    mode |= NOMASK;

    if (src_map && (src_map->type & _TRANSPARENT_BG))
	mode |= TRANS_BG;

    switch(mode) {

      case TRANS_BG|ALIGNED|NOMASK:
      case TRANS_BG|ALIGNED:
      case TRANS_BG:
	color = GETFCOLOR(op);
	d_skip -= words;
	s_skip -= words;
	for (i=count; i>0; i--) { 
	    LOOP(words, *dst = (*dst & ~(*src)) | (color & *src); dst ++; src++); 
	    src += s_skip; 
	    dst += d_skip;
	}
	break;

      case SRC_COLOR:				 
	d_skip -= words;
	SWITCH(op,Rop_C);
	break;
	
      case SRC_COLOR|NOMASK:			 
	d_skip -= words;

	if (words <= (WORD_SZ << 3)) {
	    /* not worth optimizing if bytes < 8 * WORD_SZ */
	    SWITCH (op, Rop_C_nm);
	    break;
	}
	
	color_dash = (WORD)(color | (WORD)0);
	if (WORD_SZ == 4) {
	    color_dash |= (color_dash << 8);
	    color_dash |= (color_dash << 16);
	}

	words_bef = ((~((unsigned long)dst)) + 1) & 
	    ((unsigned long)(WORD_SZ-1));
	words_r = (words - words_bef)/WORD_SZ; 
	words_rem = (words - words_bef)%WORD_SZ; 
  
	SWITCH(op,Fast_Rop_C_nm);
	break;
	
      case SRC_COLOR|SMALL:			 
	SWITCH(op,Rop_sC);
	break;
	
      case SRC_COLOR|SMALL|NOMASK:		 
	SWITCH(op,Rop_sC_nm);
	break;
	
      case DOWNRIGHT:				 
	d_skip -= words - 1;
	s_skip -= words;
	SWITCH(op,Rop_incr_m);
	break;
	
      case DOWNRIGHT|SMALL:			 
      case UPLEFT|SMALL:
	if( (mode&UPLEFT)) {
	    dst += d_skip*(count-1);
	    d_skip = - d_skip;
	    src += s_skip*(count-1);
	    s_skip = - s_skip;
	}
	s_skip -= 1;
	SWITCH(op,Rop_s);
	break;
	
      case DOWNRIGHT|ALIGNED:			 
	d_skip -= words;
	s_skip -= words;
	SWITCH(op,Rop_incr_a);
	break;
	
      case DOWNRIGHT|ALIGNED|NOMASK:		 
	d_skip -= words;
	s_skip -= words;
	
	if (words <= (WORD_SZ << 3)) {
	    /* not worth optimizing if bytes < 8 * WORD_SZ */
	    SWITCH (op, Rop_incr_a_nm);
	    break;
	}

	words_bef = ((~((unsigned long)dst)) + 1) & 
	    ((unsigned long)(WORD_SZ-1));
	words_r = (words - words_bef)/WORD_SZ; 
	words_rem = (words - words_bef)%WORD_SZ; 
  
	/* Fast display */
	SWITCH (op, Fast_Rop_incr_a_nm);
	    
	break;
	
      case DOWNRIGHT|SMALL|ALIGNED:		 
      case UPLEFT|SMALL|ALIGNED:
	if ((mode&UPLEFT)) {
	    dst += d_skip*(count-1);
	    d_skip = - d_skip;
	    src += s_skip*(count-1);
	    s_skip = - s_skip;
	}
	SWITCH(op,Rop_sa);
	break;
	
      case DOWNRIGHT|SMALL|ALIGNED|NOMASK:	 
      case UPLEFT|SMALL|ALIGNED|NOMASK:
	if ((mode&UPLEFT)) {
	    dst += d_skip*(count-1);
	    d_skip = - d_skip;
	    src += s_skip*(count-1);
	    s_skip = - s_skip;
	}
	SWITCH(op,Rop_sa_nm);
	break;
	
      case UPLEFT:				 
	dst += d_skip*(count-1) + words - 1;
	d_skip = - d_skip + words - 1;
	src += s_skip*(count-1) + words;
	s_skip = - s_skip + words - 1;
	SWITCH(op,Rop_decr_m);
	break;
	
      case UPLEFT|ALIGNED:			 
	dprintf(stderr,"Hit UPLEFT|ALIGNED case\n");
	dst += d_skip*(count-1) + words - 1;
	d_skip = - d_skip + words;
	
	src += s_skip*(count-1) + words - 1;
	s_skip = - s_skip + words;
	SWITCH(op,Rop_decr_a);
	break;
	
      case UPLEFT|ALIGNED|NOMASK:		 
	dprintf(stderr,"Hit UPLEFT|ALIGNED|NOMASK case\n");
	dst += d_skip*(count-1) + words - 1;
	d_skip = - d_skip + words;
	
	src += s_skip*(count-1) + words - 1;
	s_skip = - s_skip + words;
	
	
	if (words <= (WORD_SZ << 3)) {
	    /* not worth optimizing if bytes < 8 * WORD_SZ */
	    SWITCH (op, Rop_decr_a_nm);
	    break;
	}
	
	words_bef = ((unsigned long)dst & (unsigned long)(WORD_SZ-1));
	words_r = (words-words_bef)/WORD_SZ;
	words_rem = (words-words_bef)%WORD_SZ;
	    
	/* Fast display */
	SWITCH (op, Fast_Rop_decr_a_nm);
	break;
	
      default:
	dprintf(stderr,"Invalid direction: 0x%x\n",mode);
	break;
    }
    return(0);
}


