/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: intersect.c,v $
 *
 * HISTORY
 * $\Log: intersect.c,v $
 * Revision 1.3  1998/01/31 18:43:11  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 */

/*{{{}}}*/
/*{{{  Notes*/

/* see if two windows intersect */
/*}}}  */

/*{{{  #includes*/
#include <bitblit.h>
#include <oskit/wimpi.h>
#include <stdio.h>
#include "defs.h"
#include <intersect.h>
/*}}}  */

/*{{{  intersect*/
int intersect(win1,win2) register WINDOW *win1, *win2;
{
	return 
        (!(
	    win1->x0 + BIT_WIDE(win1->border) < win2->x0 ||
	    win2->x0 + BIT_WIDE(win2->border) < win1->x0 ||
	    win1->y0 + BIT_HIGH(win1->border) < win2->y0 ||
	    win2->y0 + BIT_HIGH(win2->border) < win1->y0
        ));
}

/*}}}  */
/*{{{  alone -- see if any window intersects any other*/
int
alone(mr,check)
     wimpiSession mr;
     register WINDOW *check;
{
    register WINDOW *win;

    for(win=mr->active;win != (WINDOW *) 0;win=win->next)
	if (check!=win && intersect(check,win))
	    return(0);
    return(1);
}

/*}}}  */
/*{{{  mousein -- see if mouse is in window*/
int mousein(x,y,win,how)
register int x,y;
register WINDOW *win;
int how;		/* how:  0-> intersect   else -> point */
{
   if (how == 0)
	return(!(
	    x+16 < W(x0) || x > W(x0) + BIT_WIDE(win->border) ||
            y+16 < W(y0) || y > W(y0) + BIT_HIGH(win->border)
            ));
   else
	return(!(
	    x < W(x0) || x > W(x0) + BIT_WIDE(win->border) ||
            y < W(y0) || y > W(y0) + BIT_HIGH(win->border)
            ));
}
/*}}}  */
/*{{{  in_text -- see if mouse is in text region*/
int
in_text(x,y,win)
register int x,y;
register WINDOW *win;
   {
   if (W(text.wide)) {
      int x0 = W(x0)+W(text.x);
      int y0 = W(y0)+W(text.y);
      return(!(
	    x < x0 || x > x0 + W(text.wide) ||
            y < y0 || y > y0 + W(text.high)
            ));
      }
   else
      return(mousein(x,y,win,1));
   }
/*}}}  */
