/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: font_subs.h,v $
 *
 * HISTORY
 * $\Log: font_subs.h,v $
 * Revision 1.3  1998/01/31 18:43:08  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */

#ifndef FONT_SUBS_H
#define FONT_SUBS_H

#define H_SIZE	1999		/* size of hash table for cut/paste */

struct entry {
   unsigned char value;		/* character at this location */
   unsigned char type;          /* type: bold or underline */
   struct entry *next;		/* pntr to next char */
   };

#define	MAXGLYPHS	256

struct font {
   struct font_header head;	/* font header */
   BITMAP *data;		/* all the glyphs strung together */
   BITMAP **glyph;              /* pointers to individual glyphs */
   short ident;			/* font id */
   struct entry **table;	/* pointer to hash table for cut/paste */
   };

struct font *open_font(char *file);
void free_font(wimpiSession mr, struct font *dead_font);
int enhance_font(struct font *font);

#endif
