/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: defs.h,v $
 *
 * HISTORY
 * $\Log: defs.h,v $
 * Revision 1.5  1998/01/31 18:43:06  mjk
 * replaced copyright
 *
 * Revision 1.4  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.3  1997/12/12 17:54:55  acb
 * Add title bar color
 *
 * Revision 1.2  1997/06/09 22:05:00  acb
 * Added title bar info to window state.
 *
 * Revision 1.1  1997/05/30 21:41:24  acb
 * Initial revision
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 *
 * Revision 1.5  1997/01/14 18:20:46  bradym
 * Added PathQueue structure to stage.
 * Keep the numInserted and numRemoved fields up to date and set it to the
 * sink queue of the path.
 *
 * Revision 1.4  1997/01/07 15:36:00  acb
 * Added MODIFIER_ALT for key events.
 *
 * Revision 1.3  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.2  1996/11/04 19:40:54  bradym
 * Merged Window and Stage structs
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */


#ifndef defs_h
#define defs_h

/* bit blit uses stride/width depending on what the source bitmap is */
#define FROM_BIT        0
#define FROM_SCREEN     1
/* potentially changable defines for mgr */


#define MAXWIN 		24		/* Maximum number of windows */
					/* < getdtablesize()-5 */
#define MAXCLIENT	25		/* max number of client windows */
#define MAXESC		20		/* max number of leading esc. digits */
#define TEXT_COUNT	MAXESC-1	/* text download index */
#define MAXBUF		80		/* max chars put to window per cycle */
#define MAXSHELL	127		/* max chars read from shell at once (128 causes an error) ?! */
#define POLL_INT	0		/* us's of pause at each select */
#define MAXNAME		35		/* max argv[0] length */
#define MAXTTY		35		/* max tty device name length */
#define MAXFONT		100		/* # of different fonts */s
#define MAXMENU		20		/* max number of menus per window */
#define MAXBITMAPS	50		/* max number of bitmaps per window */
#define MAXITEMS	200		/* 2 * max # of menu items */
#define MAXEVENTS	22		/* max number of events, -4 thru 17,
					see event.h */
#define MIN_Y		1		/* minimum # of rows in a window */
#define MIN_X		5		/* min # of columns in a window */
#define MAX_PATH	100		/* max path length for font file */
#define GMAX		1000L		/* max graphics coordinate */
#define MOUSE_BUFF	30		/* size of mouse input buffer */
#define MSG_MODEMASK	02		/* invalid permission mask for tty */

#define STARTFILE	".mgrc"		/* name of mgr startup file */
#define HOST		"win "		/* name of host for utmp file */
#define DEFAULT_FONT	"DEFAULT_FONT"	/* default font environ variable (full path name) */
#define DUP_CHAR	'\005'		/* default dup character for DUPKEY mode */

#define COLORMAP_SIZE	10		/* max number of "built-in" colors */
#define LOGO_COLOR	0	/* foreground color for logo */
#define LOGO_COLOR_BG	1	/* background color for logo */
#define CR_COLOR	2	/* copyright foreground color */
#define CR_COLOR_BG	3	/* copyright background color (unused) */
#define MENU_COLOR_FG	4	/* menu fg color */
#define MENU_COLOR_BG	5	/* menu bg color */
#define ROOT_COLOR_FG	6	/* root window fg color */
#define ROOT_COLOR_BG	7	/* root window bg color */
#define TITLE_COLOR_BG  8       /* window title bg color */

#define MENU_COLOR(mr)	BUILDOP(BIT_SRC,(mr)->color_map[MENU_COLOR_FG],(mr)->color_map[MENU_COLOR_BG])/* menu colors */

#ifndef SUM_BDR		/* default thickness of window border on one side */
#define SUM_BDR		5		/* odd, so SUM_BDR-OUT_BDR > OUT_BDR */
#endif
#define OUT_BDR		((SUM_BDR)/2)	/* default thickness of outer border */
#define STRIPE		2		/* # windowless pixels on left */

/* these must match quit_menu[] in data.c */
#define M_CANCEL_NOP	0
#define M_LOCK		1		/* lock screen and wait for password */
#define M_SUSPEND	2		/* suspend instead of quit */
#define M_SPACE_NOP	3
#define M_QUIT		4		/* confirm quit choice */

#ifdef NO_STRCHR
#define strchr		index
#define strrchr		rindex
#endif

extern int MGRDebug;

#ifdef DEBUG
extern char MGRDebugLevel[];
char *strchr();
#define dbgprintf( level, arglist) \
	do{ if( MGRDebug && strchr( MGRDebugLevel, level)) fprintf arglist;}while(0)
#else
#define dbgprintf( level, arglist) /* nix */
#endif

/* macros -- for speed */

#ifdef FASTMOUSE
#define MoUSE(mr,m,a,b)     bit_blit(m, a, b, 16,16,BIT_XOR,(mr)->m_rop,0,0)
#define MOUSE_ON(mr,m,a,b)	{ if (!(mr)->mouse_on) { (mr)->mouse_on=1; MoUSE(mr,m,a,b); }}
#define MOUSE_OFF(mr,m,a,b) { if ((mr)->mouse_on) { (mr)->mouse_on=0; MoUSE(mr,m,a,b); }}
#else
/* turn on the mouse only if it is off */
#define MOUSE_ON(mr,m,a,b) { if (!(mr)->mouse_on) { (mr)->mouse_on=1; bit_blit((mr)->mouse_save,0,0,16,16,BIT_SRC,m,a,b); bit_blit(m,a,b,16,16,BIT_OR,(mr)->m_rop,0,0); bit_blit(m,a,b,16,16,BIT_NAND,(mr)->m_rop,0,16); } }
/* turn off the mouse only if it is on */
#define MOUSE_OFF(mr,m,a,b) { if ((mr)->mouse_on) { (mr)->mouse_on=0; bit_blit(m,a,b,16,16,BIT_SRC,(mr)->mouse_save,0,0); } }
#endif

#define CLEAR(s,op)	bit_blit((s),0,0,BIT_WIDE(s),BIT_HIGH(s),op,0,0,0);

#define BORDER_FAT 1
#define BORDER_THIN 0

     /*
#define ACTIVE_ON() \
			border(active,BORDER_FAT), \
			last_active = active!=last_active ? \
			  ( \
			  do_event(EVENT_DEACTIVATED,last_active,E_MAIN), \
			  do_event(EVENT_ACTIVATED,active,E_MAIN), \
			  active ) \
			: \
			  last_active
 			  	
			  */

#define ACTIVE_ON(mr) border((mr)->active,BORDER_FAT)
#define ACTIVE_OFF(mr) border((mr)->active,BORDER_THIN)

#define SETMOUSEICON(mr,x)	((mr)->m_rop = x) 
#define DEFAULT_MOUSE_CURSOR(mr) (((mr)->active&&(mr)->active->cursor)? (mr)->active->cursor: (mr)->mouse_arrow)

/* short hand */

#define Min(x,y)	((x)<(y)?(x):(y))
#define Max(x,y)	((x)>(y)?(x):(y))
#define W(x)		(win->x)
#define BETWEEN(a,x,b)	((x)<(a)?a:((x)>(b)?b:x))
#define ACTIVE(mr,x)	((mr)->active->x)
#define ABS(x)		((x)>0 ? (x) : -(x))
#define LIMIT(x,max)	((x)>(max)?1:(-(x)>(max)?-1:0))

/* mouse buttons */

#define BUTTON_SYS	4		/* system menu button */
#define BUTTON_2	2		/* middle button */
#define BUTTON_1	1		/* right button */

/* Window table flags */

#define W_ACTIVE	0x000001L	/* Window is non_occluded */
#define W_ESCAPE	0x000002L	/* An escape sequence is in progress */
#define W_STOPPED	0x000004L	/* Window is stopped ( unused ) */
#define W_REVERSE	0x000008L	/* window is white on black */
#define W_STANDOUT	0x000010L	/* window is in standout mode */
#define W_DIED		0x000020L	/* window has died */
#define W_EXPOSE	0x000040L	/* expose window upon shell output */
#define W_BACKGROUND	0x000080L	/* permit obscured window to update */
#define W_NOKILL	0x000100L	/* don't kill window upon exit */
#define W_VI		0x000200L	/* temporary vi hack -- */
#define W_TEXT		0x000400L	/* downloading text */
#define W_NOINPUT	0x000800L	/* don't accept keyboard input */
#define W_NOWRAP	0x001000L	/* don't auto wrap */
#define W_OVER		0x002000L	/* overstrike mode */
#define W_ABSCOORDS	0x004000L	/* use absolute coordinates */
#define W_MINUS		0x008000L	/* negative coord value */
#define W_SNARFABLE	0x000004L	/* ok to gather data into cut buffer */
#define W_SNARFLINES	0x010000L	/* snarf only lines */
#define W_SNARFTABS	0x020000L	/* change spaces to tabs in snarf */
#define W_SNARFHARD	0x040000L	/* snarf even if errors */
#define W_SNARFLAGS	(W_SNARFTABS | W_SNARFHARD | W_SNARFLINES)
#define W_INHERIT	0x080000L	/* inherit menus and bitmaps */
#define W_DUPKEY	0x100000L	/* duplicate key mode */
#define W_NOBUCKEY	0x200000L	/* Buckey keys (i.e. "Left-<char>" and
					"Right-<char>") have no effect */
#define W_CLIPDONE	0x400000L	/* clip list for background update valid */

/* new character attributes */

#define W_BOLD          0x800000L       /* bold face */
#define W_UNDER         0x1000000L      /* underlined */

/* new flag to control set_winsize kernel window size reporting */

#define W_NOREPORT      0x2000000L      /* don't report size changes to kernel */

#define W_CONSOLE	0x4000000L	/* redirect console to this device */

#define W_SPECIAL       (W_BOLD|W_UNDER)        /* special treatment */

#define W_LOOK \
	(W_EXPOSE | W_BACKGROUND)	/* Window ready to accept data */

#define W_STATE \
	(W_ESCAPE | W_TEXT)		/* terminal emulator states */

#define W_SAVE \
	(W_REVERSE | W_STANDOUT | W_EXPOSE | W_BACKGROUND | \
	 W_VI | W_NOINPUT | W_NOWRAP | \
	 W_SNARFLAGS | \
	 W_OVER | W_ABSCOORDS)		/* savable flags */

#define INIT_FLAGS	W_BACKGROUND	/* default window creation flags */

/* Structure definitions */

typedef struct {	/* used for text regions */
  int x,y,wide,high;
  } rectangle;

typedef struct  {	/* some day */
  int x,y;
  } point;


/* static data items (described in data.c) */

#include <sys/types.h>

#ifdef NEED_MORE_TYPES
typedef enum {
    FALSE = 0, TRUE
} bool;

#ifdef OSKIT
#include <oskit/types.h>

typedef oskit_s8_t      __s8;
typedef oskit_s16_t     __s16;
typedef oskit_s32_t     __s32;
typedef oskit_u8_t      __u8;
typedef oskit_u16_t     __u16;
typedef oskit_u32_t     __u32;
#endif

typedef union {
    char	c;
    short	s;
    int		i;
    long	l;
    u_char	uc;
    u_short	us;
    u_int	ui;
    u_long	ul;
    void *	p;
    char *	cp;
    short *	sp;
    int *	ip;
    long *	lp;
    u_char *	ucp;
    u_short *	usp;
    u_int *	uip;
    u_long *	ulp;
    __s8	s8;
    __s16	s16;
    __s32	s32;
    __u8	u8;
    __u16	u16;
    __u32	u32;
} AnyType; 

#define anyToAny(w,v)	({AnyType _a; _a.ul = 0; _a.w = (v); _a;})
#define charToAny(v)	anyToAny(c,v)
#define shortToAny(v)	anyToAny(s,v)
#define intToAny(v)	anyToAny(i,v)
#define longToAny(v)	anyToAny(l,v)
#define ptrToAny(v)	anyToAny(p,v)
#endif

#include <sys/time.h>

#define MODIFIER_NONE     0
#define MODIFIER_SHIFT    1
#define MODIFIER_CONTROL  2
#define MODIFIER_ALT      4

typedef struct WINDOW	WINDOW;

typedef int Window;

#include <oskit/wimpi.h>
#include <wimpi_input.h>

struct WINDOW {
    /* wimpi for this window, if one exists */
    wimpiToplevelWindow wimpi;
  
    unsigned int drawn;
    bool is_mapped;
    bool is_visible;
    bool exposed;
    bool has_border;
    bool outside_parent;
    bool no_expose_events;
    Window winId;
    char title[80];
    int  title_high;
    int max_wide, max_high;	/* Size window wants to be */

    /* Window state */
    WINDOW *next;	/* next window */
    WINDOW *prev;	/* previous window */

    /* Window hierarchy info */
    WINDOW *parent;
    WINDOW *next_sibling;
    WINDOW *prev_sibling;
    WINDOW *top_child;
    WINDOW *over;

    BITMAP *border;	/* window + border */
    BITMAP *window;	/* This is the window */
    BITMAP *save;		/* pointer to window bit-image if inactive */
    BITMAP *bitmap;	/* for use when downloading bitmaps */
    BITMAP *bitmaps[MAXBITMAPS];	/* scratchpad space */
    BITMAP *cursor;	/* bitmap of cursor */
    struct font *font;	/* this is the font */
    char *clip_list;	/* pointer to clip list for BG updates */
    
    rectangle text;	/* location of text region within window */
    int x0,y0;		/* origin of window on screen */
    int x,y;		/* cursor character position */
    int gx,gy;		/* graphics cursor */
    int op;		/* raster op function (see bitmap.h)  */
    int style;		/* character style normal/inverse video */
    int curs_type;	/* cursor type */

    int esc_cnt;		/* # of escape digits entered */
    int esc[MAXESC];	/* escape array (as in ESCnn,nnm) */
    int code;		/* code for text function */
    unsigned char dup;	/* char to duplicate from keyboard */
    
    unsigned char borderwid; /* width of one side of window border in pixels */
    unsigned char outborderwid; /* outer part of border width, when thin */
    /* need outborderwid <= borderwid-2 to preserve fat/thin relation */
    
    struct menu_state *menus[MAXMENU];	/* menus */
    short menu[2];	/* index into menus for current button 1&2 menu */
    long event_mask;	/* event mask  (see event.h) */
    
    unsigned long flags;	/* misc. window flags (see defines above) */
    
    /*** Most of the stuff beyond here is probably superfluous ***/

    char *events[MAXEVENTS];	/* place for event strings */
    char *snarf;		/* temporary snarf buffer */

    unsigned char buff[MAXSHELL];	/* shell input buffer */
    int  max;		/* the # of chars in buff */
    int  current;		/* the current char in buff */
    int  to_fd;		/* file descriptor to shell */
    int  from_fd;		/* file descriptor from shell */
    int  pid;		/* process number of the shell */
    int  setid;		/* window set id, 1..N, one per pid */
    int  num;		/* window number ( for multiple window/proc) */
    /* The window set id and the window number together
       uniquely identify a window. */
    
    char tty[MAXTTY];	/* name of shell's tty */

    WINDOW *stack;	/* stack of saved window environments */
    WINDOW *main;	/* main window (or 0 if main window ) */
    WINDOW *alt;	/* alternate window ( 0 if none) */
};

void new_window(), move_window();


#endif /* defs_h */


