/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: colormap.c,v $
 *
 * HISTORY
 * $\Log: colormap.c,v $
 * Revision 1.4  1998/01/31 18:43:04  mjk
 * replaced copyright
 *
 * Revision 1.3  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.2  1997/12/12 17:54:13  acb
 * Add title bar color
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.3  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.2  1996/10/24 06:29:57  davidm
 * (setpalette, getpalette): Reverse order of green/blue args so they match
 * 	the rest of the world (rgb).
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */


/* routines for allocating/freeing colors for use in windows */
#include <defs.h>
#include <bitblit.h>
#include <colormap.h>

#ifdef SVGALIB
#include <oskit/svgalib/vga.h>
#endif


#define SERVERID 0	/* setids are positive for windows */
#define FREE (-1)
#define UNINIT (-2)
#define LASTCOLOR 255
#define EXTMAXINTEN 15

static int *alloctab;
static int wob = 1;

static int eqcolor( unsigned int *c0, unsigned int *c1) {
    return c0[0]*c1[3] == c1[0]*c0[3]
	&& c0[1]*c1[3] == c1[1]*c0[3]
	&& c0[2]*c1[3] == c1[2]*c0[3];
}

static long int lightdiff( unsigned int *c0, unsigned int *c1) {
    return (long int)c0[0]*c1[3] - (long int)c1[0]*c0[3]
	 + (long int)c0[1]*c1[3] - (long int)c1[1]*c0[3]
	 + (long int)c0[2]*c1[3] - (long int)c1[2]*c0[3];
}

/* rescale computes a color index from the range [0..newmax]
   corresponding to a color index supplied in the range [0..oldmax].
   0 maps to 0 and oldmax maps to newmax.
   The expanding rescaling produces nearly equispaced outputs,
   and contracting rescaling maps nearly equal intervals to a single output.
   A rescaling followed by the reverse rescaling is a projection mapping.
 */
static
unsigned int rescale( unsigned int col, unsigned int oldmax,
                                        unsigned int newmax) {
    unsigned int newcol;

    if( newmax >= oldmax)
        newcol = oldmax? (col*2*newmax + oldmax) / (2*oldmax): newmax;
    else
        newcol = (col*2*(newmax + 1) + newmax) / (2*(oldmax + 1));
    return newcol;
}
/* rescale also in libbitblit, could move it out */

extern int wimpi_ext_palette;

void
setpalette (unsigned int index,
	    unsigned int red, unsigned int green, unsigned int blue,
	    unsigned int maxi) 
{
#ifdef SVGALIB
  if (wimpi_ext_palette)
      vga_setpalette(index, red, green, blue);
  else
      vga_setpalette(index, red >> 2, green >> 2, blue >> 2);
#endif

  return;
}

void
getpalette (unsigned int index,
	    unsigned int *red, unsigned int *green, unsigned int *blue,
	    unsigned int *maxi) 
{
#ifdef SVGALIB
    vga_getpalette(index, red, green, blue);
    maxi = wimpi_ext_palette ? 255 : 63;
#endif

  return;
}

/* fix me */
unsigned int fg_color_idx()
{ 
#ifdef SVGALIB
    return (vga_getcolors() - 1);
#endif
}  


void init_colors(BITMAP *bp) {
    unsigned int fgco = fg_color_idx();
    unsigned int c0[4], cfg[4];
    getpalette(0, c0, c0+1, c0+2, c0+3);    /* background color */
    getpalette(fgco, cfg, cfg+1, cfg+2, cfg+3); 
    
    
    if( c0[3] <= 1 || cfg[3] <= 1)  return;
    if( eqcolor( c0, cfg)) {
        setpalette(fgco, c0[3]-c0[0], c0[3]-c0[1], c0[3]-c0[2], c0[3]);
	getpalette(fgco, cfg, cfg+1, cfg+2, cfg+3);
	/* give up if no palette (or if fg = bg = 50% gray) */
	if( eqcolor( c0, cfg))  return;
    }
    wob = lightdiff( c0, cfg) <= 0;


    if (alloctab == NULL) { 
      unsigned int i;

      alloctab = (int*)malloc( (LASTCOLOR+1)*sizeof (*alloctab));
      if (alloctab == NULL) return;
      for( i = 0; i <= LASTCOLOR; i += 1)
	alloctab[i] = FREE;
      /* claim for server the colors it needs */
      alloctab[0] = SERVERID;
      alloctab[fgco] = SERVERID;
    }

}

/* set entire colormap to 2bitB x 3bitR x 3bitG true color */
/* choose from it colors for the server. */
void fill_colormap(wimpiSession mr,BITMAP *bp) {
    int i;

    if (alloctab == NULL) return;

    for( i = 0; i <= LASTCOLOR; i += 1) {
	unsigned int tc = wob? i: LASTCOLOR - i;
	unsigned int red, green, blue;

	blue  = rescale( ((tc >> 6) & 3), 3, LASTCOLOR);
	red   = rescale( ((tc >> 3) & 7), 7, LASTCOLOR);
	green = rescale( ((tc >> 0) & 7), 7, LASTCOLOR);
	setpalette(i, red, green, blue, LASTCOLOR);
    }

    mr->color_map[ROOT_COLOR_FG] = wob? 0205: LASTCOLOR-0205; /* dk cyan */
    alloctab[mr->color_map[ROOT_COLOR_FG]] = SERVERID;

    mr->color_map[ROOT_COLOR_BG] = wob? 0355: LASTCOLOR-0355; /* lt blue */
    alloctab[mr->color_map[ROOT_COLOR_BG]] = SERVERID;

    mr->color_map[MENU_COLOR_FG] = wob? 0347: LASTCOLOR-0347; /* lt grn */
    alloctab[mr->color_map[MENU_COLOR_FG]] = SERVERID;
    alloctab[LASTCOLOR - mr->color_map[MENU_COLOR_FG]] = SERVERID;

    mr->color_map[MENU_COLOR_BG] = wob? 0303: LASTCOLOR-0303; /* deep blue */
    alloctab[mr->color_map[MENU_COLOR_BG]] = SERVERID;
    alloctab[LASTCOLOR - mr->color_map[MENU_COLOR_BG]] = SERVERID;

    mr->color_map[TITLE_COLOR_BG] = 0213;
    alloctab[mr->color_map[TITLE_COLOR_BG]] = SERVERID;
}

void free_colors( WINDOW *win, unsigned int lo, unsigned int hi) {
    unsigned int i, ihi;
    int id;

    id = win? win->setid: SERVERID;
    ihi = (hi > LASTCOLOR)? LASTCOLOR: hi;
    for( i = lo; i <= ihi; i += 1)
	if( alloctab[ i] == id)
	    alloctab[ i] = FREE;
}


int allocate_color( WINDOW *win) {
    int id, k;

    id = win? win->setid: SERVERID;
    if( id == SERVERID) {
	for( k = LASTCOLOR; k > 0; k -= 1)
	    if( alloctab[ k] == FREE)
		break;
    } else {
	for( k = 0; k < LASTCOLOR; k += 1)
	    if( alloctab[ k] == FREE)
		break;
    }
    if( alloctab[k] == FREE) {
	alloctab[k] = id;
	return k;
    } else
	return -1;
}

static unsigned int medgray[4] = { 50, 50, 50, 100};

void findcolor(BITMAP *bp, unsigned int *co, unsigned int *r, unsigned int *g,
				  unsigned int *b, unsigned int *maxi) {

    /* simple stub */
    if( alloctab) {
	/* correct only as long as the true color colormap stays in effect */
	*co = (rescale(*r,*maxi,7)<<3)
	    | (rescale(*g,*maxi,7)<<0)
	    | (rescale(*b,*maxi,3)<<6);
	if(! wob)
	    *co = LASTCOLOR - *co;
    }
    else {
	unsigned int usercol[4];
	usercol[0] = *r;
	usercol[1] = *g;
	usercol[2] = *b;
	usercol[3] = *maxi;
	*co = (lightdiff( usercol, medgray) < 0)==wob? 0: fg_color_idx();
    }
    getpalette(*co,r,g,b,maxi);
}

