/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: clip.h,v $
 *
 * HISTORY
 * $\Log: clip.h,v $
 * Revision 1.4  1998/01/31 18:43:03  mjk
 * replaced copyright
 *
 * Revision 1.3  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.2  1997/06/09 22:02:52  acb
 * Turned off "ALWAYS_USE_SAVE_WINDOW" option for use with AWT.  Eventually
 * we may want to turn it back on since the rlogin and term windows display
 * text alot faster with it.
 *
 * Revision 1.1  1997/05/30 21:41:24  acb
 * Initial revision
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.3  1997/01/14 18:27:37  acb
 * * Clipping works now
 * * Performance enhancement -- terminal emulator avoids reads from
 *   framebuffer
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */


/* macros for determining clip rectangle for background updates */

typedef struct {		/* clipping rectangle */
  int x1,y1,x2,y2;
  } rect;

#if defined(DEBUG) && !defined(OSKIT)
#define SHOW_CLIP() \
	bit_blit(screen,W(x0)+W(borderwid)+clip.x1,W(y0)+W(borderwid)+clip.y1, \
	clip.x2-clip.x1,clip.y2-clip.y1, \
	BIT_NOT(BIT_DST),NULL,0,0);
#define SHOW() \
	if (MGRDebug && strchr(MGRDebugLevel,'c'))  \
		{ SHOW_CLIP();getchar();SHOW_CLIP(); }
#else
#define SHOW()
#endif


/* Use a save window even for active window -- avoids reading from
 * framebuffer on scroll, visual bell, etc.
 */
/* #define ALWAYS_USE_SAVE_WINDOW */

#ifdef ALWAYS_USE_SAVE_WINDOW
  #define Do_clip() (1)
#else
  #define Do_clip() \
	(W(flags)&W_BACKGROUND && !(W(flags)&W_ACTIVE))
#endif


#define Set_all() { \
	clip.x1 = 0, clip.y1=0; \
	clip.x2 = BIT_WIDE(W(border)); \
	clip.y2 = BIT_HIGH(W(border)); \
	SHOW(); \
        }

#define Set_clipall() { \
	clip.x2 = 0, clip.y2=0; \
	clip.x1 = BIT_WIDE(W(border)); \
	clip.y1 = BIT_HIGH(W(border)); \
        }

#define Set_clip(X1,Y1,X2,Y2) { \
	clip.x1 = Min(clip.x1,X1); \
	clip.y1 = Min(clip.y1,Y1); \
	clip.x2 = Max(clip.x2,X2); \
	clip.y2 = Max(clip.y2,Y2); \
	SHOW(); \
	}

#define Set_cliplow(X1,Y1) { \
	clip.x1 = Min(clip.x1,X1); \
	clip.y1 = Min(clip.y1,Y1); \
	SHOW(); \
	}

#define Set_cliphigh(X2,Y2) { \
	clip.x2 = Max(clip.x2,X2); \
	clip.y2 = Max(clip.y2,Y2); \
	SHOW(); \
	}

extern rect clip;
