/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: bit_create.c,v $
 *
 * HISTORY
 * $\Log: bit_create.c,v $
 * Revision 1.3  1998/01/31 18:43:02  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */


/*{{{}}}*/
/*{{{  #includes*/
#include <bitblit.h>
#include <share.h>
#include <stdlib.h>
/*}}}  */

/*{{{  bit_create -- create a bitmap as a sub-rectangle of another bitmap*/
BITMAP *bit_create(map, x, y, wide, high) BITMAP *map; int x, y, wide, high;
{
  BITMAP *result;

  if (x + wide > map->wide) wide = map->wide - x;
  if (y + high > map->high) high = map->high - y;
  if (wide < 1 || high < 1) return (BITMAP*)0;

  result = malloc(sizeof (BITMAP));
  if (result == (BITMAP *)0)
    return result;

  result->data = map->data;
  result->x0 = map->x0 + x;
  result->y0 = map->y0 + y;
  result->wide = wide;
  result->high = high;
  result->stride = BIT_STRIDE(map);
  result->depth = map->depth;
  result->primary = map->primary;
  result->cache = NULL;
  result->color = 0;
  result->id = map->id;
  result->type = map->type;
  result->deviceinfo = map->deviceinfo;
  return (result);
}





