/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: bit_alloc.c,v $
 *
 * HISTORY
 * $\Log: bit_alloc.c,v $
 * Revision 1.3  1998/01/31 18:43:01  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.2  1996/12/19  21:11:57  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */


/*{{{}}}*/
/*{{{  #includes*/
#include <sys/types.h>
#include <stdlib.h>
#include <bitblit.h>
#include <share.h>

/*}}}  */

/*{{{  bit_alloc -- allocate space for, and create a memory bitmap*/
BITMAP *bit_alloc(int wide, int high, DATA *data, unsigned char depth)
{
  register BITMAP *result;
  register int size;

  result = malloc(sizeof (BITMAP));
  if (result == (BITMAP *)0) {
    return result;
  }

  result->x0=0;
  result->y0=0;
  result->high=high;
  result->wide=wide;
  result->stride=wide;
  result->depth=depth;
  result->cache=NULL;
  result->color=0;

  size=bit_size(wide,high,depth);

  if (data != (DATA *) 0)
  {
    result->data = data;
    /* convert from external to internal format (if required) */
  }
  else
  {
    if ((result->data = (DATA *) malloc(size)) == (DATA *) 0)
    {
      free(result);
      return ((BITMAP *) 0);
    }
  }

  result->primary = result;
  result->type = _MEMORY;
  result->id = 0;	/* assign elsewhere? */
  result->deviceinfo = NULL;
  return (result);
}
