/* 
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 * @COPYRIGHT@
 *
 * $RCSfile: winmgr.h,v $
 *
 */
#ifndef __winmgr_h__
#define __winmgr_h__

#include <scout/path.h>
#include <scout/fifo.h>

typedef int Window;
#define MY_WINDOW 	0

typedef struct WinMgrIface *		WinMgrIface;
typedef struct WinMgrInfo *		WinMgrInfo;
typedef struct WinMgrColormapEntry *	WinMgrColormapEntry;
typedef struct WinMgrTimedImage *	WinMgrTimedImage;
typedef struct WinMgrAttr *		WinMgrAttr;

struct WinMgrColormapEntry {
    unsigned	index;
    unsigned	red;
    unsigned	green;
    unsigned	blue;
    unsigned    maxi;
};

struct WinMgrInfo {
    unsigned	stride;		/* distances to go for one line */
    unsigned	width;		/* framebuffer width in pixels */
    unsigned	height;		/* framebuffer height in pixels */
    unsigned    depth;
    void *	fbmem;		/* frame buffer memory */
    u_long	vsyncPeriod;	/* vertical sync period in usec */
};

struct WinMgrTimedImage {
    FIFOEl      fifo_next;      /* for the fifo queue */
    u_long	showtime;	/* vsync tick at which to display image */
    unsigned	owner;		/* don't touch---implementation detail */
    char	data[0];	/* really: width*height pixels */
};

struct WinMgrAttr {
    bool	has_border;
};

struct WinMgrIface {
    struct Iface	i;
  
    Window (*createWindow)(Iface self, Window parent, int x, int y, 
			   int width, int height, int color, WinMgrAttr attr);
    void (*destroyWindow)(Iface self, Window win);
    void (*mapWindow)(Iface self, Window win);
    void (*unmapWindow)(Iface self, Window win);
    void (*raiseWindow)(Iface self, Window win);
    void (*lowerWindow)(Iface self, Window win);
    void (*setWindowBackground)(Iface self, Window win, int color);
    void (*setForeground) (Iface self, Window win, int color);
    void (*clearArea)(Iface self, Window win, int x, int y, int width,
		      int height, bool exposures);
    void (*moveResizeWindow)(Iface self, Window win, int x, int y, int width,
			     int height);
    void (*fillRectangle)(Iface self, Window win, int x, int y, int wide, 
			  int high);
    void (*drawString)(Iface self, Window win, int x, int y, char *str,
		       int length);
    void (*drawLine)(Iface self, Window win, int x0, int y0, int x1, int y1);
    void (*drawArc)(Iface self, Window win, int x, int y, int wide, int high, 
		    int angle1, int angle2);
    void (*drawEllipse)(Iface self, Window win, int x, int y, int wide, 
			int high);
    void (*drawRectangle)(Iface self, Window win, int x, int y, int wide, 
			  int high);
    void (*putImage)(Iface iface, Window win, int x, int y, void * data, 
		     int wide, int high, unsigned depth);
    void (*copyArea)(Iface self, Window win, int src_x, int src_y, int width, 
		     int height, int dst_x, int dst_y);
    void (*setWindowTitle)(Iface iface, Window win, char *title);
    void (*putStr)(Iface self, Window win, char *str, int len);

    /* For NetTV */
    void (*makeChildWindow) (Iface self, Window parent, Iface child);
    
    /* Functions providing fast MPEG path to frame buffer */
    void (*resizeTimedImage)(Iface self, Window win, unsigned numImages,
			     unsigned width, unsigned height);
    u_long (*getTime)(Iface self);
    WinMgrTimedImage (*getTimedImage)(Iface self, Window win);
    void (*putTimedImage)(Iface self, Window win, WinMgrTimedImage i);
    void (*flushTimedImageQueue)(Iface self, Window win);
    void (*bitcreate)(Iface self, Window win, int depth);
};

#ifndef NDEBUG
extern struct Class	winMgrClassStruct;
#endif


extern Window 	winMgrCreateWindow (Iface self, Window parent, int x, int y, 
				    int width, int height, int color, 
				    WinMgrAttr attr);
extern void 	winMgrDestroyWindow (Iface self, Window win);
extern void     winMgrMapWindow (Iface self, Window win);
extern void     winMgrUnmapWindow (Iface self, Window win);
extern void     winMgrRaiseWindow (Iface self, Window win);
extern void     winMgrLowerWindow (Iface self, Window win);
extern void 	winMgrSetWindowBackground (Iface self, Window win, int clr);
extern void 	winMgrSetForeground (Iface self, Window win, int clr);
extern void 	winMgrClearArea (Iface self, Window win, int x, int y, 
				 int width, int height, bool exposures);
extern void	winMgrMoveResizeWindow (Iface self, Window win, int x, 
					int y, int width, int height);
extern void     winMgrFillRectangle (Iface self, Window win, int x, int y, 
				     int wide, int high);
extern void	winMgrDrawString (Iface self, Window win, int x, int y, 
				  char *str, int length);
extern void	winMgrDrawLine (Iface iface, Window win, int x0, int y0, 
				int x1, int y1);
extern void	winMgrDrawArc (Iface iface, Window win, int x, int y, 
			       int wide, int high, int angle1, int angle2);
extern void	winMgrDrawEllipse (Iface iface, Window win, int x, int y, 
				   int wide, int high);
extern void     winMgrDrawRectangle (Iface self, Window win, int x, int y, 
				     int wide, int high);
extern void	winMgrPutImage (Iface iface, Window win, int x, int y, 
				void * data, int wide, int high, 
				unsigned depth);
extern void	winMgrCopyArea (Iface self, Window win, int src_x, int src_y, 
				int width, int height, int dst_x, int dst_y);
extern void 	winMgrSetWindowTitle (Iface iface, Window win, char *title);
extern void     winMgrPutStr(Iface self, Window win, char * str, int len);

/* NetTV */
extern void 	winMgrMakeChildWindow (Iface self, Window parent, Iface child);

/* MPEG path */
extern unsigned	winMgrGetTime (Iface iface);
extern void	winMgrResizeTimedImage (Iface iface, Window win, 
					unsigned numImages,
					unsigned width, unsigned height);
extern WinMgrTimedImage winMgrGetTimedImage (Iface iface, Window win);
extern void	winMgrPutTimedImage (Iface iface, Window win, 
				     WinMgrTimedImage i);
extern void	winMgrFlushTimedImageQueue (Iface iface, Window win);
extern void     winMgrBitcreate (Iface self, Window win, int depth);

#include <scout/winmgr_p.h>

#endif /* __winmgr_h__ */



