/*
 * Copyright (c) 1999 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include <oskit/types.h>

#ifdef	NATIVE_BUILD
#define NATIVEOS(x)	native_##x
#else
#define NATIVEOS(x)	x
#endif


#ifdef	NEEDBSDTYPES
/*
 * Define BSD style types.
 */
typedef	oskit_s32_t	int32_t;
typedef	oskit_s64_t	int64_t;
typedef	oskit_u32_t	u_int32_t;
typedef	oskit_u16_t	u_int16_t;
typedef	oskit_u8_t	u_int8_t;
typedef	oskit_u8_t	u_char;
typedef	oskit_u16_t	u_short;
typedef	oskit_u32_t	u_int;
typedef	oskit_u32_t	u_long;
typedef	oskit_s8_t *	caddr_t;

/*
 * Structure defined by POSIX.4 to be like a timeval.
 */
struct timespec {
        time_t  tv_sec;         /* seconds */
        long    tv_nsec;        /* and nanoseconds */
};
#endif


#ifdef NATIVE_BUILD
int		NATIVEOS(fchdir)();
int		NATIVEOS(close)();
int		NATIVEOS(connect)();
int		NATIVEOS(accept)();
int		NATIVEOS(recvfrom)();
int		NATIVEOS(sendto)();
int		NATIVEOS(stat)();
int		NATIVEOS(lstat)();
int		NATIVEOS(mkdir)();
int		NATIVEOS(stat)();
int		NATIVEOS(chmod)();
int		NATIVEOS(chown)();
int		NATIVEOS(access)();
int		NATIVEOS(readlink)();
int		NATIVEOS(fsync)();
int		NATIVEOS(mkdir)();
int		NATIVEOS(rmdir)();
int		NATIVEOS(read)();
int		NATIVEOS(write)();
int		NATIVEOS(open)();
int		NATIVEOS(unlink)();
int		NATIVEOS(link)();
oskit_u64_t	NATIVEOS(lseek)(int, oskit_u64_t, int);
int		NATIVEOS(symlink)();
int		NATIVEOS(getdirentries)();
int		NATIVEOS(truncate)(char *, int, oskit_u64_t);
int		NATIVEOS(rename)();
int		NATIVEOS(utimes)();
int		NATIVEOS(gettimeofday)();
int		NATIVEOS(sigprocmask)();
int		NATIVEOS(select)();
int		NATIVEOS(sigaction)();
#endif
