#include "asm/posix_types.h"
#include "gnu/types.h"

/*
 * Included from /usr/include/fcntlbits.h, glibc 2.0.7v.
 */
/* O_*, F_*, FD_* bit values for Linux.
   Copyright (C) 1995, 1996, 1997 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#define O_RDONLY            00
#define O_WRONLY            01
#define O_RDWR              02
#define O_CREAT           0100  /* not fcntl */
#define O_EXCL            0200  /* not fcntl */
#define O_NOCTTY          0400  /* not fcntl */
#define O_TRUNC          01000  /* not fcntl */
#define O_APPEND         02000
#define O_NONBLOCK       04000

#define O_NDELAY        O_NONBLOCK
#define O_SYNC          010000
#define O_FSYNC         O_SYNC
#define O_ASYNC         020000

#define F_DUPFD         0       /* dup */
#define F_GETFD         1       /* get f_flags */
#define F_SETFD         2       /* set f_flags */
#define F_GETFL         3       /* more flags (cloexec) */
#define F_SETFL         4
#define F_GETLK         5
#define F_SETLK         6
#define F_SETLKW        7

#define F_SETOWN        8       /*  for sockets. */
#define F_GETOWN        9       /*  for sockets. */

#include "direntry.h"

#define DIRENTNAMLEN(x) strlen((x)->d_name)
#define DIRENTINO(x) (x)->d_ino

#include "statbuf.h"

#define STATATIMESEC(x) (x).st_atime
#define STATATIMENSEC(x) 0
#define STATMTIMESEC(x) (x).st_mtime
#define STATMTIMENSEC(x) 0
#define STATCTIMESEC(x) (x).st_ctime
#define STATCTIMENSEC(x) 0


