/*
 * From: /usr/include/sys/signal.h
 */
#define SIGHUP  1       /* hangup */
#define SIGINT  2       /* interrupt */
#define SIGQUIT 3       /* quit */
#define SIGILL  4       /* illegal instruction (not reset when caught) */
#ifndef _POSIX_SOURCE
#define SIGTRAP 5       /* trace trap (not reset when caught) */
#endif
#define SIGABRT 6       /* abort() */
#ifndef _POSIX_SOURCE
#define SIGIOT  SIGABRT /* compatibility */
#define SIGEMT  7       /* EMT instruction */
#endif
#define SIGFPE  8       /* floating point exception */
#define SIGKILL 9       /* kill (cannot be caught or ignored) */
#ifndef _POSIX_SOURCE
#define SIGBUS  10      /* bus error */
#endif 
#define SIGSEGV 11      /* segmentation violation */
#ifndef _POSIX_SOURCE 
#define SIGSYS  12      /* non-existent system call invoked */
#endif
#define SIGPIPE 13      /* write on a pipe with no one to read it */ 
#define SIGALRM 14      /* alarm clock */
#define SIGTERM 15      /* software termination signal from kill */
#ifndef _POSIX_SOURCE 
#define SIGURG  16      /* urgent condition on IO channel */
#endif
#define SIGSTOP 17      /* sendable stop signal not from tty */
#define SIGTSTP 18      /* stop signal from tty */
#define SIGCONT 19      /* continue a stopped process */
#define SIGCHLD 20      /* to parent on child stop or exit */
#define SIGTTIN 21      /* to readers pgrp upon background tty read */
#define SIGTTOU 22      /* like TTIN for output if (tp->t_local&LTOSTOP) */
#ifndef _POSIX_SOURCE
#define SIGIO   23      /* input/output possible signal */
#define SIGXCPU 24      /* exceeded CPU time limit */
#define SIGXFSZ 25      /* exceeded file size limit */
#define SIGVTALRM 26    /* virtual time alarm */
#define SIGPROF 27      /* profiling time alarm */
#define SIGWINCH 28     /* window size changes */
#define SIGINFO 29      /* information request */ 
#endif 
#define SIGUSR1 30      /* user defined signal 1 */
#define SIGUSR2 31      /* user defined signal 2 */

#define NSIG 32
/*
 * end of excerpt from sys/signal.h
 */

#define sigaddset(set, signo)   (*(set) |= 1 << ((signo) - 1), 0)
#define sigdelset(set, signo)   (*(set) &= ~(1 << ((signo) - 1)), 0)
#define sigemptyset(set)        (*(set) = 0, 0)
#define sigfillset(set)         (*(set) = ~(sigset_t)0, 0)
#define sigismember(set, signo) ((*(set) & (1 << ((signo) - 1))) != 0)

#define SIG_BLOCK       1       /* block specified signal set */
#define SIG_UNBLOCK     2       /* unblock specified signal set */
#define SIG_SETMASK     3       /* set specified signal set */


#if defined (__STDC__)
#  if !defined (__P)
#    define __P(protos) protos
#  endif
#else /* !__STDC__ */
#  if !defined (__P)
#    define __P(protos) ()
#  endif
#endif

typedef unsigned int sigset_t;
typedef void __sighandler_t __P((int));

#define SIG_DFL         ((__sighandler_t *)0)
#define SIG_IGN         ((__sighandler_t *)1)
#define SIG_ERR         ((__sighandler_t *)-1)


/*
 * Signal vector "template" used in sigaction call.
 */
struct  sigaction {
    __sighandler_t *sa_handler;     /* signal handler */
    sigset_t sa_mask;               /* signal mask to apply */
    int     sa_flags;               /* see signal options below */
};

/*
 * Flags for sigprocmask:
 */
#define SIG_BLOCK       1       /* block specified signal set */
#define SIG_UNBLOCK     2       /* unblock specified signal set */
#define SIG_SETMASK     3       /* set specified signal set */


/*
 * Information pushed on stack when a signal is delivered.
 * This is used by the kernel to restore state following
 * execution of the signal handler.  It is also made available
 * to the handler to allow it to restore state properly if
 * a non-standard exit is performed.
 */
struct  native_sigcontext {
    int     sc_onstack;             /* sigstack state to restore */
    int     sc_mask;                /* signal mask to restore */
    int     sc_esp;                 /* machine state */
        int     sc_ebp;
        int     sc_isp;
        int     sc_eip;
        int     sc_efl;
        int     sc_es;
        int     sc_ds;
        int     sc_cs;
        int     sc_ss;
        int     sc_edi;
        int     sc_esi;
        int     sc_ebx;
        int     sc_edx;
        int     sc_ecx;
        int     sc_eax;
        int     sc_gs;
        int     sc_fs;
#  define sc_sp sc_esp
#  define sc_fp sc_ebp
#  define sc_pc sc_eip
#  define sc_ps sc_efl
#  define sc_eflags     sc_efl
        int     sc_trapno;
        int     sc_err;
};


struct  sigaltstack {
    char    *ss_sp;                 /* signal stack base */
    size_t  ss_size;                /* signal stack length */
    int     ss_flags;               /* SS_DISABLE and/or SS_ONSTACK */
};
