#ifndef _BSD_NATIVE_TYPES_
#define _BSD_NATIVE_TYPES_


#define _BSD_OFF_T_	int64_t		/* file offset */
#define _BSD_PID_T_     int             /* process [group] */

typedef u_int32_t       fixpt_t;        /* fixed point number */
typedef long            key_t;          /* IPC key (for Sys V IPC) */
#ifdef __alpha__                /* XXX should be in <machine/types.h> */
typedef int64_t         segsz_t;        /* segment size */
#else
typedef int32_t         segsz_t;        /* segment size */
#endif
typedef int32_t         swblk_t;        /* swap offset */


#endif /* _BSD_NATIVE_TYPES_ */


/*
 * These are some fcntl.h flags that are different in the Oskit headers
 */
#define	O_RDONLY	0x0000		/* open for reading only */
#define	O_WRONLY	0x0001		/* open for writing only */
#define	O_RDWR		0x0002		/* open for reading and writing */
#define	O_APPEND	0x0008		/* set append mode */
#define	O_CREAT		0x0200		/* create if nonexistent */
#define	O_TRUNC		0x0400		/* truncate to zero length */
#define	O_EXCL		0x0800		/* error if already exists */

/*
 * Kernel encoding of open mode; separate read and write bits that are
 * independently testable: 1 greater than the above.
 *
 * XXX
 * FREAD and FWRITE are excluded from the #ifdef KERNEL so that TIOCFLUSH,
 * which was documented to use FREAD/FWRITE, continues to work.
 */
#ifndef _POSIX_SOURCE
#define FREAD           0x0001
#define FWRITE          0x0002
#endif
#define O_NONBLOCK      0x0004          /* no delay */
#define O_APPEND        0x0008          /* set append mode */
#ifndef _POSIX_SOURCE
#define O_SHLOCK        0x0010          /* open with shared file lock */
#define O_EXLOCK        0x0020          /* open with exclusive file lock */
#define O_ASYNC         0x0040          /* signal pgrp when data ready */
#define O_FSYNC         0x0080          /* synchronous writes */
#define O_NOFOLLOW      0x0100          /* don't follow symlinks */
#endif
#define O_CREAT         0x0200          /* create if nonexistent */
#define O_TRUNC         0x0400          /* truncate to zero length */
#define O_EXCL          0x0800          /* error if already exists */
#ifdef KERNEL
#define FMARK           0x1000          /* mark during gc() */
#define FDEFER          0x2000          /* defer for next gc pass */
#define FHASLOCK        0x4000          /* descriptor holds advisory lock */
#endif


/*
 * oskit header defs are different than FreeBSD. Looks like we can include
 * this directly since we don't use any of the structures.
 */
/*
 * Constants used for fcntl(2)
 */

/* command values */
#define F_DUPFD         0               /* duplicate file descriptor */
#define F_GETFD         1               /* get file descriptor flags */
#define F_SETFD         2               /* set file descriptor flags */
#define F_GETFL         3               /* get file status flags */
#define F_SETFL         4               /* set file status flags */
#ifndef _POSIX_SOURCE
#define F_GETOWN        5               /* get SIGIO/SIGURG proc/pgrp */
#define F_SETOWN        6               /* set SIGIO/SIGURG proc/pgrp */
#endif
#define F_GETLK         7               /* get record locking information */
#define F_SETLK         8               /* set record locking information */
#define F_SETLKW        9               /* F_SETLK; wait if blocked */

/* file descriptor flags (F_GETFD, F_SETFD) */
#define FD_CLOEXEC      1               /* close-on-exec flag */

/* record locking flags (F_GETLK, F_SETLK, F_SETLKW) */
#define F_RDLCK         1               /* shared or read lock */
#define F_UNLCK         2               /* unlock */
#define F_WRLCK         3               /* exclusive or write lock */


struct native_dirent {
    u_int32_t d_fileno;             /* file number of entry */
    u_int16_t d_reclen;             /* length of this record */
    u_int8_t  d_type;               /* file type, see below */
    u_int8_t  d_namlen;             /* length of string in d_name */
#ifdef _POSIX_SOURCE
    char    d_name[255 + 1];        /* name must be no longer than this */
#else
#define MAXNAMLEN       255
    char    d_name[MAXNAMLEN + 1];  /* name must be no longer than this */
#endif
};

#define DIRENTNAMLEN(x) (x)->d_namlen 
#define DIRENTINO(x) (x)->d_fileno


struct native_stat {
        dev_t     st_dev;               /* inode's device */ 
        ino_t     st_ino;               /* inode's number */
        mode_t    st_mode;              /* inode protection mode */
        nlink_t   st_nlink;             /* number of hard links */
        uid_t     st_uid;               /* user ID of the file's owner */
        gid_t     st_gid;               /* group ID of the file's group */
        dev_t     st_rdev;              /* device type */
#ifndef _POSIX_SOURCE 
        struct  timespec st_atimespec;  /* time of last access */  
        struct  timespec st_mtimespec;  /* time of last data modification */
        struct  timespec st_ctimespec;  /* time of last file status change */
#else 
        time_t    st_atime;             /* time of last access */
        long      st_atimensec;         /* nsec of last access */
        time_t    st_mtime;             /* time of last data modification */
        long      st_mtimensec;         /* nsec of last data modification */
        time_t    st_ctime;             /* time of last file status change */
        long      st_ctimensec;         /* nsec of last file status change */
#endif
        off_t     st_size;              /* file size, in bytes */
        int64_t   st_blocks;            /* blocks allocated for file */
        u_int32_t st_blksize;           /* optimal blocksize for I/O */ 
        u_int32_t st_flags;             /* user defined flags for file */
        u_int32_t st_gen;               /* file generation number */ 
        int32_t   st_lspare; 
        int64_t   st_qspare[2];
}; 


#define STATATIMESEC(x) (x).st_atimespec.tv_sec
#define STATATIMENSEC(x) (x).st_atimespec.tv_nsec
#define STATMTIMESEC(x) (x).st_mtimespec.tv_sec
#define STATMTIMENSEC(x) (x).st_mtimespec.tv_nsec
#define STATCTIMESEC(x) (x).st_ctimespec.tv_sec
#define STATCTIMENSEC(x) (x).st_ctimespec.tv_nsec
