/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 *
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: mgrEvent.h,v $
 *
 */
#ifndef __wimpievent_h__
#define __wimpievent_h__

#include <defs.h>

typedef enum { 
    KEYPRESS_EVENT, 
    BUTTON_DOWN_EVENT,
    BUTTON_UP_EVENT,
    MOUSE_MOVE_EVENT,
    MOUSE_DRAG_EVENT,
    EXPOSE_EVENT,
    WINDOW_MOVE_RESIZE_EVENT,
    WINDOW_DESTROY_EVENT 
} wimpiEventType;

typedef struct {
    unsigned char the_char;
} wimpiKeyEvent;

typedef struct {
    int button;
    int x, y;
/* XXX
  struct Time time;
  */
} wimpiMouseEvent;

typedef struct {
    int x, y;
    int wide, high;
} wimpiWindowMoveResizeEvent;

typedef struct {
    int count;
} wimpiExposeEvent;

typedef struct wimpiEvent      *wimpiEvent;
typedef long (*wimpiEventHandler)(wimpiToplevelWindow,wimpiEvent);

struct wimpiEvent {
  wimpiEventType type;
  Window winId;
  union {
    wimpiKeyEvent keyEvent;
    wimpiMouseEvent mouseEvent;
    wimpiExposeEvent exposeEvent;
    wimpiWindowMoveResizeEvent moveResizeEvent;
  } event;
  wimpiEvent next;		/* for linked list of events */
};

extern long wimpiEventDeliver (wimpiToplevelWindow w, wimpiEvent event);

#endif

