/*
 * Copyright (c) 1997, 1998, 1999 The University of Utah and the Flux Group.
 * 
 * This file is part of the OSKit Linux Glue Libraries, which are free
 * software, also known as "open source;" you can redistribute them and/or
 * modify them under the terms of the GNU General Public License (GPL),
 * version 2, as published by the Free Software Foundation (FSF).
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * Global symbol definitions to be included in all Linux fs or dev code.
 * These defines add OSKIT_LINUX_ prefixes to global Linux symbols
 * to ensure namespace cleanliness and prevent linking conflicts.
 * The Linux drivers themselves and the Linux glue code
 * should still continue to use the unprefixed names.
 */
/*
 * The symbols here are the ones from
 *
 *	$(OSKIT_SRCDIR)/linux/shared
 *	$(OSKIT_SRCDIR)/linux/shared/libc
 *	$(OSKIT_SRCDIR)/linux/src/lib
 *	$(OSKIT_SRCDIR)/linux/src/arch/i386/lib
 *	$(OSKIT_SRCDIR)/linux/src/arch/i386/kernel
 *
 * This was generated with the global.h.sh script.
 */
#ifndef _LINUX_SHARED_GLOBAL_H_
#define _LINUX_SHARED_GLOBAL_H_

#define BIOS_START OSKIT_LINUX_BIOS_START
#define ___strtok OSKIT_LINUX____strtok
#define __down OSKIT_LINUX___down
#define __get_free_pages OSKIT_LINUX___get_free_pages
#define __up OSKIT_LINUX___up
#define __wait_on_buffer OSKIT_LINUX___wait_on_buffer
#define _ctmp OSKIT_LINUX__ctmp
#define _ctype OSKIT_LINUX__ctype
#define _doprnt OSKIT_LINUX__doprnt
#define _doprnt_truncates OSKIT_LINUX__doprnt_truncates
#define current OSKIT_LINUX_current
#define down_failed OSKIT_LINUX_down_failed
#define free_pages OSKIT_LINUX_free_pages
#define high_memory OSKIT_LINUX_high_memory
#define interruptible_sleep_on OSKIT_LINUX_interruptible_sleep_on
#define jiffies OSKIT_LINUX_jiffies
#define kdevname OSKIT_LINUX_kdevname
#define kfree OSKIT_LINUX_kfree
#define kmalloc OSKIT_LINUX_kmalloc
#define linux_cli OSKIT_LINUX_linux_cli
#define linux_restore_flags OSKIT_LINUX_linux_restore_flags
#define linux_save_flags OSKIT_LINUX_linux_save_flags
#define linux_sti OSKIT_LINUX_linux_sti
#define linux_oskit_osenv_device OSKIT_LINUX_linux_oskit_osenv_device
#define linux_oskit_osenv_driver OSKIT_LINUX_linux_oskit_osenv_driver
#define linux_oskit_osenv_intr OSKIT_LINUX_linux_oskit_osenv_intr
#define linux_oskit_osenv_ioport OSKIT_LINUX_linux_oskit_osenv_ioport
#define linux_oskit_osenv_irq OSKIT_LINUX_linux_oskit_osenv_irq
#define linux_oskit_osenv_isa OSKIT_LINUX_linux_oskit_osenv_isa
#define linux_oskit_osenv_log OSKIT_LINUX_linux_oskit_osenv_log
#define linux_oskit_osenv_mem OSKIT_LINUX_linux_oskit_osenv_mem
#define linux_oskit_osenv_pci_config OSKIT_LINUX_linux_oskit_osenv_pci_config
#define linux_oskit_osenv_sleep OSKIT_LINUX_linux_oskit_osenv_sleep
#define linux_oskit_osenv_timer OSKIT_LINUX_linux_oskit_osenv_timer
#define loops_per_sec OSKIT_LINUX_loops_per_sec
#define oskit_linux_init OSKIT_LINUX_oskit_linux_init
#define oskit_linux_osenv_init OSKIT_LINUX_oskit_linux_osenv_init
#define oskit_linux_mem_alloc OSKIT_LINUX_oskit_linux_mem_alloc
#define oskit_linux_mem_free OSKIT_LINUX_oskit_linux_mem_free
#define panic OSKIT_LINUX_panic
#define printk OSKIT_LINUX_printk
#define schedule OSKIT_LINUX_schedule
#define simple_strtoul OSKIT_LINUX_simple_strtoul
#define sleep_on OSKIT_LINUX_sleep_on
#define snprintf OSKIT_LINUX_snprintf
#define sprintf OSKIT_LINUX_sprintf
#define unlock_buffer OSKIT_LINUX_unlock_buffer
#define up_wakeup OSKIT_LINUX_up_wakeup
#define verify_area OSKIT_LINUX_verify_area
#define vmalloc OSKIT_LINUX_vmalloc
#define vsnprintf OSKIT_LINUX_vsnprintf
#define vsprintf OSKIT_LINUX_vsprintf
#define wake_up OSKIT_LINUX_wake_up

#endif /* _LINUX_SHARED_GLOBAL_H_ */
