/*
 * Copyright (c) 1997, 1998 The University of Utah and the Flux Group.
 * 
 * This file is part of the OSKit Linux Glue Libraries, which are free
 * software, also known as "open source;" you can redistribute them and/or
 * modify them under the terms of the GNU General Public License (GPL),
 * version 2, as published by the Free Software Foundation (FSF).
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * Random glue code.
 */

#include <oskit/c/stdlib.h>

#include <linux/mm.h>
#include <linux/swapctl.h>
#include <linux/sched.h>

/* Linux uses this for inode versions. */
unsigned long event = 0;

/* min_free_pages is arbitrary. */
int min_free_pages = 20;

/* nr_free_pages is only compared to min_free_pages, so we kludge it to 1000 */
int nr_free_pages = 1000;

/* mem_map is only indexed by MAP_NR, which we make always return 0. */
static mem_map_t mem_map_init = {
	NULL,				/* next */
	NULL,				/* prev */
	NULL,				/* inode */
	0,				/* offset */
	0,				/* next_hash */
	1,				/* count */
	0,				/* flags */
	0,0,				/* dirty,age */
	NULL,				/* wait */
	NULL,				/* prev_hash */
	NULL,				/* buffers */
	0,				/* swap_unlock_entry */
	0,				/* map_nr */
};
mem_map_t *mem_map = &mem_map_init;

DECLARE_TASK_QUEUE(tq_disk);

swap_control_t swap_control = {
	20, 3, 1, 3,		/* Page aging */
	10, 2, 2, 4,		/* Buffer aging */
	32, 4,			/* Aging cluster */
	8192, 8192,		/* Pageout and bufferout weights */
	-200,			/* Buffer grace */
	1, 1,			/* Buffs/pages to free */
	RCL_ROUND_ROBIN		/* Balancing policy */
};

/* These are referenced by some of the fs files but shouldn't ever be used. */
struct inode_operations chrdev_inode_operations = { NULL, NULL, };
struct inode_operations blkdev_inode_operations = { NULL, NULL, };

/* Linux changes this with sysctl calls, we leave it zero. */
int securelevel = 0;

/* This is supposed to contain timezone info. */
struct timezone sys_tz = {0,0};

/*
 * Taken verbatim from Linux's fs/open.c.
 */
int
do_truncate(struct inode *inode, unsigned long length)
{
	int error;
	struct iattr newattrs;

	down(&inode->i_sem);
	newattrs.ia_size = length;
	newattrs.ia_valid = ATTR_SIZE | ATTR_CTIME;
	error = notify_change(inode, &newattrs);
	if (!error) {
		/* truncate virtual mappings of this file */
#ifndef OSKIT_FS
		vmtruncate(inode, length);
#endif
		if (inode->i_op && inode->i_op->truncate)
			inode->i_op->truncate(inode);
	}
	up(&inode->i_sem);
	return error;
}

/*
 * Verbatim from Linux's kernel/sys.c.
 */
int in_group_p(gid_t grp)
{
	int	i;

	if (grp == current->fsgid)
		return 1;

	for (i = 0; i < NGROUPS; i++) {
		if (current->groups[i] == NOGROUP)
			break;
		if (current->groups[i] == grp)
			return 1;
	}
	return 0;
}

/*
 * Verbatim from Linux's fs/open.c.
 */
void __fput(struct file *filp, struct inode *inode)
{
	if (filp->f_op && filp->f_op->release)
		filp->f_op->release(inode,filp);
	filp->f_inode = NULL;
	if (filp->f_mode & FMODE_WRITE)
		put_write_access(inode);
	iput(inode);
}

