/*
 * Copyright (c) 1996-1999 The University of Utah and the Flux Group.
 * 
 * This file is part of the OSKit Linux Glue Libraries, which are free
 * software, also known as "open source;" you can redistribute them and/or
 * modify them under the terms of the GNU General Public License (GPL),
 * version 2, as published by the Free Software Foundation (FSF).
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * Linux software interrupts.
 */

#ifndef OSKIT
#define OSKIT
#endif

#include <linux/sched.h>
#include <linux/interrupt.h>
#include <asm/system.h>
#include <asm/bitops.h>
#include "osenv.h"

int bh_mask_count[32];

/*
 * Mask of pending interrupts.
 */
unsigned long bh_active = 0;

/*
 * Mask of enabled interrupts.
 */
unsigned long bh_mask = 0;

/*
 * List of software interrupt handlers.
 */
void (*bh_base[32])(void);

/*
 * Software interrupt handler.
 */
void
do_bottom_half(void)
{
	unsigned long active;
	unsigned long mask, left;
	void (**bh)(void);

	bh = bh_base;
	active = bh_active & bh_mask;
	for (mask = 1, left = ~0;
	     left & active; bh++, mask += mask, left += left) {
		if (mask & active) {
			void (*fn)(void);

			bh_active &= ~mask;
			fn = *bh;
			if (fn == 0)
				goto bad_bh;
			intr_count++;
			fn();
			intr_count--;
		}
	}
	return;
 bad_bh:
	osenv_log(OSENV_LOG_WARNING,
		"linux_soft_intr: bad interrupt handler entry 0x%08lx\n", mask);
}

