/*
 * Copyright (c) 1997,1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include <oskit/com/sfs.h>
#include <oskit/c/assert.h>
#include <oskit/c/malloc.h>
#include "sfs.h"

oskit_error_t oskit_sfs_wrap(oskit_dir_t *rroot, 
			     security_id_t fs_sid,
			     oskit_filepsid_t *psid,
			     oskit_avc_t *avc,
			     oskit_dir_t **out_sroot)
{
    struct sfilesystem *sfs;
    struct sfiledir *sdir;
    oskit_error_t rc;
    
    rc = sfilesystem_create(rroot,fs_sid,psid, avc,&sfs);
    if (rc)
	    return rc;
    
    rc = sfiledir_create(sfs,(oskit_file_t*)rroot, &sdir);
    oskit_filesystem_release(&sfs->fsi);
    if (rc)
	    return rc;
    
    *out_sroot = (oskit_dir_t*)&sdir->filei;
    return 0;
}

