/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: wimp_wintree.h,v $
 *
 * HISTORY
 * $\Log: wimp_wintree.h,v $
 * Revision 1.4  1998/01/31 18:43:19  mjk
 * replaced copyright
 *
 * Revision 1.3  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.2  1998/01/16 20:01:07  acb
 * Added copyright
 *
 *
 */

#ifndef _wimp_wintree_h_
#define _wimp_wintree_h_

WINDOW *wimpi_get_window (wimpiToplevelWindow ms, Window winId);
void wimpi_make_top_sibling (WINDOW *win);
void wimpi_make_bottom_sibling (WINDOW *win);
void wimpi_remove_sibling (WINDOW *win);
void wimpi_build_list_over_win (WINDOW *win, int ignore_kids);
void wimpi_expose_tree (WINDOW *win);
void wimpi_set_up_window_bitmaps (WINDOW *win, BITMAP *screen);
void wimpi_expose_lower_windows (WINDOW *win, bool expose_parent);
void wimpi_obscure_lower_windows (WINDOW *win);
void wimpi_move_and_resize_tree (WINDOW *win, int dx, int dy);
void wimpi_make_tree_visible (WINDOW *win);
void wimpi_make_tree_invisible (WINDOW *win);
void wimpi_fix_up_moved_tree (WINDOW *win);
void wimpi_dump_winlist ();
WINDOW *wimpi_window_under_mouse (wimpiSession mr);

#define IS_TOP_SIBLING(win)  (win->parent->top_child == win)
#define ROOT_WIN(w) (w->winId == 0)

#endif /* _wimp_wintree_h_ */
