/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: subs.c,v $
 *
 * HISTORY
 * $\Log: subs.c,v $
 * Revision 1.3  1998/01/31 18:43:16  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 *
 * Revision 1.3  1997/01/14 18:38:06  acb
 * Clipping works now
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */


#include <wimpi_input.h>
#include <bitblit.h>
#include <oskit/wimpi.h>
#include <font.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <defs.h>
#include "subs.h"
#include "border.h"
#include "do_button.h"
#include "erase_win.h"
#include "font_subs.h"
#include "icon_server.h"
#include "intersect.h"
#include "mouse_get.h"
#include "clip.h"
#include "update.h"

void save_win(WINDOW *win)
{
    if ((void *)win->save == (void *) 0) {
	W(save) = bit_alloc(BIT_WIDE(W(border)),BIT_HIGH(W(border)),
			    (DATA*)0,BIT_DEPTH(W(border)));
    }
    else if (BIT_WIDE(W(save)) != BIT_WIDE(W(border))  ||
	     BIT_HIGH(W(save)) != BIT_HIGH(W(border))) {
	dbgprintf('o',(stderr,"Saved window %s mismatch\r\n",W(tty)));
	bit_destroy(W(save));
	W(save) = bit_alloc(BIT_WIDE(W(border)),BIT_HIGH(W(border)),
			    (DATA*)0,BIT_DEPTH(W(border)));
    }
    
    bit_blit(W(save),0,0,BIT_WIDE(W(border)),BIT_HIGH(W(border)),
	     BIT_SRC,W(border),0,0);
}


/*  do_cursor*/
static void
do_cursor(win)
     WINDOW *win;
{
    switch(W(curs_type)) {
      case CS_BLOCK:
	bit_blit(W(window), W(x)+W(text.x),
		 W(y)+W(text.y)-W(font->head.high),
		 W(font->head.wide), W(font->head.high),
		 PUTOP(BIT_NOT(BIT_DST),W(style)), 0, 0, 0);
	break;
      case CS_BOX:
	bit_blit(W(window), W(x)+W(text.x),
		 W(y)+W(text.y)-W(font->head.high)+1,
		 W(font->head.wide), W(font->head.high)-2,
		 PUTOP(BIT_NOT(BIT_DST),W(style)), 0, 0, 0);
	bit_blit(W(window), W(x)+W(text.x)-2,
		 W(y)+W(text.y)-W(font->head.high)-1,
		 W(font->head.wide)+4, W(font->head.high)+2,
		 PUTOP(BIT_NOT(BIT_DST),W(style)), 0, 0, 0);
	break;
      case CS_LEFT:
	bit_blit(W(window), W(x)+W(text.x) - 1,
		 W(y)+W(text.y)-W(font->head.high),
		 2, W(font->head.high),
		 PUTOP(BIT_NOT(BIT_DST),W(style)), 0, 0, 0);
	break;
      case CS_RIGHT:
	bit_blit(W(window), W(x)+W(text.x)+W(font->head.wide) - 1,
		 W(y)+W(text.y)-W(font->head.high),
		 2, W(font->head.high),
		 PUTOP(BIT_NOT(BIT_DST),W(style)), 0, 0, 0);
	break;
      case CS_UNDER:
	bit_blit(W(window), W(x)+W(text.x),
		 W(y)+W(text.y)-1,
		 W(font->head.wide), 2,
		 PUTOP(BIT_NOT(BIT_DST),W(style)), 0, 0, 0);
	break;
    }
}

/* cursor_on, cursor_off*/
static int cursoron = 0;

void cursor_on(wimpiSession mr)
{
    if( !mr->active || !mr->active->is_mapped) {
	cursoron = 0;
	return;
    }
    if (!(mr->active->no_expose_events)) {
	cursoron = 0;
	return;
    }
	
    if( cursoron )
	return;
    do_cursor(mr->active);
    cursoron = 1;
}

void cursor_off(wimpiSession mr)
{
    if( !mr->active || !mr->active->is_mapped ) {
	cursoron = 0;
	return;
    }
    if( !cursoron )
	return;
    cursoron = 0;
    do_cursor(mr->active);
}


/*  move_mouse*/
/****************************************************************************
 *
 *      move the mouse, keep exclusive control 
 *      "how" specifies how we recognize completion:
 *              how == 0:       all buttons were up at start of action,
 *                              any button pushed down completes the action.
 *              how != 0:       some button was down at start of action,
 *                              all buttons released completes the action.
 */

int
move_mouse(mr,mouse,x,y,how)
     wimpiSession mr;
     int mouse, *x, *y;
     int how;
{
    register int mx = *x, my = *y;
    register int button = 0;
    int dx,dy;
    BITMAP *screen = mr->screen;
    
    MOUSE_ON(mr,screen,mx,my);
    do {
      wimpiGetMouseEvent(mr);
	button=mouse_get(&mr->ms_ev,&dx,&dy);
	MOUSE_OFF(mr,screen,mx,my);
	mx += dx;
	my -= dy;
	mx = BETWEEN(0,mx,BIT_WIDE(screen)); 
	my = BETWEEN(0,my,BIT_HIGH(screen)); 
	MOUSE_ON(mr,screen,mx,my);
    } while (how ? button!= 0 : button==0);
    if( how )
        do_button(mr, 0 , screen);
    MOUSE_OFF(mr,screen,mx,my);
    *x = mx;
    *y = my;
    return(button);
}


int
bury(mr,win)
     wimpiSession mr;
     register WINDOW *win;                   /* window to bury */
{
    dbgprintf('o',(stderr,"burying %s\r\n",W(tty)));
    if (!win || !W(next))
	return(0);
    
    if (win == mr->active)
	mr->active = W(next);
    
    W(prev)->next = W(next);
    W(next)->prev = W(prev);
    
    W(prev) = ACTIVE(mr,prev);
    ACTIVE(mr,prev)->next = win;
    
    ACTIVE(mr,prev) = win;
    W(next) = (WINDOW *) 0;
    return(1);
}

/*  repair -- repair effects of buried window */
void repair(wimpiSession mr, WINDOW *clip)
{
    register WINDOW *win;

    /* Not sure if we'll need this any more... I expect not. */

    printf ("In repair()\n");

#ifdef NOCLIP
    for(win=ACTIVE(mr,prev)->prev;win!=mr->active;win=W(prev))
	if (!alone(win)) restore_win(win);
    restore_win(win);
#else
    for(win=clip->prev;win!=mr->active;win=W(prev))
	if (intersect(clip,win))
	    clip_win(win,clip);
    if (clip!= mr->active && intersect(clip,mr->active))
	clip_win(mr->active,clip);
#endif
    un_covered(mr);
}


/* restore_win -- restore a previously saved pixel image of the window */
void
restore_win(win)
     register WINDOW *win;                   /* window to restore to screen */
{
    if (W(save) != (BITMAP *) 0 && win->is_mapped) {
	bit_blit(W(border),0,0,BIT_WIDE(W(border)),BIT_HIGH(W(border)),
		 BIT_SRC,W(save),0,0);
    }
    
    dbgprintf('o',(stderr,"\t\t  restoring %s\r\n",W(tty)));
}


/* clip_win -- partially restore a previously saved pixel image of 
 * the window
 */
#define C(x)    (clip->x)

void
clip_win(win,clip)
     register WINDOW *win;                   /* window to restore to screen */
     register WINDOW *clip;                  /* clip window */
{
    int x0 = Max(W(x0),C(x0)) - W(x0);
    int y0 = Max(W(y0),C(y0)) - W(y0);
    int x1 = Min(W(x0)+BIT_WIDE(W(border)),C(x0)+BIT_WIDE(C(border))) 
	- W(x0);
    int y1 = Min(W(y0)+BIT_HIGH(W(border)),C(y0)+BIT_HIGH(C(border))) 
	- W(y0);

    if (!win->is_mapped) return;

    if (W(save) != (BITMAP *) 0 && !(W(flags)&W_ACTIVE)) {
	bit_blit(W(border),x0,y0,x1-x0,y1-y0,
		 BIT_SRC,W(save),x0,y0);
    }
}


/* un_covered -- find and activate all windows previously covered by win */
void un_covered(wimpiSession mr)
{
    register WINDOW *win,*check;
    register int cover;
    
    for(win=mr->active;win != (WINDOW *) 0;win=W(next)) {
	dbgprintf('U',(stderr,"   invalidate cliplist: %s)\r\n",W(tty)));
	dbgprintf('o',(stderr,"   un_cover: %s)\n",W(tty)));
	for(cover=0,check=mr->active;check!=win && cover==0;check=check->next)
	    if (intersect(win,check)) cover=1;
	
	if (cover && W(flags)&W_ACTIVE) {
	    /*
	     *          do_event(EVENT_COVERED,win,E_MAIN);
	     */
	    W(flags) &= ~W_ACTIVE;
	    /*
	     *          if (!(W(flags)&W_LOOK))
	     *             FD_CLR( W(to_fd), &mask);
	     */
	    dbgprintf('o',(stderr,"becoming inactive (covered by %s)\r\n",
			   check->tty));
	}
	else if (!cover && !(W(flags)&W_ACTIVE)) {
	    /*
	     *          do_event(EVENT_UNCOVERED,win,E_MAIN);
	     */
	    W(flags) |= W_ACTIVE;
	    /*
	     *          if (!(W(flags)&W_DIED))
	     *             FD_SET( W(to_fd), &mask);
	     */
	    dbgprintf('o',(stderr,"becoming active\r\n"));
	}
	else if (cover && !(W(flags)&W_ACTIVE))  {
	    dbgprintf('o',(stderr,"remains inactive (covered by %s)\r\n",
			   check->tty));
	}
	else if (!cover && W(flags)&W_ACTIVE) {
	    dbgprintf('o',(stderr,"remains active\r\n"));
	}
	else {
	    dbgprintf('o',(stderr,"%s: unknown covering state\r\n",W(tty)));
	}
    }
}


/* expose -- bring a window to the top */ 
void expose(mr, win)
     wimpiSession mr;
     register WINDOW *win;                   /* window to expose */
{
    dbgprintf('o',(stderr,"exposing %s\r\n",W(tty)));
    
    /* reorder windows */
    
    if (win == mr->active) return;
    
    W(prev)->next = W(next);
    if (W(next))
	W(next)->prev = W(prev);
    else
	ACTIVE(mr,prev) = W(prev);
    
    W(prev) = ACTIVE(mr,prev);
    W(next) = mr->active;
    
    ACTIVE(mr,prev) = win;
    mr->active = win;
    
    if (!(W(flags)&W_ACTIVE)) {
	for(win=mr->active->next;win!=(WINDOW *) 0;win=W(next))
	    if (W(flags)&W_ACTIVE && intersect(mr->active,win))
		save_win(win);
	
	restore_win(mr->active);
	
	clip_bad(mr->active); /* invalidate clip lists */
	/* un_covered(mr); */
    }else {
	dbgprintf('o',(stderr,"expose: %s already active (0%o)\r\n",
		       ACTIVE(mr,tty),(unsigned)ACTIVE(mr,flags)));
    }
    {
	int mouse_was_on = mr->mouse_on;
	/* I think the mouse is always off here, but I cannot prove it. vpb */
	MOUSE_OFF(mr,mr->screen,mr->mousex,mr->mousey);
	SETMOUSEICON(mr, DEFAULT_MOUSE_CURSOR(mr));  /* because active win chg */
	if( mouse_was_on)  MOUSE_ON(mr,mr->screen,mr->mousex,mr->mousey);
    }
}

/* set_covered -- deactivate all windows covered by win */
void set_covered(mr,check)
     wimpiSession mr;
     register WINDOW *check;     /* window to check covering against */
{
    register WINDOW *win;
    
    for(win=mr->active;win != (WINDOW *) 0;win=win->next) {
	if (win!=check && intersect(win,check) && W(flags)&W_ACTIVE) {
	    save_win(win);
	    
	    W(flags) &= ~W_ACTIVE;
	    /*
	     *          do_event(EVENT_COVERED,win,E_MAIN);
	     *          if (!(W(flags)&W_LOOK))
	     *             FD_CLR( W(to_fd), &mask);
	     * dbgprintf('o',(stderr,"\t%s covers %s\r\n",check->tty,W(tty)));
	     */
	}
    }
}
  
  
