/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: new_window.c,v $
 *
 * HISTORY
 * $\Log: new_window.c,v $
 * Revision 1.7  1998/01/31 18:43:13  mjk
 * replaced copyright
 *
 * Revision 1.6  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.5  1997/12/11 20:43:41  acb
 * Another MAXWIN removed.
 *
 * Revision 1.4  1997/08/27 17:59:56  acb
 * Fixed a bug in the position of newly-created window.
 *
 * Revision 1.3  1997/07/21 22:17:30  acb
 * Removed "MAXWIN" check.
 *
 * Revision 1.2  1997/06/09 22:10:08  acb
 * Compensates for title bar when creating window.
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/04/09 21:33:31  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 *
 * Revision 1.4  1997/02/03 19:11:47  davidm
 * (rlogin_window): Printer error message instead of seg faulting if
 * 	rlogin router cannot be found.
 *
 * Revision 1.3  1997/01/14 18:35:06  acb
 * Performance enhancement -- terminal emulator avoids reads from
 * framebuffer
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */


#include <oskit/wimpi.h>

#include <bitblit.h>
#include <font.h>

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <defs.h>
#include <border.h>
#include <icon_server.h>
#include <get_font.h>
#include <font_subs.h>
#include <clip.h>
#include <update.h>
#include <new_window.h>
#include <subs.h>

#include <wimp_wintree.h>

WINDOW *
insert_win(mr,win)
wimpiSession mr;
WINDOW *win;
{
  if (mr->active) {
    W(prev) = ACTIVE(mr,prev);
    ACTIVE(mr,prev) = win;
    W(next) = mr->active;
  }
  else {
    W(prev) = win;
    W(next) = (WINDOW *) 0;
  }
  return(win);
}

int
setup_window(mr,win,curr_font,x,y,dx,dy,screen)
     wimpiSession mr;
     register WINDOW *win;
     int x,y,dx,dy;
     struct font *curr_font;
     BITMAP *screen;
{
  register int i;

  W(font) = curr_font;
  /* W(x) = curr_font->head.wide; */
  W(x) = 0;
  W(y) = curr_font->head.high;
  W(esc_cnt) = 0;
  W(esc[0]) = 0;
  W(flags) = W_ACTIVE | (unsigned int) INIT_FLAGS;
  
  W(style) = BIT_SRC;
  W(curs_type) = CS_BLOCK;

  if (win->has_border) {
      W(borderwid) = SUM_BDR;
      W(outborderwid) = OUT_BDR;
      W(title_high) = curr_font->head.high;
  } else {
      W(borderwid) = W(outborderwid) = W(title_high) = 0;
  }

  win->max_wide = dx;
  win->max_high = dy;

  /* Adjust window so that it fits on screen */
  if (win->parent == mr->root_win) {
      int right, bottom, bwid = win->borderwid;

      right = x + win->max_wide + (bwid<<1);
      bottom = y + win->max_high + (bwid<<1) + win->title_high;
      
      if (right > mr->screen->wide)
	  x -= right - mr->screen->wide;
      
      if (bottom > mr->screen->high)
	  y -= bottom - mr->screen->high;
  }

  /* 
   *   W(x0) = x - W(borderwid);
   *   W(y0) = y - W(title_high) - W(borderwid);
   */

  W(x0) = x;
  W(y0) = y;

  if (W(x0) < 0) W(x0) = 0;  
  if (W(y0) < 0) W(y0) = 0;  

  wimpi_set_up_window_bitmaps (win, screen);

  W(text.x) = 0;
  W(text.y) = 0;
  W(text.wide) = 0;
  W(text.high) = 0;
  
  W(bitmap) = (BITMAP *) 0;
  for(i=0;i<MAXBITMAPS;i++) {
    W(bitmaps)[i] = (BITMAP *) 0;
  }
  
  W(cursor) = mr->mouse_arrow;
  W(save) = (BITMAP *) 0;
  W(stack) = (WINDOW *) 0;
  W(main) = win;
  W(alt) = (WINDOW *) 0;
  W(esc_cnt) = 0;
  W(esc[0])=0;
  W(clip_list) = (char *) 0;
  
  for(i=0;i<MAXMENU;i++) {
    W(menus[i]) = (struct menu_state *) 0;
  }
  
  W(menu[0]) = W(menu[1]) = -1;
  W(event_mask) = 0;
  
  for(i=0;i<MAXEVENTS;i++) {
    W(events)[i] = (char *) 0;
  }
  
  W(snarf) = (char *) 0;
  W(gx) = 0;
  W(gy) = 0;

  /* W(op) = BIT_OR; */
  W(op) = BIT_SRC;

  W(max) = 0;
  W(current) = 0;
  W(num) = 0;

  /*
   * Window is always unmapped so don't need this
   *  clip_bad(win);	
   */

#ifdef ALWAYS_USE_SAVE_WIN
  cursor_off(mr);
  MOUSE_OFF(mr,mr->screen,mr->mousex,mr->mousey);
  save_win(win);
  MOUSE_ON(mr,mr->screen,mr->mousex,mr->mousey);
  cursor_on(mr);
#endif

  return 1;
}

int make_window(mr,win,x,y,dx,dy,fnt,start)
     wimpiSession mr;
     WINDOW *win;
     int x, y, dx, dy;
     int fnt;
     char *start;
{
  struct font *curr_font;
  
  if (fnt == 0) {
    /* default font */
    curr_font = mr->font;
  }
  else
    fprintf(stderr, "Font not found \n");

#if 0
  if (dx<0)
    x += dx, dx = -dx;
  if (dy<0)
    y += dy, dy = -dy;
  
  if (x < 0) x = 0;
#endif

  if (y < curr_font->head.high)
      y = curr_font->head.high;

#if 0
  if (x + dx >= BIT_WIDE(mr->screen))
    dx = BIT_WIDE(mr->screen)-x;
  
  if (y + dy >= BIT_HIGH(mr->screen))
    dy = BIT_HIGH(mr->screen)-y;

  if (dx < SUM_BDR + SUM_BDR + curr_font->head.wide*MIN_X ||
      dy < SUM_BDR + SUM_BDR + curr_font->head.high*MIN_Y)
    return(-1);
#endif  
  
  if (!setup_window(mr,win,curr_font,x,y,dx,dy,mr->screen)) {
    fprintf(stderr,"WIMP: Out of memory for window creation\n");
  }

  mr->next_window++;
  
  return (0);
  
}


int
init_window (wimpiSession mr, WINDOW *win, int x, int y, int dx, int dy, 
	     int font_num, char **argv) 
{
    cursor_off(mr);
    mr->active = insert_win (mr,win);
    make_window (mr, win, x, y, dx, dy, font_num, "");
    
    return 0;
}



/*{{{  rlogin_window -- create a path from RLOGIN to MGR */
void rlogin_window(wimpiSession mr)
{
  /* XXX: need to reimplement */
#if 0
    Path path;
    Router r;
    struct Attrs attrs;
    
    /* call pathCreate on rlogin router */
    r = routerLookupByName("rlogin");
    if (!r) {
	fprintf(stderr, "mgr: sorry, couldn't find rlogin router\n");
	return;
    }
    attrInit (&attrs);
    attrSetValue(&attrs, PA_PATHNAME, ptrToAny((void *)"mgr/tga"));
    path = pathCreate (r, &attrs);
    attrDestroy (&attrs);
    
    if (!path) {
	fprintf(stderr, "MGR couldn't create path from rlogin\n");
    }
#endif
}





