/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: move_box.c,v $
 *
 * HISTORY
 * $\Log: move_box.c,v $
 * Revision 1.3  1998/01/31 18:43:13  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 */

/*{{{}}}*/
/*{{{  Notes*/

/* drag a box around the screen */
/*}}}  */
/*{{{  #includes*/
#include <wimpi_input.h>
#include <bitblit.h>
#include <oskit/wimpi.h>

#include "defs.h"
#include <move_box.h>
#include "get_rect.h"
#include "mouse_get.h"
/*}}}  */

/*{{{  move_box*/
void move_box(mr,screen,mouse,x,y,dx,dy,how)
wimpiSession mr;
BITMAP *screen;			/* where to sweep out the box */
int mouse;			/* file to get mouse coords from */
register int *x,*y;		/* starting position */
register int dx,dy;             /* box size */
int how;					/* termination condition */
{
  int x_mouse, y_mouse;
  register int button, skip=1;

  box(screen,*x,*y,dx,dy);
  do 
  {
    wimpiGetMouseEvent(mr);
    button=mouse_get(&mr->ms_ev,&x_mouse,&y_mouse);
    if (skip)
      box(screen,*x,*y,dx,dy);
    *x += x_mouse;
    *y -= y_mouse;
    *x = BETWEEN(0,*x,BIT_WIDE(screen)-dx);
    *y = BETWEEN(0,*y,BIT_HIGH(screen)-dy);
    if ( (skip = !mouse_count()))
      box(screen,*x,*y,dx,dy);
  }
  while (how ? button!=0 : button==0); 

  if (skip)
    box(screen,*x,*y,dx,dy);
}
/*}}}  */
