/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: move.c,v $
 *
 * HISTORY
 * $\Log: move.c,v $
 * Revision 1.4  1998/01/31 18:43:13  mjk
 * replaced copyright
 *
 * Revision 1.3  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.2  1997/06/09 22:07:52  acb
 * Sends a move/resize event when window is moved.
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 */


/* move a window */
#include <wimpi_input.h>
#include <bitblit.h>
#include <oskit/wimpi.h>
#include <stdio.h>

#include "defs.h"
#include <move.h>
#include "border.h"
#include "mouse_get.h"
#include "move_box.h"
#include "shape.h"

#include <wimp_internal.h>

/* move_window*/
void move_window(wimpiSession mr)
{
    /* Old stuff:
     * int bdx = BIT_WIDE(ACTIVE(mr,border));
     * int bdy = BIT_HIGH(ACTIVE(mr,border));
     * int dx = BIT_WIDE(ACTIVE(mr,window));
     * int dy = BIT_HIGH(ACTIVE(mr,window));
     * int sx = ACTIVE(mr,x0);
     * int sy = ACTIVE(mr,y0);
     */
    WINDOW *win;
    int button;
    int sx, sy;
    
    /* Find outermost ancestor of active win */
    for (win = mr->active; win->parent != mr->root_win; win = win->parent);
     
    sx = win->x0;
    sy = win->y0;
    
    move_box(mr,mr->screen,mr->mouse,&sx,&sy,win->border->wide,
	     win->border->high,0);
    
    /* adjust window state */
    
    mr->mousex += sx - win->x0;
    mr->mousey += sy - win->y0;
    
    /* shape(mr,sx,sy,dx,dy); */
    wimp_internal_move_resize_window (win, sx, sy, 0, 0);

    wimpi_send_move_resize_event (win);

    /*      do_event(EVENT_MOVE,active,E_MAIN);
     */
    /* wait till button is released */
    do {
      wimpiGetMouseEvent(mr);
      button=mouse_get(&mr->ms_ev,&sx,&sy);
    }
    while (button!=0);
}
