/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: mouse_get.c,v $
 *
 * HISTORY
 * $\Log: mouse_get.c,v $
 * Revision 1.3  1998/01/31 18:43:12  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 */

#include <mouse.h>
#include <mouse_get.h>

/*{{{  variables*/
static int button_map[8] = {0,1,2,3,4,5,6,7};


/* primary mouse interface */

int mouse_get(struct ms_event *ms_ev, int *x_delta, int *y_delta)
{
  get_ms_event (ms_ev);
  
  *x_delta = ms_ev->ev_dx;
  *y_delta = -ms_ev->ev_dy;
  
  return(button_map[(int)ms_ev->ev_butstate]);
}

/*{{{  mouse_count -- are there still characters in the mouse buffer?*/
int mouse_count()
{
  return 0; /* ???? */

}
/*}}}  */
