/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: mgr_mouse.c,v $
 *
 * HISTORY
 * $\Log: mgr_mouse.c,v $
 * Revision 1.3  1998/01/31 18:43:12  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 */

/* simple driver for serial mouse */
/* Andrew Haylett, 14th December 1992 */

#include <mouse.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <netinet/in.h>

/* these settings may be altered by the user */
#ifdef MOUSE
static int mtype = MOUSE; 
#else
static int mtype = 0;
#endif
/*static const int mbaud = B1200;*/
/* 1200 baud default */
/*static const int msample = 100;*/		
/* sample rate for Logitech mice */

static const int mdelta = 25;		/* x+y movements more than 25 pixels..*/
static const int maccel = 2;		/* ..are multiplied by 2. */

#define limit(n,l,u)	n = ((n) < (l) ? (l) : ((n) > (u) ? (u) : (n)))
#define abs(x)		(((x) < 0) ? -(x) : (x))

static int mx = 640;  
static int my = 480;  
static int x = 32, y = 32;
static int buttonwas = 0;

int
get_ms_event(struct ms_event *ev)
{
    unsigned char buf[5];
    char dx, dy;
    int i, acc;

    acc = (abs(ev->ev_dx) + abs(ev->ev_dy) > mdelta) ? maccel : 1;
    ev->ev_dx *= acc;
    ev->ev_dy *= acc;
    x += ev->ev_dx;
    y += ev->ev_dy;
    limit(x, 0, mx);
    limit(y, 0, my);
    ev->ev_x = x;
    ev->ev_y = y;
    if (buttonwas == ev->ev_butstate)
    {
	if (ev->ev_butstate)
	    ev->ev_code = MS_DRAG;
	else
	    ev->ev_code = MS_MOVE;
    }
    else
    {
	if ((buttonwas & ~ev->ev_butstate) == 0)
	    ev->ev_code = MS_BUTDOWN;
	else
	    ev->ev_code = MS_BUTUP;
    }
    buttonwas = ev->ev_butstate;

    return 0;
}

