/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: icon_server.c,v $
 *
 * HISTORY
 * $\Log: icon_server.c,v $
 * Revision 1.3  1998/01/31 18:43:10  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */


#include <oskit/wimpi.h>
#include <icon_server.h>

void
wimpi_get_images (wimpiSession mr) 
{

/* bitmap for "def_pattern", 32 wide, 4 high, 1 bit deep */
    static char def_pattern_data[16] = {
	0210, 0210, 0210, 0210, 0104, 0104, 0104, 0104, 0021, 0021,
	0021, 0021, 0042, 0042, 0042, 0042, 
    };
    /* "bit_static" is unfortunately a variable definition macro */
    static bit_static(def_pattern, 32, 4, def_pattern_data, 1, 0);

/* bitmap for "mouse_arrow", 32 wide, 32 high, 1 bit deep */
    static char mouse_arrow_data[128] = {
	0000, 0000, 0000, 0000, 0177, 0200, 0000, 0000, 0175, 0000,
	0000, 0000, 0170, 0000, 0000, 0000, 0174, 0000, 0000, 0000,
	0156, 0000, 0000, 0000, 0107, 0000, 0000, 0000, 0143, 0200,
	0000, 0000, 0101, 0300, 0000, 0000, 0000, 0340, 0000, 0000,
	0000, 0160, 0000, 0000, 0000, 0070, 0000, 0000, 0000, 0034,
	0000, 0000, 0000, 0014, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0377, 0300, 0000, 0000, 0200, 0100,
	0000, 0000, 0202, 0300, 0000, 0000, 0207, 0000, 0000, 0000,
	0202, 0000, 0000, 0000, 0221, 0000, 0000, 0000, 0270, 0200,
	0000, 0000, 0224, 0100, 0000, 0000, 0242, 0040, 0000, 0000,
	0341, 0020, 0000, 0000, 0000, 0210, 0000, 0000, 0000, 0104,
	0000, 0000, 0000, 0042, 0000, 0000, 0000, 0022, 0000, 0000,
	0000, 0016, 0000, 0000, 0000, 0000, 0000, 0000, 
    };
    /* "bit_static" is unfortunately a variable definition macro */
    static bit_static(mouse_arrow, 32, 32, mouse_arrow_data, 1, 0);

/* bitmap for "mouse_box", 32 wide, 32 high, 1 bit deep */
    static char mouse_box_data[128] = {
	0000, 0000, 0000, 0000, 0177, 0376, 0000, 0000, 0177, 0376,
	0000, 0000, 0140, 0006, 0000, 0000, 0140, 0006, 0000, 0000,
	0140, 0006, 0000, 0000, 0140, 0006, 0000, 0000, 0140, 0006,
	0000, 0000, 0140, 0006, 0000, 0000, 0140, 0006, 0000, 0000,
	0140, 0006, 0000, 0000, 0140, 0006, 0000, 0000, 0140, 0006,
	0000, 0000, 0177, 0376, 0000, 0000, 0177, 0376, 0000, 0000,
	0000, 0000, 0000, 0000, 0377, 0377, 0000, 0000, 0200, 0001,
	0000, 0000, 0200, 0001, 0000, 0000, 0200, 0001, 0000, 0000,
	0200, 0001, 0000, 0000, 0200, 0001, 0000, 0000, 0200, 0001,
	0000, 0000, 0200, 0001, 0000, 0000, 0200, 0001, 0000, 0000,
	0200, 0001, 0000, 0000, 0200, 0001, 0000, 0000, 0200, 0001,
	0000, 0000, 0200, 0001, 0000, 0000, 0200, 0001, 0000, 0000,
	0200, 0001, 0000, 0000, 0377, 0377, 0000, 0000, 
    };
    /* "bit_static" is unfortunately a variable definition macro */
    static bit_static(mouse_box, 32, 32, mouse_box_data, 1, 0);

/* bitmap for "mouse_bull", 32 wide, 8 high, 1 bit deep */
    static char mouse_bull_data[32] = {
	0000, 0000, 0000, 0000, 0030, 0000, 0000, 0000, 0044, 0000,
	0000, 0000, 0132, 0000, 0000, 0000, 0132, 0000, 0000, 0000,
	0044, 0000, 0000, 0000, 0030, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 
    };
    /* "bit_static" is unfortunately a variable definition macro */
    static bit_static(mouse_bull, 32, 8, mouse_bull_data, 1, 0);

/* bitmap for "mouse_bull2", 32 wide, 8 high, 1 bit deep */
    static char mouse_bull2_data[32] = {
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0030, 0000,
	0000, 0000, 0044, 0000, 0000, 0000, 0044, 0000, 0000, 0000,
	0030, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 
    };
    /* "bit_static" is unfortunately a variable definition macro */
    static bit_static(mouse_bull2, 32, 8, mouse_bull2_data, 1, 0);

/* bitmap for "mouse_cross", 32 wide, 16 high, 1 bit deep */
    static char mouse_cross_data[64] = {
	0000, 0000, 0004, 0000, 0004, 0000, 0004, 0000, 0004, 0000,
	0177, 0300, 0004, 0000, 0004, 0000, 0004, 0000, 0004, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0016, 0000, 0012, 0000, 0012, 0000, 0012, 0000,
	0373, 0340, 0200, 0040, 0373, 0340, 0012, 0000, 0012, 0000,
	0012, 0000, 0016, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 
    };
    /* "bit_static" is unfortunately a variable definition macro */
    static bit_static(mouse_cross, 32, 16, mouse_cross_data, 1, 0);

/* bitmap for "mouse_cup", 32 wide, 32 high, 1 bit deep */
    static char mouse_cup_data[128] = {
	0017, 0314, 0000, 0000, 0030, 0170, 0000, 0000, 0017, 0360,
	0000, 0000, 0000, 0300, 0000, 0000, 0007, 0200, 0000, 0000,
	0000, 0000, 0000, 0000, 0037, 0360, 0000, 0000, 0030, 0034,
	0000, 0000, 0030, 0036, 0000, 0000, 0030, 0026, 0000, 0000,
	0030, 0036, 0000, 0000, 0034, 0074, 0000, 0000, 0017, 0340,
	0000, 0000, 0007, 0300, 0000, 0000, 0037, 0360, 0000, 0000,
	0037, 0360, 0000, 0000, 0020, 0062, 0000, 0000, 0047, 0204,
	0000, 0000, 0020, 0010, 0000, 0000, 0013, 0040, 0000, 0000,
	0010, 0100, 0000, 0000, 0037, 0360, 0000, 0000, 0040, 0014,
	0000, 0000, 0047, 0342, 0000, 0000, 0044, 0041, 0000, 0000,
	0044, 0051, 0000, 0000, 0044, 0041, 0000, 0000, 0043, 0302,
	0000, 0000, 0020, 0034, 0000, 0000, 0010, 0060, 0000, 0000,
	0040, 0010, 0000, 0000, 0040, 0010, 0000, 0000, 
    };
    /* "bit_static" is unfortunately a variable definition macro */
    static bit_static(mouse_cup, 32, 32, mouse_cup_data, 1, 0);

/* bitmap for "mouse_cut", 32 wide, 32 high, 1 bit deep */
    static char mouse_cut_data[128] = {
	0000, 0000, 0000, 0000, 0000, 0014, 0000, 0000, 0200, 0022,
	0000, 0000, 0160, 0022, 0000, 0000, 0036, 0022, 0000, 0000,
	0017, 0234, 0000, 0000, 0001, 0340, 0000, 0000, 0001, 0340,
	0000, 0000, 0017, 0234, 0000, 0000, 0036, 0022, 0000, 0000,
	0160, 0022, 0000, 0000, 0200, 0022, 0000, 0000, 0000, 0014,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0014, 0000, 0000, 0200, 0022,
	0000, 0000, 0140, 0041, 0000, 0000, 0214, 0051, 0000, 0000,
	0041, 0241, 0000, 0000, 0010, 0102, 0000, 0000, 0002, 0004,
	0000, 0000, 0002, 0004, 0000, 0000, 0010, 0102, 0000, 0000,
	0041, 0241, 0000, 0000, 0214, 0051, 0000, 0000, 0140, 0041,
	0000, 0000, 0200, 0022, 0000, 0000, 0000, 0014, 0000, 0000,
	0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 
    };
    /* "bit_static" is unfortunately a variable definition macro */
    static bit_static(mouse_cut, 32, 32, mouse_cut_data, 1, 0);

    mr->def_pattern = &def_pattern;
    mr->mouse_arrow = &mouse_arrow;
    mr->mouse_box = &mouse_box;
    mr->mouse_bull = &mouse_bull;
    mr->mouse_cross = &mouse_cross;
    mr->mouse_cup = &mouse_cup;
    mr->mouse_cut = &mouse_cut;
}
