/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: get_rect.c,v $
 *
 * HISTORY
 * $\Log: get_rect.c,v $
 * Revision 1.3  1998/01/31 18:43:09  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 */


/* sweep out a rectangle */
#include <wimpi_input.h>
#include <bitblit.h>
#include <oskit/wimpi.h>

#include "defs.h"

#include "mouse_get.h"
#include <get_rect.h>

#define Box(screen,x,y,dx,dy) \
	type ? \
           bit_line(screen,x,y,x+dx,y+dy,BIT_NOT(BIT_DST)) : \
           box(screen,x,y,dx,dy) 

/* box -- draw a box*/
void box(screen,x1,y1,dx,dy)
BITMAP *screen;
int x1,y1,dx,dy;
   {
   if (dx<0)
      x1 += dx,dx = -dx;
   if (dy<0)
      y1 += dy,dy = -dy;
   if (dx<3)
      dx=3;
   if (dy<3)
      dy=3;

   bit_blit(screen,x1+1,y1,dx-1,1 ,BIT_NOT(BIT_DST),NULL_DATA,0,0);
   bit_blit(screen,x1+1,y1+dy,dx-1,1 ,BIT_NOT(BIT_DST),NULL_DATA,0,0);
   bit_blit(screen,x1,y1,1, dy,BIT_NOT(BIT_DST),NULL_DATA,0,0);
   bit_blit(screen,x1+dx,y1,1, dy,BIT_NOT(BIT_DST),NULL_DATA,0,0);
   }

/* get_rect*/
void get_rect(mr,screen,mouse,x,y,dx,dy,type)
wimpiSession mr;
BITMAP *screen;		/* where to sweep out the box */
int mouse;			/* file to get mouse coords from */
int x,y;			/* starting position */
register int *dx,*dy;		/* box width,height */
int type;			/* rectangle or line */
   {
   int x_mouse, y_mouse;
   register int button;
   register int newx;
   register int newy;
   register int skip=1;

   newx = *dx;
   newy = *dy;

   Box(screen,x,y,*dx,*dy);
   do {
      wimpiGetMouseEvent(mr);
      button=mouse_get(&mr->ms_ev,&x_mouse,&y_mouse);
      if (skip)
         Box(screen,x,y,*dx,*dy);
      newx += x_mouse<<1;
      newy -= y_mouse<<1;
      *dx = BETWEEN(-x,newx,(int) BIT_WIDE(screen)-x);
      *dy = BETWEEN(-y,newy,(int) BIT_HIGH(screen)-y);
      if ((skip = !mouse_count()))
         Box(screen,x,y,*dx,*dy);
      }
   while (button!=0);

   if (skip)
      Box(screen,x,y,*dx,*dy);
   }


