/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: erase_win.c,v $
 *
 * HISTORY
 * $\Log: erase_win.c,v $
 * Revision 1.3  1998/01/31 18:43:08  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.1  1997/02/13 22:15:46  acb
 * Initial revision
 *
 * Revision 1.3  1997/01/14 18:30:28  acb
 * Window erase avoids read from framebuffer for better performance.
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */


/*{{{}}}*/
/*{{{  Notes*/
/* erase a pixrect to background pattern */
/*}}}  */
/*{{{  #includes*/

#include <bitblit.h>
#include <oskit/wimpi.h>
#include <stdio.h>

#include <defs.h>

#include <icon_server.h>
#include <erase_win.h>

/* Bit_pattern -- fill DST bitmap with SRC, preserving alignment*/
static void Bit_pattern(dst,dx,dy,wide,high,func,src)
     register BITMAP *dst,*src;
     register int dx,dy;
     int wide,high;
     int func;
{
    register int incr;
    register int sw = BIT_WIDE(src);
    register int sh = BIT_HIGH(src);
    int x = BIT_X(dst) + dx;
    int y = BIT_Y(dst) + dy;
    int xdel = x % sw;
    int ydel = y % sh;
    int de;
    BITMAP *row = 0;
    
    de=wide+sw;

    /* get partial strip */
    
    /* Very expensive to read from frame buffer
    if (ydel) {
	for(incr=dx;incr<de;incr+=sw)
	    bit_blit(dst,incr,dy-ydel,sw,sh,func,src,0,0);
	dy += sh-ydel;
    }
    
    for(incr=dx;incr<de;incr+=sw)
	bit_blit(dst,incr,dy,sw,sh,func,src,0,0);
    
    de = dy+high;
    dx = 1;                 
    for(incr=dy+sh;incr<de;incr+=sh,sh<<=1)
	bit_blit(dst,dx,incr,wide,sh,func,dst,dx,dy);
   ***/

    /* This way is much faster... */
    row = bit_alloc (wide + sw, sh*2, (DATA *)0, BIT_DEPTH(src));

    for(incr=0;incr<de;incr+=sw) {
	bit_blit(row,incr,0,sw,sh,func,src,0,0);
    }
    bit_blit(row,0,sh,wide+sw,sh,func,row,0,0);

    for(incr = dy; incr+sh<=dy+high; incr+=sh)
	bit_blit(dst,dx,incr,wide,sh,func,row,xdel,ydel);

    if (incr != dy+high)
	bit_blit(dst,dx,incr,wide,dy+high-incr,func,row,xdel,ydel);
	
    bit_destroy(row);
}


/* erase_win*/
void erase_win(wimpiSession mr, BITMAP *map)
{

  Bit_pattern
  (
    map,
    0,0,
    BIT_WIDE(map),BIT_HIGH(map),
    BUILDOP(BIT_SRC,mr->color_map[ROOT_COLOR_FG],mr->color_map[ROOT_COLOR_BG]),
    mr->def_pattern
  );

}

void erase_patch(wimpiSession mr, BITMAP *map, int x, int y, int wide, int high)
{
    Bit_pattern(map, x, y, wide, high,
    BUILDOP(BIT_SRC,mr->color_map[ROOT_COLOR_FG],mr->color_map[ROOT_COLOR_BG]),
    mr->def_pattern);
}











