/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: do_button.c,v $
 *
 * HISTORY
 * $\Log: do_button.c,v $
 * Revision 1.6  1998/01/31 18:43:07  mjk
 * replaced copyright
 *
 * Revision 1.5  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.4  1997/12/11 20:46:05  acb
 * Got rid of MAXWIN check
 *
 * Revision 1.3  1997/12/11 18:27:28  acb
 * Disabled lock_screen()
 *
 * Revision 1.2  1997/06/09 22:05:49  acb
 * Window menu only pops up when title bar is clicked.
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/04/09 21:33:31  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 *
 * Revision 1.6  1997/02/03 19:02:12  davidm
 * (lock_screen): Reinstall original MGR code (with Scout mods).
 *
 * Revision 1.5  1997/01/14 18:28:25  acb
 * * Clipping works now
 * * Performance enhancement -- terminal emulator avoids reads from
 *   framebuffer
 *
 * Revision 1.4  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 */

#include "defs.h"

#include <oskit/wimpi.h>

#include <bitblit.h>
#include <share.h>
#include <font.h>
#include <stdlib.h>
#include <stdio.h>

#include "menu.h"

#include "border.h"
#include "copyright.h"
#include "do_menu.h"
#include "erase_win.h"
#include "font_subs.h"
#include "get_menus.h"
#include "intersect.h"
#include "subs.h"
#include <do_button.h>

#include <wimp_internal.h>
#include <wimp_wintree.h>

/* redraw -- redraw screen, restore contents of saved windows*/
void redraw(wimpiSession mr)
{
    WINDOW *win;

    /* A hack for term, rlogin windows */
    for (win = mr->root_win->top_child; win; win = win->next_sibling) {
	if (win->flags & W_ACTIVE && win->no_expose_events) {
	    save_win (win);
	}
	if (win->next_sibling == mr->root_win->top_child)
	    break;
    }

    erase_win(mr,mr->screen);
    wimpi_expose_tree (mr->root_win);
}

static void _quit (void)
{
/*    fprintf(stdout, "*** System halted ***\n");
    systemHalt();*/
  fprintf(stdout, "QUIT\n");
  exit(0);
}

static void lock_screen (wimpiSession mr)
{
    WINDOW *win;

    /* Mouse is off from mgr:main */
    /* cursor and active border off because of button handling */

    for (win = mr->active; win != 0; win = W(next)) {
	if (W(flags) & W_ACTIVE) {
	    save_win(win);
	}
    }
    copyright(mr, mr->screen, "");
    erase_win(mr, mr->screen);
    if (mr->active) {
	for (win = ACTIVE(mr, prev); win != mr->active; win = W(prev)) {
	    restore_win(win);
	}
	restore_win(mr->active);
    }

   /* flush and ignore intervening mouse events */
    while (mouse_count() > 0) {
	int x, y;
	mouse_get(&mr->ms_ev, &x, &y);
    }
}
  
/*{{{  quit -- quit with confirm*/
void quit(wimpiSession mr)
{
   struct menu_state *state;            /* place to keep menu state */
   int confirm;

   /* confirm the quit */

   state = menu_define(mr->font,mr->quit_menu,0,0,MENU_COLOR(mr));
   state = menu_setup(state,mr->screen,mr->mousex,mr->mousey,0);

   /* The extra call to menu_get() makes the use of the mouse buttons
      consistent on the menus; namely the action is selected by the button
      going up.
   */
   menu_get(mr,state,mr->mouse,BUTTON_SYS,0);
   menu_get(mr,state,mr->mouse,0,0);

   confirm = menu_ischoice(state) ? menu_choice(state) : 0;
   menu_destroy(state);
   if (confirm == M_QUIT) {
      _quit();
   }
   /* XXX
   else if (confirm == M_LOCK)
      lock_screen(mr);
   else if (confirm == M_SUSPEND)
      suspend();
   else
   */
      /* do nothing for CANCEL etc */;
   }
/*}}}  */


/*{{{  do_button -- figure out what to do with a button push*/
void do_button(wimpiSession mr,int button, BITMAP *screen)
{
    register WINDOW *win;		/* window of interest */
    int choice;				/* current menu choice */
    int choice_ok;			/* valid choice flag */
    struct menu_state *state;		/* place to keep menu state */
    register int which_menu;		/* which menu indicator */
    
    dbgprintf('b',(stderr,"do button %d (button state id %d)\n",
		   button,mr->button_state));
    
    /*	Insist on a transition before taking any action.
     */
    if( button == mr->button_state )
	return;
    
    /*	Other button codes, such as chords, are not recognized and have no
	effect.
	*/
    switch( button ) {
      case 0:
      case BUTTON_SYS:
      case BUTTON_2:
      case BUTTON_1:
	break;
      default:
	return;
    }
    
    /*	If button was down and now no button is down,
	send the event stating the formerly down button is now up.
	If some button is down, the same or some other,
	do nothing.
	Note that this creates a fundmental property of MGR:  namely that
	once a button is pressed, no other button pressings have any effect
	until all buttons are released.
	*/
    if( mr->button_state ) {
	if ( button == 0 ) {
	    /* int	b_event = -button_state; */
	    
	    /* button_state must be cleared before sending a Button_Up event to
	       prevent any event action from thinking the button is still down.
	       */
	    mr->button_state = 0;
	    /* XXX
	     *         do_event( b_event, active, E_MAIN );
	     */
	}
	return;
    }
    
    /* button_state is the global record of the current button state.
     */
    mr->button_state = button;
    
    /* Check for events associated with this button being pushed.
     */
    /* XXX
     *   do_event(button,active,E_MAIN);
     */
    switch (button) {
      case BUTTON_1:	
	/* vi hack removed XXX */
	if (mr->active) {
	    go_menu(mr, screen, 1);
	}
	break;
      case BUTTON_2:				/* for applic. menu */
	if (mr->active) {
	    go_menu(mr, screen, 0);
	}
	break;
      case BUTTON_SYS:				/* for system operation */
	/* see if mouse is in a window */
	if (mr->mousex < STRIPE)
	    win = (WINDOW *) 0;
	else
	{
	    win = wimpi_window_under_mouse(mr);
	    /***
	    if (win) {
		wimpi_send_mouse_event (win, BUTTON_DOWN_EVENT, 1);
	    }
	    ***/
	}

	/* do a menu for no window, or active window */
	if (win == mr->active || win == (WINDOW *) 0) {

	    /* Only pop up a menu for windows that have a border, and only
	     * when the mouse is clicked in the title bar
	     */
	    if (win) {
		if (win->has_border) {
		    int y;
		    y = mr->mousey - win->y0 - win->borderwid;
		    if (y >= win->font->head.high) {
			return;
		    }
		} else {
		    return;
		}
	    }
	    
	    mr->mouse_state = MOUSE_IN_MENU;
	    MOUSE_OFF(mr, mr->screen, mr->mousex, mr->mousey);

	    if (mr->active && win == mr->active) {
		state = menu_define(mr->font,mr->active_menu,0,0,
				    MENU_COLOR(mr));
		which_menu = 1;
	    }
#if 0
	    else if (mr->next_window >= MAXWIN) {
		state = menu_define(mr->font,mr->full_menu,0,0,
				    MENU_COLOR(mr));
		which_menu = 2;
	    }
#endif
	    else {
		state = menu_define(mr->font,mr->main_menu,0,0,
				    MENU_COLOR(mr));
		which_menu = 3;
	    }
	    if (mr->active) {
		cursor_off(mr);
		if (which_menu != 1)
		    ACTIVE_OFF(mr);
	    }

	    state = menu_setup(state,screen,mr->mousex,mr->mousey,0);
	    menu_get(mr,state,mr->mouse,0,0);
	    choice = menu_choice(state);
	    choice_ok = menu_ischoice(state);
	    menu_destroy(state);
	    if (choice_ok) {
		switch(which_menu) {
		  case 1:
		    ACTIVE_OFF(mr);
		    (*(mr->active_functions[choice]))(mr);
		    break;
		  case 2:
		    (*(mr->full_functions[choice]))(mr);
		    break;
		  case 3:
		    (*(mr->main_functions[choice]))(mr);
		    break;
		}
	    }
	    if (mr->active) {
		ACTIVE(mr,flags) &= ~W_NOINPUT;
		ACTIVE_ON(mr);
		cursor_on(mr);
	    }
	    /* do_button(mr, 0, screen); */
	    mr->button_state = 0;
	    if (win) {
		wimpi_send_mouse_event (win, BUTTON_UP_EVENT, 0);
	    }
	    mr->mouse_state = MOUSE_FREE;
	}
	else {
	    WINDOW *tmp;

	    /* bring obscured window to the top */
	    dbgprintf('b',(stderr,"activating: %s\r\n",W(tty)));

	    /* expose(mr, win); */
	    for (tmp = win;!ROOT_WIN(tmp->parent);tmp = tmp->parent);
	    if (!IS_TOP_SIBLING(tmp)) {
		wimp_internal_raise_window (tmp);
	    } 

	    if (mr->active) {
		ACTIVE_OFF(mr);
		cursor_off(mr);
	    }

	    mr->active = win;
	    
	    ACTIVE(mr,flags) &= ~W_NOINPUT;
	    ACTIVE_ON(mr);
	    cursor_on(mr);
	}
	break;
    }
    return;
}


