/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: copyright.c,v $
 *
 * HISTORY
 * $\Log: copyright.c,v $
 * Revision 1.4  1998/01/31 18:43:05  mjk
 * replaced copyright
 *
 * Revision 1.3  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.2  1997/10/20 16:04:46  mjk
 * (copyright): moved 8K worth of bitmaps off of the stack and into static space.
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.3  1997/02/03 18:59:56  davidm
 * (copyright): Added back starfield.
 *
 * Revision 1.2  1996/12/19 21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */



/*

Flash a copyright notice at Mgr startup.  You are not allowed to remove
this, it is a part of the conditions on which you are allowed to use MGR
without paying fees.

*/

/*
 * porter.c  Steve Hawley 4/3/87
 * rehacked 5/18/1988 for extra speed.
 * re-re hacked 6/20/88 for MGR (SAU)
 * re-re-re hacked by broman for use as screensaver.
*/
/*}}}  */
/*{{{  #includes*/
#include <oskit/wimpi.h>
#include <bitblit.h>
#include <font.h>
#include <sys/time.h>
#include <stdlib.h>
#include <string.h>

#include "defs.h"

#include "colormap.h"
#include "icon_server.h"
#include <copyright.h>

#include <unistd.h>

/*}}}  */
/*{{{  #defines*/
#define SSIZE	3		/* star size */

#define MAXZ 500 /* maximum z depth */
#define MAXZ 500 /* maximum z depth */
#define NSTARS 256 /* maximum number of stars */
#define SPEED	4		/* star speed */
#define SCALE	(short)6	/* for rotator */
#define COUNT	(short)2	/* for rotator */
#define ON 1  /* plotting states */
#define OFF 0
#if 0
#define Random() random()
#else
#define Random() rand()
#endif

/*}}}  */

/*{{{  types*/
/* for "star trek" clip areas */


typedef struct rect 
{
  short x1,y1;
  short x2,y2;
} RECT;
static RECT clip1, clip2, clip3;	/* holes in the galaxy */
/*}}}  */
/*{{{  variables*/

static short maxv, maxh; /* display size */
static short hmaxv, hmaxh;	/* 1/2 display size */
static int clockwise = 0;

static struct st 
{
  short x, y, z;
  short color;
} stars[NSTARS]; /* our galaxy */
/*}}}  */

/*{{{  init_all*/
void init_all(where) register BITMAP *where;
{
  maxv = BIT_HIGH(where);
  hmaxv = maxv>>1;
  maxh = BIT_WIDE(where);
  hmaxh = maxh>>1;
}       
/*}}}  */
static void flip(void) {
  clockwise = !clockwise;
}
/*{{{  cordic*/
/* CORDIC rotator. Takes as args a point (x,y) and spins it */
/* count steps counter-clockwise.                   1       */
/*                                Rotates atan( --------- ) */
/*                                                  scale   */
/*                                                 2        */
/* Therefore a scale of 5 is 1.79 degrees/step and          */
/* a scale of 4 is 3.57 degrees/step                        */

static void cordic(x, y, scale, count)
short *x, *y;
register short scale, count;

{
  register short tempx, tempy;

  tempx = *x;
  tempy = *y;

  if (! clockwise)
  for (; count; count--)
  {
    tempx -= (tempy >> scale);
    tempy += (tempx >> scale); 
  }
  else
  for (; count; count--)
  {
    tempx += (tempy >> scale);
    tempy -= (tempx >> scale);
  }

  *x = tempx;
  *y = tempy;
}
/*}}}  */
/*{{{  xplot*/
static int xplot(mr,where,x, y, col, state)
wimpiSession mr;
register BITMAP *where;
register int x, y;
register int col;
int state;
{
  /* are we on the screen? If not, let the caller know*/
  if (x < 0 || x >= maxh || y < 0 || y >= maxv ) return(1);
  if (!(x < clip1.x1 || x >= clip1.x2 || y < clip1.y1 || y >= clip1.y2 )) return(0);
  if (!(x < clip2.x1 || x >= clip2.x2 || y < clip2.y1 || y >= clip2.y2 )) return(0);
  if (!(x < clip3.x1 || x >= clip3.x2 || y < clip3.y1 || y >= clip3.y2 )) return(0);

  bit_blit(where,x,y,SSIZE,SSIZE, state ?
    BUILDOP(BIT_SET,col,mr->color_map[LOGO_COLOR_BG]) :
    BUILDOP(BIT_CLR,col,mr->color_map[LOGO_COLOR_BG]) ,
  (BITMAP*)0,0,0);
  return(0);
}
/*}}}  */
/*{{{  project*/
static int project(mr,where,x, y, z, col, state)
wimpiSession mr;
register BITMAP *where;
register short x, y, z;
register int col;
register short state;
{
        
  /* one-point perspective projection */
        /* the offsets (maxh/2) and maxv/2) ensure that the
         * projection is screen centered
  */
  x = (x/z) + hmaxh;
  y = (y/z) + hmaxv;
  return(xplot(mr,where,x, y, col, state));

}
/*}}}  */
/*{{{  fly*/
static void fly (mr,where) 
wimpiSession mr;
BITMAP *where;
{
  register short i;
  register struct st *stp;

  init_all(where);     /* set up global variables */
  for (i=0,stp=stars; i<NSTARS; i++,stp++)
  {
    /* initialize galaxy */
    do 
    {
      stp->x = Random();
      stp->y = Random();
      stp->z = (Random() % MAXZ) + 1;
      stp->color = Random() & ((1 << BIT_DEPTH(where))-1);
    } while(project(mr,where,stp->x, stp->y, stp->z, stp->color, ON)); /* on screen? */
  }
}
/*}}}  */
/*{{{  dofly*/
static void dofly (mr,where) 
wimpiSession mr;
BITMAP *where;
{
  register short i;
  register struct st *stp;

  i = NSTARS;
  stp = stars;
  do 
  {
    project(mr,where,stp->x, stp->y, stp->z, stp->color, OFF); /* turn star off*/
    if ((stp->z -= SPEED) <= 0) { /* star went past us */
      stp->x = Random();
      stp->y = Random();
      stp->z = MAXZ;
    }
    else {		/* rotate universe */
      cordic(&stp->x,&stp->y,SCALE,COUNT);
    }
    if (project(mr,where,stp->x, stp->y, stp->z, stp->color, ON)) 
    {
      /* if projection is off screen, get a new position */
      stp->x = Random();
      stp->y = Random();
      stp->z = MAXZ;
    }
    ++stp;
  } while(--i);
}
/*}}}  */

/*{{{  copyright*/
void copyright(wimpiSession mr, BITMAP *where, char *password)
{
  int i = 0;
  char rbuf[64], *readp = rbuf;
  char *crypt();
  unsigned int ind, r, g, b, maxi;
  int at_startup = (*password == 0);

/* Opening screen images */
/* bitmap for "ball_1", 181 wide, 181 high, 1 bit deep */
  static char ball_1_data[4163] = {
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0040, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0005, 0125, 0125, 0125, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0273, 0273, 0273, 0273, 0270,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0025, 0125, 0125,
      0125, 0125, 0125, 0100, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0357, 0377, 0377, 0377, 0377, 0376, 0350, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0005, 0125, 0125, 0125, 0125, 0125, 0125, 0125,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0053, 0277, 0377, 0377, 0377,
      0377, 0377, 0273, 0240, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0125, 0125,
      0125, 0125, 0125, 0125, 0125, 0125, 0120, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0002, 0377, 0377, 0377, 0377, 0377, 0377, 0377, 0377, 0356,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0025, 0125, 0125, 0335, 0335, 0335, 0335,
      0335, 0325, 0125, 0100, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0073, 0277, 0377, 0377,
      0377, 0377, 0377, 0377, 0377, 0373, 0240, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0001, 0125,
      0125, 0125, 0165, 0167, 0167, 0165, 0165, 0125, 0125, 0124,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0002, 0357, 0377, 0377, 0377, 0377, 0377, 0377, 0377,
      0377, 0377, 0356, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0005, 0125, 0135, 0335, 0335, 0335,
      0335, 0335, 0335, 0335, 0125, 0125, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0053, 0277, 0377,
      0377, 0377, 0377, 0377, 0377, 0377, 0377, 0377, 0273, 0240,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0125, 0125, 0125, 0127, 0167, 0167, 0167, 0167, 0167, 0125,
      0125, 0125, 0120, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0357, 0377, 0377, 0377, 0377, 0377, 0377,
      0377, 0377, 0377, 0377, 0376, 0350, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0001, 0125, 0125, 0335, 0335,
      0375, 0377, 0377, 0375, 0375, 0335, 0335, 0325, 0124, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0012, 0273,
      0377, 0377, 0377, 0377, 0377, 0377, 0377, 0377, 0377, 0377,
      0373, 0272, 0200, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0025, 0125, 0125, 0167, 0167, 0167, 0167, 0167, 0167,
      0167, 0167, 0165, 0125, 0125, 0100, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0056, 0377, 0377, 0377, 0377, 0377,
      0377, 0377, 0377, 0377, 0377, 0377, 0377, 0356, 0240, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0125, 0125, 0135,
      0335, 0337, 0337, 0377, 0377, 0377, 0337, 0335, 0335, 0335,
      0125, 0120, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0253, 0277, 0377, 0377, 0377, 0377, 0377, 0377, 0377, 0377,
      0377, 0377, 0377, 0273, 0250, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0001, 0125, 0125, 0127, 0167, 0167, 0167, 0167,
      0167, 0167, 0167, 0167, 0167, 0125, 0125, 0124, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0002, 0377, 0377, 0377, 0377,
      0377, 0377, 0377, 0377, 0377, 0377, 0377, 0377, 0377, 0377,
      0352, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0005, 0125,
      0125, 0335, 0335, 0377, 0377, 0377, 0374, 0377, 0377, 0375,
      0335, 0335, 0325, 0125, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0012, 0273, 0377, 0377, 0377, 0377, 0377, 0377, 0376,
      0377, 0277, 0377, 0377, 0377, 0373, 0272, 0200, 0000, 0000,
      0000, 0000, 0000, 0000, 0025, 0125, 0125, 0167, 0167, 0167,
      0367, 0367, 0364, 0367, 0267, 0167, 0167, 0165, 0125, 0125,
      0100, 0000, 0000, 0000, 0000, 0000, 0000, 0056, 0377, 0377,
      0377, 0377, 0377, 0353, 0377, 0352, 0257, 0277, 0377, 0377,
      0377, 0377, 0356, 0240, 0000, 0000, 0000, 0000, 0000, 0000,
      0125, 0125, 0135, 0335, 0337, 0364, 0107, 0377, 0304, 0107,
      0337, 0177, 0335, 0335, 0125, 0125, 0120, 0000, 0000, 0000,
      0000, 0000, 0000, 0253, 0277, 0377, 0377, 0377, 0352, 0253,
      0377, 0252, 0257, 0277, 0253, 0377, 0377, 0377, 0273, 0250,
      0000, 0000, 0000, 0000, 0000, 0001, 0125, 0125, 0125, 0127,
      0167, 0140, 0017, 0177, 0003, 0101, 0037, 0000, 0067, 0125,
      0125, 0125, 0120, 0000, 0000, 0000, 0000, 0000, 0002, 0357,
      0377, 0377, 0377, 0377, 0352, 0257, 0377, 0253, 0353, 0277,
      0352, 0257, 0377, 0377, 0376, 0352, 0000, 0000, 0000, 0000,
      0000, 0005, 0125, 0125, 0335, 0335, 0377, 0304, 0137, 0377,
      0107, 0345, 0337, 0344, 0104, 0135, 0325, 0125, 0125, 0000,
      0000, 0000, 0000, 0000, 0012, 0273, 0377, 0377, 0277, 0377,
      0352, 0277, 0376, 0257, 0372, 0257, 0352, 0252, 0277, 0377,
      0373, 0272, 0200, 0000, 0000, 0000, 0000, 0025, 0125, 0125,
      0124, 0067, 0167, 0220, 0077, 0374, 0037, 0370, 0027, 0360,
      0000, 0025, 0125, 0125, 0125, 0000, 0000, 0000, 0000, 0000,
      0052, 0357, 0377, 0372, 0277, 0377, 0252, 0277, 0376, 0257,
      0372, 0257, 0376, 0252, 0277, 0377, 0377, 0356, 0240, 0000,
      0000, 0000, 0000, 0025, 0125, 0125, 0304, 0137, 0337, 0304,
      0177, 0374, 0137, 0374, 0117, 0374, 0104, 0005, 0335, 0125,
      0125, 0100, 0000, 0000, 0000, 0000, 0052, 0273, 0277, 0252,
      0377, 0377, 0252, 0377, 0372, 0277, 0376, 0257, 0376, 0252,
      0253, 0377, 0377, 0272, 0240, 0000, 0000, 0000, 0000, 0025,
      0125, 0124, 0000, 0167, 0166, 0000, 0177, 0170, 0037, 0374,
      0017, 0164, 0003, 0140, 0125, 0125, 0125, 0120, 0000, 0000,
      0000, 0000, 0256, 0377, 0376, 0252, 0377, 0376, 0252, 0377,
      0372, 0277, 0376, 0257, 0376, 0253, 0352, 0377, 0377, 0376,
      0350, 0000, 0000, 0000, 0000, 0125, 0125, 0124, 0100, 0375,
      0376, 0104, 0377, 0364, 0137, 0376, 0107, 0376, 0105, 0364,
      0135, 0325, 0125, 0124, 0000, 0000, 0000, 0002, 0253, 0273,
      0376, 0252, 0377, 0376, 0252, 0377, 0372, 0277, 0376, 0257,
      0376, 0253, 0372, 0277, 0377, 0272, 0252, 0000, 0000, 0000,
      0001, 0125, 0125, 0124, 0000, 0167, 0166, 0020, 0377, 0360,
      0077, 0376, 0027, 0366, 0001, 0160, 0025, 0125, 0125, 0120,
      0000, 0000, 0000, 0002, 0256, 0377, 0376, 0253, 0377, 0376,
      0252, 0377, 0352, 0277, 0377, 0257, 0377, 0252, 0376, 0277,
      0377, 0356, 0352, 0000, 0000, 0000, 0005, 0125, 0125, 0134,
      0005, 0337, 0375, 0104, 0377, 0304, 0177, 0377, 0107, 0377,
      0104, 0334, 0015, 0125, 0125, 0124, 0000, 0000, 0000, 0012,
      0253, 0277, 0376, 0252, 0377, 0373, 0253, 0377, 0352, 0377,
      0377, 0253, 0377, 0252, 0376, 0257, 0377, 0273, 0252, 0200,
      0000, 0000, 0001, 0125, 0125, 0124, 0001, 0167, 0161, 0001,
      0177, 0200, 0177, 0377, 0103, 0167, 0000, 0166, 0005, 0125,
      0125, 0125, 0000, 0000, 0000, 0012, 0356, 0377, 0376, 0253,
      0377, 0372, 0253, 0377, 0252, 0377, 0377, 0353, 0377, 0252,
      0377, 0257, 0377, 0376, 0352, 0200, 0000, 0000, 0005, 0125,
      0125, 0334, 0105, 0377, 0366, 0105, 0377, 0304, 0177, 0377,
      0307, 0377, 0304, 0175, 0101, 0325, 0125, 0125, 0100, 0000,
      0000, 0052, 0273, 0277, 0376, 0253, 0377, 0372, 0253, 0377,
      0252, 0377, 0377, 0353, 0377, 0252, 0377, 0253, 0377, 0373,
      0252, 0240, 0000, 0000, 0021, 0125, 0125, 0124, 0003, 0167,
      0162, 0021, 0377, 0220, 0377, 0377, 0363, 0367, 0000, 0067,
      0001, 0125, 0125, 0125, 0000, 0000, 0000, 0052, 0357, 0377,
      0372, 0253, 0377, 0372, 0253, 0377, 0252, 0377, 0377, 0353,
      0377, 0252, 0277, 0252, 0377, 0376, 0356, 0240, 0000, 0000,
      0105, 0125, 0125, 0130, 0005, 0337, 0346, 0105, 0377, 0304,
      0377, 0377, 0347, 0377, 0304, 0035, 0204, 0125, 0125, 0125,
      0100, 0000, 0000, 0252, 0253, 0277, 0372, 0253, 0377, 0356,
      0253, 0377, 0252, 0377, 0377, 0373, 0377, 0352, 0277, 0252,
      0377, 0273, 0252, 0250, 0000, 0000, 0025, 0125, 0125, 0120,
      0003, 0167, 0104, 0003, 0177, 0000, 0177, 0177, 0171, 0167,
      0100, 0067, 0100, 0125, 0125, 0125, 0020, 0000, 0000, 0252,
      0357, 0377, 0372, 0253, 0377, 0356, 0253, 0377, 0252, 0377,
      0377, 0373, 0377, 0352, 0277, 0352, 0277, 0376, 0356, 0250,
      0000, 0000, 0125, 0125, 0125, 0320, 0105, 0375, 0314, 0107,
      0377, 0104, 0377, 0377, 0375, 0377, 0304, 0135, 0300, 0125,
      0125, 0125, 0124, 0000, 0002, 0252, 0273, 0277, 0376, 0257,
      0377, 0356, 0253, 0377, 0252, 0377, 0377, 0373, 0377, 0352,
      0277, 0352, 0277, 0373, 0272, 0252, 0000, 0000, 0025, 0125,
      0125, 0124, 0007, 0167, 0104, 0003, 0367, 0020, 0377, 0377,
      0361, 0367, 0100, 0027, 0140, 0025, 0125, 0125, 0120, 0000,
      0002, 0252, 0357, 0377, 0356, 0257, 0377, 0356, 0253, 0377,
      0252, 0377, 0377, 0373, 0377, 0352, 0277, 0372, 0277, 0376,
      0356, 0252, 0000, 0000, 0125, 0125, 0125, 0104, 0005, 0337,
      0334, 0107, 0374, 0105, 0377, 0377, 0375, 0377, 0304, 0015,
      0324, 0025, 0125, 0125, 0104, 0000, 0002, 0252, 0253, 0277,
      0352, 0253, 0377, 0272, 0253, 0376, 0253, 0377, 0377, 0377,
      0377, 0352, 0257, 0372, 0277, 0273, 0252, 0252, 0000, 0001,
      0025, 0125, 0125, 0100, 0007, 0167, 0060, 0003, 0174, 0001,
      0177, 0177, 0165, 0167, 0140, 0007, 0120, 0025, 0125, 0125,
      0020, 0000, 0012, 0252, 0357, 0377, 0356, 0257, 0377, 0272,
      0253, 0376, 0253, 0377, 0377, 0377, 0377, 0352, 0257, 0372,
      0277, 0376, 0356, 0252, 0200, 0004, 0125, 0125, 0125, 0104,
      0105, 0335, 0174, 0107, 0374, 0105, 0377, 0377, 0375, 0377,
      0344, 0115, 0330, 0105, 0125, 0125, 0124, 0000, 0012, 0252,
      0273, 0273, 0356, 0257, 0377, 0272, 0257, 0376, 0253, 0377,
      0377, 0377, 0377, 0352, 0257, 0372, 0257, 0373, 0272, 0252,
      0200, 0001, 0025, 0125, 0125, 0100, 0005, 0167, 0060, 0007,
      0164, 0021, 0367, 0367, 0367, 0167, 0140, 0005, 0160, 0005,
      0125, 0125, 0120, 0000, 0012, 0252, 0357, 0377, 0372, 0253,
      0377, 0272, 0257, 0376, 0253, 0377, 0377, 0377, 0377, 0352,
      0257, 0372, 0257, 0376, 0356, 0252, 0200, 0004, 0125, 0125,
      0125, 0130, 0005, 0334, 0034, 0107, 0374, 0105, 0377, 0377,
      0377, 0337, 0304, 0005, 0320, 0005, 0125, 0125, 0124, 0000,
      0012, 0252, 0253, 0277, 0276, 0257, 0376, 0372, 0257, 0376,
      0253, 0377, 0377, 0377, 0377, 0372, 0257, 0372, 0257, 0273,
      0252, 0252, 0200, 0001, 0025, 0125, 0125, 0024, 0005, 0124,
      0160, 0007, 0164, 0001, 0167, 0167, 0167, 0167, 0160, 0005,
      0120, 0005, 0125, 0125, 0020, 0000, 0052, 0252, 0356, 0377,
      0276, 0257, 0376, 0372, 0257, 0376, 0253, 0377, 0377, 0377,
      0377, 0372, 0257, 0372, 0257, 0376, 0356, 0252, 0240, 0004,
      0125, 0125, 0125, 0020, 0105, 0334, 0324, 0107, 0374, 0105,
      0377, 0377, 0377, 0375, 0324, 0105, 0330, 0005, 0125, 0125,
      0124, 0000, 0052, 0252, 0273, 0273, 0272, 0257, 0376, 0372,
      0257, 0372, 0253, 0377, 0377, 0377, 0377, 0372, 0257, 0372,
      0253, 0273, 0272, 0252, 0240, 0001, 0025, 0125, 0125, 0020,
      0001, 0164, 0160, 0007, 0160, 0001, 0167, 0167, 0167, 0167,
      0160, 0005, 0120, 0005, 0125, 0125, 0120, 0000, 0052, 0252,
      0356, 0357, 0272, 0253, 0376, 0372, 0257, 0372, 0253, 0377,
      0377, 0377, 0377, 0372, 0257, 0372, 0257, 0356, 0356, 0252,
      0240, 0004, 0125, 0125, 0125, 0020, 0001, 0334, 0324, 0007,
      0334, 0105, 0337, 0337, 0337, 0335, 0324, 0005, 0130, 0005,
      0125, 0125, 0104, 0000, 0052, 0252, 0253, 0273, 0072, 0253,
      0372, 0372, 0257, 0372, 0253, 0377, 0377, 0377, 0377, 0372,
      0257, 0372, 0253, 0273, 0252, 0252, 0240, 0001, 0025, 0125,
      0125, 0024, 0001, 0120, 0120, 0007, 0160, 0001, 0167, 0167,
      0167, 0167, 0120, 0005, 0120, 0005, 0125, 0125, 0020, 0000,
      0052, 0252, 0356, 0377, 0276, 0257, 0372, 0372, 0257, 0372,
      0253, 0377, 0377, 0377, 0377, 0372, 0253, 0372, 0257, 0376,
      0352, 0252, 0240, 0004, 0125, 0125, 0125, 0024, 0105, 0331,
      0320, 0105, 0374, 0105, 0375, 0375, 0375, 0335, 0320, 0101,
      0320, 0005, 0125, 0125, 0124, 0000, 0052, 0252, 0253, 0273,
      0276, 0257, 0373, 0372, 0257, 0372, 0253, 0377, 0377, 0377,
      0377, 0372, 0253, 0372, 0253, 0272, 0252, 0252, 0240, 0001,
      0025, 0125, 0125, 0024, 0005, 0121, 0160, 0007, 0160, 0001,
      0167, 0167, 0167, 0167, 0160, 0001, 0120, 0025, 0125, 0125,
      0120, 0000, 0052, 0252, 0256, 0357, 0276, 0257, 0373, 0372,
      0257, 0372, 0253, 0377, 0377, 0377, 0377, 0372, 0253, 0372,
      0277, 0356, 0352, 0252, 0240, 0004, 0125, 0125, 0125, 0024,
      0001, 0121, 0324, 0005, 0334, 0005, 0335, 0335, 0335, 0335,
      0324, 0000, 0020, 0025, 0125, 0125, 0104, 0000, 0052, 0252,
      0253, 0273, 0076, 0253, 0373, 0372, 0257, 0372, 0253, 0377,
      0377, 0377, 0377, 0372, 0252, 0252, 0073, 0252, 0252, 0252,
      0240, 0001, 0025, 0125, 0125, 0024, 0001, 0121, 0120, 0007,
      0120, 0001, 0167, 0167, 0127, 0125, 0120, 0000, 0000, 0125,
      0125, 0125, 0020, 0000, 0052, 0252, 0356, 0356, 0276, 0253,
      0373, 0372, 0257, 0372, 0253, 0377, 0377, 0377, 0377, 0372,
      0252, 0252, 0376, 0356, 0352, 0252, 0240, 0004, 0125, 0125,
      0125, 0024, 0001, 0305, 0320, 0105, 0330, 0105, 0335, 0335,
      0335, 0335, 0320, 0100, 0000, 0125, 0125, 0125, 0104, 0000,
      0052, 0252, 0252, 0273, 0272, 0253, 0357, 0372, 0257, 0372,
      0253, 0377, 0377, 0377, 0377, 0372, 0252, 0252, 0273, 0272,
      0252, 0252, 0240, 0000, 0021, 0125, 0125, 0024, 0001, 0105,
      0120, 0005, 0160, 0001, 0165, 0165, 0165, 0165, 0120, 0000,
      0000, 0125, 0125, 0121, 0020, 0000, 0012, 0252, 0256, 0356,
      0256, 0253, 0357, 0372, 0257, 0372, 0253, 0377, 0377, 0377,
      0377, 0372, 0252, 0252, 0356, 0356, 0252, 0252, 0200, 0000,
      0105, 0125, 0125, 0024, 0001, 0105, 0120, 0005, 0334, 0005,
      0335, 0335, 0335, 0335, 0120, 0000, 0000, 0125, 0125, 0125,
      0104, 0000, 0052, 0252, 0252, 0253, 0072, 0053, 0257, 0372,
      0257, 0372, 0253, 0377, 0377, 0377, 0377, 0372, 0252, 0052,
      0273, 0252, 0252, 0252, 0040, 0000, 0021, 0025, 0125, 0024,
      0001, 0105, 0120, 0005, 0120, 0001, 0125, 0125, 0125, 0125,
      0120, 0000, 0000, 0125, 0125, 0121, 0000, 0000, 0052, 0252,
      0252, 0356, 0276, 0253, 0357, 0372, 0257, 0372, 0253, 0377,
      0352, 0252, 0253, 0372, 0253, 0252, 0356, 0352, 0252, 0252,
      0240, 0000, 0105, 0125, 0125, 0024, 0001, 0105, 0120, 0105,
      0330, 0101, 0335, 0300, 0100, 0101, 0320, 0001, 0000, 0125,
      0125, 0124, 0100, 0000, 0042, 0252, 0252, 0252, 0273, 0253,
      0357, 0372, 0257, 0372, 0253, 0377, 0352, 0252, 0253, 0372,
      0253, 0242, 0272, 0252, 0252, 0252, 0240, 0000, 0021, 0025,
      0125, 0025, 0001, 0105, 0120, 0005, 0120, 0001, 0125, 0100,
      0000, 0001, 0120, 0001, 0000, 0125, 0125, 0121, 0000, 0000,
      0012, 0252, 0252, 0256, 0256, 0253, 0357, 0372, 0257, 0372,
      0253, 0377, 0352, 0252, 0253, 0372, 0253, 0252, 0356, 0252,
      0252, 0252, 0200, 0000, 0005, 0125, 0125, 0025, 0000, 0105,
      0120, 0005, 0130, 0001, 0135, 0100, 0000, 0001, 0120, 0005,
      0000, 0125, 0125, 0124, 0100, 0000, 0002, 0252, 0252, 0252,
      0053, 0252, 0253, 0272, 0257, 0372, 0253, 0377, 0352, 0252,
      0253, 0272, 0053, 0052, 0052, 0252, 0252, 0252, 0000, 0000,
      0001, 0025, 0125, 0025, 0000, 0105, 0120, 0005, 0120, 0001,
      0125, 0100, 0000, 0001, 0120, 0005, 0000, 0125, 0125, 0021,
      0000, 0000, 0012, 0252, 0252, 0252, 0256, 0252, 0357, 0372,
      0257, 0376, 0253, 0377, 0376, 0252, 0277, 0372, 0256, 0252,
      0356, 0352, 0252, 0252, 0200, 0000, 0104, 0125, 0125, 0025,
      0000, 0105, 0120, 0005, 0124, 0001, 0325, 0324, 0000, 0025,
      0120, 0005, 0000, 0025, 0125, 0124, 0100, 0000, 0002, 0252,
      0252, 0252, 0272, 0242, 0253, 0272, 0257, 0376, 0253, 0377,
      0376, 0252, 0273, 0372, 0243, 0242, 0252, 0252, 0252, 0252,
      0000, 0000, 0000, 0021, 0125, 0025, 0000, 0105, 0120, 0005,
      0124, 0001, 0125, 0124, 0000, 0025, 0120, 0005, 0000, 0125,
      0121, 0020, 0000, 0000, 0012, 0252, 0252, 0252, 0256, 0252,
      0357, 0372, 0257, 0376, 0253, 0377, 0377, 0252, 0377, 0352,
      0256, 0252, 0252, 0252, 0252, 0252, 0200, 0000, 0004, 0105,
      0125, 0025, 0100, 0105, 0120, 0005, 0124, 0001, 0125, 0125,
      0000, 0125, 0120, 0005, 0100, 0025, 0125, 0104, 0000, 0000,
      0002, 0052, 0252, 0252, 0252, 0242, 0053, 0272, 0053, 0276,
      0053, 0277, 0277, 0052, 0073, 0272, 0043, 0242, 0052, 0252,
      0252, 0242, 0000, 0000, 0000, 0021, 0025, 0125, 0100, 0005,
      0120, 0005, 0124, 0001, 0125, 0125, 0000, 0125, 0100, 0005,
      0000, 0025, 0021, 0000, 0000, 0000, 0000, 0252, 0252, 0252,
      0252, 0352, 0256, 0372, 0257, 0376, 0252, 0377, 0377, 0252,
      0376, 0352, 0256, 0252, 0252, 0252, 0252, 0250, 0200, 0000,
      0000, 0104, 0125, 0105, 0100, 0005, 0120, 0005, 0124, 0000,
      0125, 0125, 0000, 0125, 0100, 0005, 0000, 0125, 0124, 0104,
      0000, 0000, 0000, 0052, 0252, 0252, 0252, 0242, 0253, 0272,
      0243, 0272, 0252, 0273, 0273, 0252, 0273, 0242, 0252, 0242,
      0052, 0252, 0252, 0240, 0000, 0000, 0000, 0021, 0021, 0105,
      0100, 0005, 0120, 0001, 0124, 0000, 0125, 0125, 0000, 0125,
      0100, 0005, 0000, 0021, 0021, 0000, 0000, 0000, 0000, 0212,
      0252, 0252, 0212, 0252, 0256, 0352, 0253, 0356, 0252, 0357,
      0357, 0252, 0356, 0352, 0256, 0252, 0212, 0252, 0252, 0210,
      0000, 0000, 0000, 0004, 0105, 0105, 0120, 0005, 0120, 0001,
      0124, 0000, 0125, 0125, 0000, 0125, 0100, 0005, 0100, 0025,
      0104, 0100, 0000, 0000, 0000, 0042, 0252, 0252, 0242, 0252,
      0052, 0252, 0053, 0273, 0052, 0273, 0273, 0052, 0273, 0242,
      0052, 0242, 0052, 0252, 0252, 0040, 0000, 0000, 0000, 0001,
      0021, 0005, 0120, 0005, 0120, 0001, 0125, 0000, 0125, 0125,
      0000, 0125, 0100, 0005, 0100, 0021, 0000, 0000, 0000, 0000,
      0000, 0212, 0252, 0252, 0252, 0252, 0256, 0356, 0252, 0356,
      0252, 0376, 0376, 0252, 0356, 0352, 0252, 0250, 0252, 0252,
      0252, 0210, 0000, 0000, 0000, 0004, 0104, 0125, 0120, 0005,
      0124, 0001, 0125, 0000, 0125, 0125, 0000, 0125, 0100, 0025,
      0100, 0024, 0104, 0100, 0000, 0000, 0000, 0002, 0252, 0252,
      0242, 0252, 0042, 0252, 0242, 0273, 0242, 0273, 0272, 0242,
      0272, 0242, 0052, 0242, 0052, 0252, 0242, 0000, 0000, 0000,
      0000, 0000, 0021, 0021, 0124, 0005, 0124, 0001, 0125, 0000,
      0125, 0124, 0000, 0125, 0100, 0025, 0000, 0021, 0000, 0000,
      0000, 0000, 0000, 0010, 0252, 0252, 0252, 0252, 0212, 0256,
      0252, 0356, 0252, 0356, 0356, 0252, 0356, 0252, 0212, 0210,
      0252, 0252, 0250, 0200, 0000, 0000, 0000, 0000, 0004, 0101,
      0124, 0005, 0124, 0001, 0125, 0000, 0125, 0124, 0000, 0125,
      0100, 0025, 0100, 0004, 0100, 0000, 0000, 0000, 0000, 0002,
      0052, 0252, 0242, 0252, 0042, 0252, 0042, 0252, 0242, 0252,
      0252, 0042, 0252, 0242, 0052, 0242, 0052, 0252, 0042, 0000,
      0000, 0000, 0000, 0000, 0000, 0021, 0020, 0005, 0124, 0001,
      0125, 0000, 0125, 0124, 0001, 0125, 0000, 0021, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0252, 0252, 0250, 0252,
      0252, 0252, 0252, 0356, 0252, 0356, 0356, 0252, 0352, 0250,
      0252, 0250, 0252, 0252, 0250, 0200, 0000, 0000, 0000, 0000,
      0004, 0100, 0125, 0005, 0124, 0001, 0125, 0000, 0125, 0124,
      0001, 0125, 0000, 0025, 0100, 0004, 0100, 0000, 0000, 0000,
      0000, 0000, 0042, 0252, 0252, 0252, 0042, 0252, 0042, 0252,
      0242, 0052, 0252, 0042, 0252, 0242, 0052, 0242, 0052, 0242,
      0040, 0000, 0000, 0000, 0000, 0000, 0000, 0020, 0021, 0001,
      0124, 0001, 0125, 0100, 0125, 0124, 0001, 0125, 0000, 0021,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0012, 0252,
      0250, 0252, 0212, 0252, 0212, 0252, 0212, 0252, 0252, 0212,
      0252, 0212, 0252, 0210, 0252, 0252, 0210, 0000, 0000, 0000,
      0000, 0000, 0000, 0004, 0104, 0105, 0125, 0001, 0125, 0100,
      0125, 0124, 0001, 0125, 0000, 0104, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0002, 0042, 0242, 0052, 0242, 0252,
      0042, 0252, 0242, 0052, 0252, 0042, 0252, 0042, 0252, 0202,
      0052, 0042, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0001, 0001, 0021, 0000, 0025, 0000, 0025, 0024, 0001, 0021,
      0000, 0021, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0010, 0252, 0250, 0212, 0252, 0252, 0250, 0252, 0250, 0252,
      0250, 0252, 0252, 0250, 0252, 0210, 0252, 0250, 0200, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0004, 0100, 0125, 0000,
      0125, 0120, 0025, 0124, 0001, 0124, 0000, 0104, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0042, 0250, 0042,
      0242, 0252, 0242, 0252, 0252, 0052, 0252, 0042, 0252, 0042,
      0252, 0040, 0242, 0040, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0021, 0021, 0000, 0021, 0020, 0021, 0020,
      0001, 0020, 0000, 0020, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0010, 0252, 0210, 0252, 0252, 0210, 0252,
      0250, 0212, 0250, 0212, 0252, 0210, 0252, 0212, 0250, 0210,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0104, 0000, 0105, 0104, 0005, 0100, 0004, 0104, 0000, 0104,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0002,
      0042, 0052, 0252, 0252, 0042, 0052, 0252, 0052, 0252, 0042,
      0242, 0002, 0052, 0252, 0042, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0021, 0020,
      0001, 0020, 0021, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0010, 0212, 0252, 0250, 0252,
      0210, 0212, 0252, 0212, 0250, 0212, 0250, 0210, 0252, 0252,
      0210, 0200, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0104, 0000, 0004, 0104, 0000, 0100, 0004, 0100,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0042, 0042, 0252, 0252, 0042, 0052, 0252, 0042,
      0242, 0052, 0242, 0052, 0242, 0042, 0040, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0020, 0000, 0000, 0020, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0010, 0212,
      0252, 0252, 0250, 0212, 0252, 0210, 0210, 0252, 0252, 0252,
      0252, 0210, 0210, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0004, 0004, 0104, 0100, 0000,
      0004, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0002, 0042, 0052, 0252, 0252,
      0252, 0202, 0012, 0252, 0252, 0052, 0042, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0210, 0252, 0252, 0252, 0252, 0252, 0250, 0212, 0252,
      0252, 0252, 0250, 0210, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0042, 0042,
      0042, 0242, 0252, 0252, 0252, 0242, 0242, 0042, 0040, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0010, 0210, 0212, 0252, 0252, 0252,
      0252, 0252, 0210, 0210, 0210, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0002, 0042, 0042, 0042, 0042, 0042, 0042, 0042, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0210, 0210, 0210,
      0250, 0250, 0250, 0210, 0210, 0200, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0040, 0042, 0042, 0040, 0040,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0010, 0210, 0210, 0210, 0010, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 
  };

    /* This is actually a macro that defines BITMAP ball_1 */
  bit_static(ball_1, 181, 181, ball_1_data, 1, 0);
    

/* bitmap for "cr", 472 wide, 83 high, 1 bit deep */
  static char cr_data[4897] = {
      0000, 0000, 0177, 0374, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0020, 0000, 0000, 0003, 0340, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0001, 0300, 0000, 0340, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0003, 0377, 0377, 0200, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0160, 0000, 0000, 0037, 0374, 0000, 0000, 0003, 0377,
      0000, 0000, 0001, 0377, 0200, 0000, 0000, 0000, 0000, 0007,
      0377, 0377, 0377, 0300, 0000, 0000, 0000, 0000, 0000, 0037,
      0300, 0017, 0340, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0017,
      0360, 0037, 0360, 0000, 0000, 0000, 0000, 0000, 0000, 0001,
      0360, 0000, 0000, 0174, 0017, 0000, 0000, 0017, 0317, 0340,
      0000, 0007, 0347, 0360, 0000, 0000, 0000, 0000, 0000, 0377,
      0377, 0377, 0370, 0000, 0000, 0000, 0000, 0000, 0377, 0300,
      0177, 0340, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0077, 0200,
      0003, 0370, 0000, 0000, 0000, 0000, 0000, 0000, 0003, 0360,
      0000, 0000, 0360, 0007, 0300, 0000, 0074, 0001, 0360, 0000,
      0036, 0000, 0370, 0000, 0000, 0000, 0000, 0000, 0077, 0370,
      0007, 0376, 0000, 0000, 0000, 0000, 0001, 0377, 0300, 0377,
      0340, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0177, 0000, 0000,
      0376, 0000, 0000, 0000, 0000, 0000, 0000, 0017, 0360, 0000,
      0001, 0340, 0003, 0340, 0000, 0170, 0000, 0370, 0000, 0074,
      0000, 0174, 0000, 0000, 0000, 0000, 0000, 0017, 0360, 0000,
      0377, 0200, 0000, 0000, 0000, 0000, 0037, 0300, 0017, 0340,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0374, 0000, 0000, 0177,
      0000, 0000, 0000, 0000, 0000, 0000, 0077, 0360, 0000, 0003,
      0340, 0001, 0360, 0000, 0360, 0000, 0174, 0000, 0170, 0000,
      0076, 0000, 0000, 0000, 0000, 0000, 0017, 0360, 0000, 0077,
      0300, 0000, 0000, 0000, 0000, 0017, 0300, 0007, 0340, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0001, 0370, 0000, 0000, 0077, 0200,
      0000, 0000, 0000, 0000, 0000, 0377, 0360, 0000, 0007, 0300,
      0001, 0360, 0000, 0340, 0000, 0076, 0000, 0160, 0000, 0037,
      0000, 0000, 0000, 0000, 0000, 0017, 0360, 0000, 0037, 0340,
      0000, 0000, 0000, 0000, 0017, 0300, 0007, 0340, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0003, 0360, 0000, 0000, 0037, 0300, 0000,
      0000, 0000, 0000, 0001, 0303, 0360, 0000, 0007, 0300, 0000,
      0370, 0001, 0340, 0000, 0076, 0000, 0360, 0000, 0037, 0000,
      0000, 0000, 0000, 0000, 0017, 0360, 0000, 0017, 0360, 0000,
      0000, 0000, 0000, 0017, 0300, 0007, 0340, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0007, 0360, 0000, 0000, 0017, 0340, 0000, 0000,
      0000, 0000, 0007, 0003, 0360, 0000, 0017, 0300, 0000, 0374,
      0001, 0340, 0000, 0036, 0000, 0360, 0000, 0017, 0000, 0000,
      0000, 0000, 0000, 0017, 0360, 0000, 0007, 0360, 0000, 0000,
      0000, 0000, 0017, 0300, 0007, 0340, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0017, 0340, 0000, 0000, 0007, 0360, 0000, 0000, 0000,
      0000, 0004, 0003, 0360, 0000, 0017, 0200, 0000, 0374, 0003,
      0340, 0000, 0036, 0001, 0360, 0000, 0017, 0000, 0000, 0000,
      0000, 0000, 0017, 0360, 0000, 0007, 0360, 0000, 0000, 0000,
      0000, 0017, 0300, 0007, 0340, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0037, 0300, 0000, 0340, 0007, 0360, 0000, 0000, 0000, 0000,
      0000, 0003, 0360, 0000, 0017, 0200, 0000, 0174, 0003, 0340,
      0000, 0036, 0001, 0360, 0000, 0017, 0000, 0000, 0000, 0000,
      0000, 0017, 0360, 0000, 0007, 0370, 0000, 0000, 0000, 0000,
      0017, 0300, 0007, 0340, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0037,
      0300, 0017, 0376, 0003, 0370, 0000, 0000, 0000, 0000, 0000,
      0003, 0360, 0000, 0037, 0200, 0000, 0176, 0003, 0340, 0000,
      0036, 0001, 0360, 0000, 0017, 0000, 0000, 0000, 0000, 0000,
      0017, 0360, 0000, 0007, 0370, 0000, 0000, 0000, 0000, 0017,
      0300, 0007, 0340, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0077, 0300,
      0076, 0077, 0003, 0370, 0000, 0000, 0000, 0000, 0000, 0003,
      0360, 0000, 0037, 0200, 0000, 0176, 0003, 0340, 0000, 0036,
      0001, 0360, 0000, 0017, 0000, 0000, 0000, 0000, 0000, 0017,
      0360, 0000, 0007, 0370, 0000, 0000, 0000, 0000, 0017, 0300,
      0007, 0340, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0077, 0200, 0170,
      0017, 0203, 0374, 0000, 0000, 0000, 0000, 0000, 0003, 0360,
      0000, 0037, 0200, 0000, 0176, 0003, 0360, 0000, 0036, 0001,
      0370, 0000, 0017, 0000, 0000, 0000, 0000, 0000, 0017, 0360,
      0000, 0007, 0370, 0000, 0000, 0000, 0000, 0017, 0300, 0007,
      0340, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0177, 0200, 0360, 0017,
      0301, 0374, 0000, 0000, 0000, 0000, 0000, 0003, 0360, 0000,
      0037, 0200, 0000, 0176, 0003, 0360, 0000, 0074, 0001, 0370,
      0000, 0036, 0000, 0000, 0000, 0000, 0000, 0017, 0360, 0000,
      0007, 0370, 0000, 0000, 0000, 0000, 0017, 0300, 0007, 0340,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0177, 0201, 0340, 0017, 0301,
      0376, 0000, 0000, 0000, 0000, 0000, 0003, 0360, 0000, 0037,
      0200, 0000, 0177, 0003, 0370, 0000, 0074, 0001, 0374, 0000,
      0036, 0000, 0000, 0000, 0000, 0000, 0017, 0360, 0000, 0007,
      0360, 0000, 0007, 0360, 0000, 0017, 0300, 0007, 0340, 0000,
      0003, 0370, 0000, 0000, 0077, 0340, 0000, 0000, 0060, 0174,
      0000, 0003, 0370, 0000, 0177, 0001, 0300, 0007, 0301, 0376,
      0000, 0000, 0000, 0000, 0000, 0003, 0360, 0000, 0037, 0200,
      0000, 0177, 0001, 0374, 0000, 0170, 0000, 0376, 0000, 0074,
      0000, 0000, 0000, 0000, 0000, 0017, 0360, 0000, 0007, 0360,
      0000, 0077, 0374, 0000, 0017, 0300, 0007, 0340, 0000, 0037,
      0377, 0000, 0001, 0377, 0374, 0000, 0001, 0360, 0376, 0000,
      0037, 0376, 0000, 0377, 0003, 0300, 0007, 0201, 0376, 0000,
      0000, 0000, 0000, 0000, 0003, 0360, 0000, 0037, 0200, 0000,
      0177, 0001, 0376, 0000, 0160, 0000, 0377, 0000, 0070, 0000,
      0000, 0000, 0000, 0000, 0017, 0360, 0000, 0017, 0340, 0000,
      0370, 0376, 0000, 0017, 0300, 0007, 0340, 0000, 0174, 0077,
      0200, 0007, 0300, 0177, 0000, 0017, 0361, 0377, 0000, 0174,
      0177, 0000, 0377, 0003, 0300, 0001, 0000, 0376, 0000, 0000,
      0000, 0000, 0000, 0003, 0360, 0000, 0037, 0200, 0000, 0177,
      0000, 0377, 0200, 0340, 0000, 0177, 0300, 0160, 0000, 0000,
      0000, 0000, 0000, 0017, 0360, 0000, 0017, 0340, 0001, 0340,
      0037, 0200, 0017, 0300, 0007, 0340, 0000, 0360, 0017, 0300,
      0017, 0000, 0077, 0200, 0177, 0363, 0377, 0000, 0360, 0017,
      0300, 0377, 0007, 0300, 0000, 0000, 0377, 0000, 0000, 0000,
      0000, 0000, 0003, 0360, 0000, 0037, 0300, 0000, 0177, 0000,
      0177, 0301, 0300, 0000, 0077, 0340, 0340, 0000, 0000, 0000,
      0000, 0000, 0017, 0360, 0000, 0077, 0200, 0003, 0300, 0017,
      0300, 0017, 0300, 0007, 0340, 0001, 0340, 0017, 0340, 0036,
      0000, 0037, 0300, 0177, 0367, 0377, 0001, 0340, 0007, 0340,
      0377, 0007, 0200, 0000, 0000, 0377, 0000, 0000, 0000, 0000,
      0000, 0003, 0360, 0000, 0037, 0300, 0000, 0177, 0000, 0177,
      0347, 0000, 0000, 0077, 0363, 0200, 0000, 0000, 0000, 0000,
      0000, 0017, 0360, 0000, 0177, 0000, 0007, 0200, 0007, 0300,
      0017, 0300, 0007, 0340, 0003, 0300, 0007, 0340, 0076, 0000,
      0017, 0340, 0007, 0376, 0076, 0003, 0300, 0003, 0340, 0377,
      0007, 0200, 0000, 0000, 0377, 0000, 0000, 0000, 0000, 0000,
      0003, 0360, 0000, 0017, 0300, 0000, 0177, 0000, 0037, 0374,
      0000, 0000, 0017, 0376, 0000, 0000, 0000, 0000, 0000, 0000,
      0017, 0360, 0003, 0374, 0000, 0017, 0000, 0007, 0340, 0017,
      0300, 0007, 0340, 0007, 0200, 0007, 0340, 0174, 0000, 0007,
      0360, 0003, 0370, 0000, 0007, 0200, 0003, 0360, 0377, 0007,
      0200, 0000, 0000, 0377, 0000, 0000, 0000, 0000, 0000, 0003,
      0360, 0000, 0017, 0340, 0000, 0176, 0000, 0017, 0376, 0000,
      0000, 0007, 0377, 0000, 0000, 0000, 0000, 0000, 0000, 0017,
      0377, 0377, 0360, 0000, 0016, 0000, 0007, 0340, 0017, 0300,
      0007, 0340, 0017, 0200, 0007, 0340, 0174, 0000, 0007, 0360,
      0003, 0370, 0000, 0007, 0000, 0003, 0360, 0377, 0007, 0200,
      0000, 0000, 0377, 0000, 0000, 0000, 0000, 0000, 0003, 0360,
      0000, 0017, 0340, 0000, 0176, 0000, 0007, 0377, 0000, 0000,
      0003, 0377, 0200, 0000, 0000, 0000, 0000, 0000, 0017, 0377,
      0377, 0376, 0000, 0036, 0000, 0003, 0360, 0017, 0300, 0007,
      0340, 0017, 0000, 0003, 0340, 0370, 0000, 0003, 0370, 0003,
      0360, 0000, 0017, 0000, 0001, 0370, 0377, 0007, 0300, 0000,
      0000, 0377, 0000, 0000, 0000, 0000, 0000, 0003, 0360, 0000,
      0007, 0360, 0000, 0176, 0000, 0003, 0377, 0200, 0000, 0001,
      0377, 0300, 0000, 0000, 0000, 0000, 0000, 0017, 0360, 0007,
      0377, 0200, 0036, 0000, 0003, 0360, 0017, 0300, 0007, 0340,
      0037, 0000, 0001, 0300, 0370, 0000, 0003, 0370, 0003, 0360,
      0000, 0017, 0000, 0001, 0370, 0377, 0007, 0300, 0000, 0000,
      0377, 0000, 0000, 0000, 0000, 0000, 0003, 0360, 0000, 0003,
      0360, 0000, 0376, 0000, 0007, 0377, 0340, 0000, 0003, 0377,
      0360, 0000, 0000, 0000, 0000, 0000, 0017, 0360, 0000, 0177,
      0340, 0076, 0000, 0003, 0360, 0017, 0300, 0007, 0340, 0037,
      0000, 0000, 0001, 0370, 0000, 0001, 0370, 0003, 0360, 0000,
      0037, 0000, 0001, 0370, 0377, 0007, 0300, 0000, 0000, 0377,
      0000, 0000, 0000, 0000, 0000, 0003, 0360, 0000, 0003, 0374,
      0001, 0376, 0000, 0034, 0077, 0360, 0000, 0016, 0037, 0370,
      0000, 0000, 0000, 0000, 0000, 0017, 0360, 0000, 0037, 0360,
      0077, 0377, 0377, 0360, 0017, 0300, 0007, 0340, 0037, 0000,
      0000, 0001, 0370, 0000, 0001, 0374, 0003, 0360, 0000, 0037,
      0377, 0377, 0370, 0377, 0007, 0300, 0000, 0000, 0376, 0000,
      0000, 0000, 0000, 0000, 0003, 0360, 0000, 0001, 0376, 0007,
      0374, 0000, 0070, 0037, 0370, 0000, 0034, 0017, 0374, 0000,
      0000, 0000, 0000, 0000, 0017, 0360, 0000, 0017, 0370, 0077,
      0377, 0377, 0360, 0017, 0300, 0007, 0340, 0037, 0000, 0000,
      0001, 0360, 0000, 0001, 0374, 0003, 0360, 0000, 0037, 0377,
      0377, 0370, 0377, 0007, 0340, 0000, 0000, 0376, 0000, 0000,
      0000, 0000, 0000, 0003, 0360, 0000, 0000, 0177, 0376, 0374,
      0000, 0360, 0017, 0374, 0000, 0170, 0007, 0376, 0000, 0000,
      0000, 0000, 0000, 0017, 0360, 0000, 0007, 0374, 0076, 0000,
      0000, 0000, 0017, 0300, 0007, 0340, 0077, 0000, 0000, 0003,
      0360, 0000, 0001, 0374, 0003, 0360, 0000, 0037, 0000, 0000,
      0000, 0377, 0003, 0340, 0000, 0141, 0376, 0000, 0000, 0000,
      0000, 0000, 0003, 0360, 0000, 0000, 0077, 0370, 0374, 0001,
      0360, 0003, 0376, 0000, 0370, 0001, 0377, 0000, 0000, 0000,
      0000, 0000, 0017, 0360, 0000, 0003, 0374, 0076, 0000, 0000,
      0000, 0017, 0300, 0007, 0340, 0077, 0000, 0000, 0003, 0360,
      0000, 0000, 0374, 0003, 0360, 0000, 0037, 0000, 0000, 0000,
      0377, 0003, 0360, 0000, 0301, 0376, 0000, 0000, 0000, 0000,
      0000, 0003, 0360, 0000, 0000, 0003, 0200, 0370, 0001, 0340,
      0001, 0376, 0000, 0360, 0000, 0377, 0000, 0000, 0000, 0000,
      0000, 0017, 0360, 0000, 0003, 0376, 0176, 0000, 0000, 0000,
      0017, 0300, 0007, 0340, 0077, 0000, 0000, 0003, 0360, 0000,
      0000, 0374, 0003, 0360, 0000, 0077, 0000, 0000, 0000, 0177,
      0003, 0370, 0001, 0201, 0376, 0000, 0000, 0000, 0000, 0000,
      0003, 0360, 0000, 0000, 0000, 0001, 0370, 0003, 0300, 0000,
      0377, 0001, 0340, 0000, 0177, 0200, 0000, 0000, 0000, 0000,
      0017, 0360, 0000, 0001, 0376, 0176, 0000, 0000, 0000, 0017,
      0300, 0007, 0340, 0077, 0000, 0000, 0003, 0370, 0000, 0000,
      0374, 0003, 0360, 0000, 0077, 0000, 0000, 0000, 0177, 0201,
      0374, 0003, 0201, 0374, 0000, 0000, 0000, 0000, 0000, 0003,
      0360, 0000, 0000, 0000, 0001, 0370, 0003, 0300, 0000, 0177,
      0001, 0340, 0000, 0077, 0200, 0000, 0000, 0000, 0000, 0017,
      0360, 0000, 0001, 0376, 0176, 0000, 0000, 0000, 0017, 0300,
      0007, 0340, 0077, 0000, 0000, 0003, 0370, 0000, 0000, 0374,
      0003, 0360, 0000, 0077, 0000, 0000, 0000, 0177, 0200, 0377,
      0377, 0001, 0374, 0000, 0000, 0000, 0000, 0000, 0003, 0360,
      0000, 0000, 0000, 0001, 0360, 0007, 0300, 0000, 0077, 0003,
      0340, 0000, 0037, 0200, 0000, 0000, 0000, 0000, 0017, 0360,
      0000, 0001, 0376, 0176, 0000, 0000, 0000, 0017, 0300, 0007,
      0340, 0077, 0000, 0000, 0003, 0370, 0000, 0000, 0374, 0003,
      0360, 0000, 0077, 0000, 0000, 0000, 0077, 0200, 0177, 0376,
      0003, 0370, 0000, 0000, 0000, 0000, 0000, 0003, 0360, 0000,
      0000, 0000, 0003, 0360, 0007, 0300, 0000, 0037, 0203, 0340,
      0000, 0017, 0300, 0000, 0000, 0000, 0000, 0017, 0360, 0000,
      0001, 0376, 0076, 0000, 0000, 0000, 0017, 0300, 0007, 0340,
      0077, 0000, 0000, 0003, 0370, 0000, 0000, 0374, 0003, 0360,
      0000, 0037, 0000, 0000, 0000, 0077, 0300, 0077, 0374, 0003,
      0370, 0000, 0000, 0000, 0000, 0000, 0003, 0360, 0000, 0000,
      0000, 0003, 0340, 0007, 0300, 0000, 0037, 0203, 0340, 0000,
      0017, 0300, 0000, 0000, 0000, 0000, 0017, 0360, 0000, 0001,
      0376, 0077, 0000, 0000, 0000, 0017, 0300, 0007, 0340, 0077,
      0200, 0000, 0001, 0370, 0000, 0000, 0370, 0003, 0360, 0000,
      0037, 0200, 0000, 0000, 0037, 0300, 0037, 0360, 0007, 0360,
      0000, 0000, 0000, 0000, 0000, 0003, 0360, 0000, 0000, 0000,
      0007, 0300, 0007, 0300, 0000, 0017, 0203, 0340, 0000, 0007,
      0300, 0000, 0000, 0000, 0000, 0017, 0360, 0000, 0001, 0376,
      0077, 0000, 0000, 0014, 0017, 0300, 0007, 0340, 0037, 0200,
      0000, 0001, 0374, 0000, 0001, 0370, 0003, 0360, 0000, 0037,
      0200, 0000, 0006, 0017, 0340, 0000, 0000, 0007, 0360, 0000,
      0000, 0000, 0000, 0000, 0003, 0360, 0000, 0000, 0000, 0017,
      0200, 0007, 0300, 0000, 0017, 0203, 0340, 0000, 0007, 0300,
      0000, 0000, 0000, 0000, 0017, 0360, 0000, 0001, 0376, 0077,
      0200, 0000, 0010, 0017, 0300, 0007, 0340, 0037, 0300, 0000,
      0031, 0374, 0000, 0001, 0370, 0003, 0360, 0000, 0037, 0300,
      0000, 0004, 0017, 0340, 0000, 0000, 0017, 0340, 0000, 0000,
      0000, 0000, 0000, 0003, 0360, 0000, 0000, 0000, 0037, 0200,
      0007, 0300, 0000, 0017, 0203, 0340, 0000, 0007, 0300, 0000,
      0000, 0000, 0000, 0017, 0360, 0000, 0001, 0374, 0077, 0200,
      0000, 0030, 0017, 0300, 0007, 0340, 0037, 0300, 0000, 0060,
      0374, 0000, 0001, 0360, 0003, 0360, 0000, 0037, 0300, 0000,
      0014, 0007, 0360, 0000, 0000, 0017, 0300, 0000, 0000, 0000,
      0000, 0000, 0003, 0360, 0000, 0000, 0000, 0037, 0000, 0007,
      0300, 0000, 0017, 0003, 0340, 0000, 0007, 0200, 0000, 0000,
      0000, 0000, 0017, 0360, 0000, 0003, 0374, 0037, 0300, 0000,
      0060, 0017, 0300, 0007, 0340, 0017, 0340, 0000, 0160, 0376,
      0000, 0001, 0360, 0003, 0360, 0000, 0017, 0340, 0000, 0030,
      0003, 0370, 0000, 0000, 0037, 0200, 0000, 0000, 0000, 0000,
      0000, 0003, 0360, 0000, 0000, 0000, 0076, 0000, 0007, 0300,
      0000, 0017, 0003, 0340, 0000, 0007, 0200, 0000, 0000, 0000,
      0000, 0017, 0360, 0000, 0007, 0370, 0037, 0340, 0000, 0140,
      0017, 0300, 0007, 0340, 0017, 0360, 0000, 0340, 0176, 0000,
      0003, 0340, 0003, 0360, 0000, 0017, 0360, 0000, 0060, 0001,
      0374, 0000, 0000, 0077, 0000, 0000, 0000, 0000, 0000, 0000,
      0003, 0360, 0000, 0000, 0000, 0174, 0000, 0003, 0340, 0000,
      0036, 0001, 0360, 0000, 0017, 0000, 0000, 0000, 0000, 0000,
      0017, 0360, 0000, 0017, 0370, 0017, 0370, 0001, 0340, 0017,
      0300, 0007, 0340, 0007, 0370, 0001, 0300, 0177, 0000, 0003,
      0300, 0003, 0360, 0000, 0007, 0374, 0000, 0360, 0000, 0376,
      0000, 0000, 0176, 0000, 0000, 0000, 0000, 0000, 0000, 0003,
      0360, 0000, 0000, 0001, 0370, 0000, 0003, 0340, 0000, 0036,
      0001, 0360, 0000, 0017, 0000, 0000, 0000, 0000, 0000, 0017,
      0360, 0000, 0037, 0360, 0007, 0377, 0007, 0300, 0017, 0300,
      0007, 0340, 0007, 0377, 0017, 0200, 0077, 0200, 0007, 0200,
      0003, 0360, 0000, 0003, 0377, 0203, 0340, 0000, 0077, 0000,
      0001, 0374, 0000, 0000, 0000, 0000, 0000, 0000, 0003, 0370,
      0000, 0000, 0003, 0340, 0000, 0001, 0360, 0000, 0074, 0000,
      0370, 0000, 0036, 0000, 0000, 0000, 0000, 0000, 0017, 0360,
      0000, 0177, 0300, 0007, 0377, 0377, 0200, 0017, 0300, 0007,
      0340, 0003, 0377, 0377, 0000, 0037, 0300, 0017, 0000, 0007,
      0360, 0000, 0003, 0377, 0377, 0300, 0000, 0037, 0300, 0007,
      0360, 0000, 0000, 0000, 0000, 0000, 0000, 0007, 0370, 0000,
      0000, 0017, 0300, 0000, 0000, 0370, 0000, 0170, 0000, 0174,
      0000, 0074, 0000, 0000, 0000, 0000, 0000, 0037, 0376, 0017,
      0377, 0200, 0003, 0377, 0377, 0000, 0017, 0340, 0007, 0360,
      0001, 0377, 0376, 0000, 0007, 0340, 0036, 0000, 0007, 0370,
      0000, 0001, 0377, 0377, 0200, 0000, 0007, 0377, 0377, 0300,
      0000, 0000, 0000, 0000, 0000, 0000, 0077, 0377, 0360, 0000,
      0077, 0000, 0000, 0000, 0174, 0000, 0360, 0000, 0076, 0000,
      0170, 0000, 0000, 0000, 0000, 0001, 0377, 0377, 0377, 0374,
      0000, 0000, 0377, 0376, 0000, 0077, 0360, 0037, 0370, 0000,
      0177, 0374, 0000, 0003, 0374, 0370, 0000, 0037, 0374, 0000,
      0000, 0177, 0377, 0000, 0000, 0000, 0377, 0377, 0000, 0000,
      0000, 0000, 0000, 0000, 0003, 0377, 0377, 0360, 0003, 0370,
      0000, 0000, 0000, 0077, 0003, 0300, 0000, 0037, 0201, 0340,
      0000, 0000, 0000, 0000, 0007, 0377, 0377, 0377, 0340, 0000,
      0000, 0077, 0370, 0001, 0377, 0376, 0377, 0377, 0000, 0077,
      0360, 0000, 0000, 0377, 0340, 0000, 0177, 0377, 0200, 0000,
      0037, 0374, 0000, 0000, 0000, 0017, 0340, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0007, 0300, 0000,
      0000, 0000, 0007, 0377, 0200, 0000, 0003, 0377, 0300, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0007, 0300, 0000, 0000, 0000, 0000, 0000, 0000, 0003, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0003,
      0340, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0100, 0000, 0000, 0000, 0040, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0017, 0340, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0017, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0140, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0007,
      0270, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0003, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0140, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0007, 0034,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0007, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0140, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0006, 0034, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0006, 0000, 0000, 0000, 0000, 0001, 0200, 0000, 0000, 0000,
      0000, 0000, 0000, 0030, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0016, 0034, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0006,
      0000, 0000, 0000, 0000, 0003, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0060, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0016, 0034, 0167, 0007, 0207,
      0303, 0340, 0000, 0016, 0216, 0163, 0214, 0000, 0006, 0360,
      0171, 0306, 0000, 0017, 0303, 0300, 0000, 0017, 0003, 0303,
      0234, 0375, 0307, 0070, 0343, 0003, 0300, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0016, 0070, 0177, 0015, 0204, 0102,
      0040, 0000, 0061, 0216, 0361, 0216, 0000, 0014, 0140, 0330,
      0307, 0000, 0003, 0014, 0140, 0000, 0063, 0214, 0143, 0274,
      0060, 0307, 0170, 0343, 0006, 0300, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0017, 0360, 0152, 0031, 0214, 0106, 0040,
      0000, 0141, 0215, 0061, 0304, 0000, 0014, 0301, 0230, 0342,
      0000, 0006, 0034, 0160, 0000, 0143, 0234, 0163, 0114, 0141,
      0306, 0230, 0303, 0014, 0300, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0034, 0000, 0160, 0063, 0216, 0007, 0000, 0000,
      0141, 0216, 0060, 0304, 0000, 0015, 0003, 0070, 0142, 0000,
      0006, 0030, 0160, 0000, 0340, 0030, 0163, 0214, 0141, 0207,
      0030, 0307, 0031, 0300, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0034, 0000, 0140, 0167, 0007, 0003, 0200, 0000, 0303,
      0016, 0140, 0304, 0000, 0017, 0007, 0160, 0142, 0000, 0006,
      0060, 0140, 0000, 0300, 0060, 0143, 0230, 0141, 0207, 0060,
      0306, 0073, 0200, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0030, 0000, 0140, 0170, 0003, 0001, 0200, 0000, 0303, 0034,
      0140, 0310, 0000, 0037, 0007, 0200, 0144, 0000, 0006, 0060,
      0140, 0000, 0300, 0060, 0147, 0030, 0141, 0216, 0061, 0316,
      0074, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0070,
      0000, 0340, 0140, 0003, 0201, 0300, 0001, 0307, 0034, 0140,
      0150, 0000, 0033, 0006, 0000, 0064, 0000, 0014, 0160, 0340,
      0000, 0300, 0160, 0347, 0030, 0303, 0016, 0061, 0216, 0060,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0070, 0000,
      0300, 0140, 0061, 0230, 0300, 0001, 0207, 0130, 0150, 0160,
      0000, 0031, 0206, 0000, 0070, 0000, 0015, 0160, 0300, 0000,
      0300, 0160, 0306, 0032, 0323, 0014, 0065, 0236, 0260, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0070, 0000, 0300,
      0143, 0061, 0230, 0300, 0001, 0316, 0230, 0320, 0160, 0000,
      0071, 0246, 0060, 0070, 0000, 0015, 0061, 0200, 0000, 0302,
      0061, 0206, 0064, 0323, 0114, 0151, 0255, 0061, 0200, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0374, 0001, 0300, 0176,
      0073, 0035, 0200, 0000, 0367, 0060, 0340, 0140, 0000, 0060,
      0347, 0340, 0060, 0000, 0016, 0073, 0000, 0000, 0374, 0073,
      0014, 0070, 0343, 0230, 0161, 0316, 0077, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0100, 0000, 0000, 0000,
      0000, 0040, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0300, 0000, 0000, 0000, 0000,
      0140, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0001, 0200, 0000, 0000, 0000, 0000, 0300,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0017, 0000, 0000, 0000, 0000, 0007, 0200, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0016, 0000, 0000, 0000, 0000, 0007, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 
  };
  bit_static(cr, 472, 83, cr_data, 1, 0);
  BITMAP *notice = &cr;
  BITMAP *ball = &ball_1;
    

  /* find w/o claiming the colors we want on the startup screen */
  r = 255; g = 180; b = 60; maxi = 255; /* sun yellow */
  findcolor(where, &ind, &r, &g, &b, &maxi);
  mr->color_map[LOGO_COLOR] = ind;

  if( at_startup) {
    r = 0; g = 16; b = 64; maxi = 255; /* deep blue */
  } else {
    r = 0; g =  0; b =  0; maxi = 255; /* black for screen saving */
  }
  findcolor(where, &ind, &r, &g, &b, &maxi);
  mr->color_map[LOGO_COLOR_BG] = ind;

  r = 255; g = 108; b = 0; maxi = 255; /* orange */
  findcolor(where, &ind, &r, &g, &b, &maxi);
  mr->color_map[CR_COLOR] = ind;

  r = 0; g = 255; b = 0; maxi = 255;  /* unused green? */
  findcolor(where, &ind, &r, &g, &b, &maxi);
  mr->color_map[CR_COLOR_BG] = ind;

  /* clear display */
        
  bit_blit(where,0,0,BIT_WIDE(where),BIT_HIGH(where),
	   BUILDOP(BIT_CLR,mr->color_map[LOGO_COLOR],
		   mr->color_map[LOGO_COLOR_BG]),
	   (BITMAP*)0,0,0);

  if( at_startup) {
    /* get the cr notice hole */

    clip1.x1 = (BIT_WIDE(where)-BIT_WIDE(notice))/2 - SSIZE;
    clip1.y1 = (3*BIT_HIGH(where)-2*BIT_HIGH(notice))/4 - SSIZE;
    clip1.x2 = clip1.x1 + SSIZE + BIT_WIDE(notice);
    clip1.y2 = clip1.y1 + SSIZE + BIT_HIGH(notice);

    bit_blit(where,clip1.x1+SSIZE,clip1.y1+SSIZE,
	     BIT_WIDE(notice),BIT_HIGH(notice),
	     BUILDOP(BIT_SRC,mr->color_map[CR_COLOR],
		     mr->color_map[LOGO_COLOR_BG]),
	     notice,0,0);

    /* get the globe hole */

    clip2.x1 = (BIT_WIDE(where)-BIT_WIDE(ball))/2-SSIZE;
    clip2.y1 = (BIT_HIGH(where)-2*BIT_HIGH(ball))/4-SSIZE;
    clip2.x2 = clip2.x1 + SSIZE + BIT_WIDE(ball);
    clip2.y2 = clip2.y1 + SSIZE + BIT_HIGH(ball);

#ifdef MESSAGE
    /* get the message hole */

    clip3.x1 = 10 - SSIZE;
    clip3.y1 = BIT_HIGH(where) - font->head.high - 10 - SSIZE;
    clip3.x2 = 10 + 2*SSIZE + strlen(MESSAGE) * font->head.wide;
    clip3.y2 = BIT_HIGH(where) - 10 + 2*SSIZE;
    put_str(where,10,clip3.y2-SSIZE,font,BIT_SRC,MESSAGE);
#else
    clip3 = clip2;
#endif
  } else {
    /* no messages during screen lock, just stars */
    clip1.x1 = clip1.x2 = clip1.y1 = clip1.y2 = 0;
    clip2 = clip1;
    clip3 = clip1;
  }

  fly(mr, where);
  for (i = 0; i < 30; ++i) {
    dofly(mr, where);

    bit_blit(where,clip2.x1+SSIZE,clip2.y1+SSIZE,
	     BIT_WIDE(ball),BIT_HIGH(ball),
	     BUILDOP(BIT_SRC,mr->color_map[LOGO_COLOR],
		     mr->color_map[LOGO_COLOR_BG]),
	     ball,0,0);
#ifdef OSKIT
    usleep(1*1000);
#else
    usleep(100*1000);
#endif
  }
}
/*}}}  */
