/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: border.c,v $
 *
 * HISTORY
 * $\Log: border.c,v $
 * Revision 1.5  1998/01/31 18:43:03  mjk
 * replaced copyright
 *
 * Revision 1.4  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.3  1997/12/12 17:53:39  acb
 * Don't hardcode border color
 *
 * Revision 1.2  1997/06/09 22:01:57  acb
 * Added title bar to border.
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/04/09 21:33:31  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 *
 * Revision 1.4  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.3  1996/11/18 18:54:47  bradym
 * Added traceLevelMGR
 *
 * Revision 1.2  1996/11/18 00:21:04  bradym
 * Check if bdr == NULL in border(). This should never happen though -
 * this is just a quick hack to make things word for demo.
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */


/*
 * draw the border around this window.             broman@nosc.mil, 1996/03
 */
#include <bitblit.h>
#include <oskit/wimpi.h>
#include <font.h>
#include <font_subs.h>
#include <clip.h>
#include <defs.h>
#include <border.h>
#include <subs.h>
#include <update.h>

#include <wimp_internal.h>

extern int traceLevelMGR;

#define ONE_BOX( bm, x, y, w, h, b, op)                                   \
/* top, right, bottom, left */                                            \
bit_blit(bm, (x),         (y),         (w), (b),         (op), 0, 0, 0); \
bit_blit(bm, (x)+(w)-(b), (y)+(b),     (b), (h)-(b)-(b), (op), 0, 0, 0); \
bit_blit(bm, (x),         (y)+(h)-(b), (w), (b),         (op), 0, 0, 0); \
bit_blit(bm, (x),         (y)+(b),     (b), (h)-(b)-(b), (op), 0, 0, 0);

void border_title (WINDOW *win, BITMAP *map, char *title) 
{
    wimpiSession mr = win->wimpi->session;
    int bwid = win->borderwid;
    int fsizewide, fsizehigh, off, length, op = 0, i, x, y;
    int bkg = mr->color_map[TITLE_COLOR_BG];   /* bluish color */

    fsizehigh = win->font->head.high;
    fsizewide = win->font->head.wide;
    length = strlen(title);

    x = bwid;
    y = bwid;

    /* wimp_pre_blit (win, x, y, x + fsizewide * length, y + fsizehigh); */

    op = BIT_SRC;
    op = PUTFCOLOR (op, 0xff);   /* white */
    op = PUTBCOLOR (op, bkg);    

    for (i = 0, off = x; i < length; i++) {
	bit_blit(map, off, y, fsizewide, fsizehigh,
                 op, win->font->glyph[*title], 0, 0);
	title++;
	off += fsizewide;
    }

    bit_blit(map, off, y, map->wide - off - bwid, 
	     fsizehigh, BUILDOP(0,0,bkg), 0, 0, 0);

    /* 
    if (!(win->flags & W_ACTIVE)) {
        if (Do_clip())
        {
            Set_clipall();
            Set_cliplow (x, y);
            Set_cliphigh (x + win->window->wide, y+fsizehigh);
        }
        update(mr, win, &clip); 
    }
    */

    /* 
     * cursor_on(mr);
     * MOUSE_ON(mr, mr->screen, mr->mousex, mr->mousey);
     */

}

void border( WINDOW *win, int be_fat)
{
    BITMAP *bdr = (W(flags)&W_ACTIVE)? W(border): W(save);

    if (!win->has_border) return;

    border_in_bitmap (win, bdr, be_fat);
}


void border_in_bitmap (WINDOW *win, BITMAP *bdr, int be_fat)
{
    int both = win->borderwid;
    /* int out = (be_fat==BORDER_FAT)? both - 1: win->outborderwid; */
    int out = win->outborderwid; 
    int inr = both - out;

    int clr = PUTOP(BIT_CLR,W(style));
    int set = BUILDOP(0, 0, 0xff); /* white */
    int w = BIT_WIDE(bdr);
    int h = BIT_HIGH(bdr);

    if( both <= 0)  return;

    ONE_BOX( bdr, 0,   0,   w,         h,         out, set);
    ONE_BOX( bdr, out, out, w-out-out, h-out-out, inr, clr);
    border_title (win, bdr, win->title);
}





