/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
#include <defs.h>

#include <string.h>

winmap* winmapCreate(int size)
{
  winmap* map;

  map=(winmap*)malloc(sizeof(winmap));
  map->size=size;
  map->hash=(winmap_e**)malloc(sizeof(winmap_e*)*size);

  memset(map->hash,NULL,size);
  
  return map;
}

int winmapDelete(winmap* m)
{
  int i;
  winmap_e *e,*f;
  
  for (i=0;i<m->size;++i) {
    e=m->hash[i];
    while (e) {
      f=e->next;
      free(e);
      e=f;
    }
  }
  
  free(m->hash);
  
  free(m);
  
  return WME_OK;
}

int winmapBind(winmap* m,int key,WINDOW* value)
{
  winmap_e *n,*c;

  if (m == NULL || m->hash == NULL) return WME_BADMAP;
  
  n=(winmap_e*)malloc(sizeof(winmap_e));
  n->key=key;
  n->value=value;
  n->next=NULL;
  
  if (m->hash[key%m->size] == NULL) {
    m->hash[key%m->size]=n;
  } else {
    for (c=m->hash[key%m->size];c->next;c=c->next)
      if (c->key == key) {
	free(n);
	return WME_DUPENTRY;
      }
    c->next=n;
  }

  return key;
}

int winmapUnbind(winmap* m,int key)
{
  winmap_e *c,*p;

  if (m == NULL || m->hash == NULL) return WME_BADMAP;

  if (m->hash[key%m->size] == NULL) return WME_NOMATCH;

  p=NULL;
  for (c=m->hash[key%m->size];c;c=c->next) {
    if (c->key == key) {
      if (p == NULL) {
	m->hash[key%m->size]=c->next;
      } else {
	p->next=c->next;
      }
      return WME_OK;
    }
    p=c;
  }

  return WME_NOMATCH;
}

int winmapResolve(winmap* m,int key,WINDOW** value) {
  winmap_e *c;

  if (m == NULL || m->hash == NULL) return WME_BADMAP;

  if (m->hash[key%m->size] == NULL) return WME_NOMATCH;

  for (c=m->hash[key%m->size];c && c->key != key;c=c->next);

  if (c) {
    *value = c->value;
    return WME_OK;
  } else {
    return WME_NOMATCH;
  }
}

void winmapWalkInit(winmap_walk *w,winmap* m)
{
  w->m = m;
  w->curi = 0;
  w->curh = NULL;
}

void winmapWalkDone(winmap_walk* w)
{
  w->m = NULL;
}

WINDOW* winmapWalkNext(winmap_walk* w)
{
  int i;
  
  if (w->m == NULL) return NULL;
  
  if (w->curh) {
    if (w->curh->next) {
      w->curh=w->curh->next;
      return w->curh->value;
    } else {
      w->curi++;
    }
  } 

  for (i=w->curi;!w->m->hash[i] && i<w->m->size;++i);

  if (i == w->m->size)
    return NULL;

  w->curh=w->m->hash[i];
  w->curi=i;

  return w->curh->value;
}

  
    
   
