/*
 * Copyright (c) 1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
#include <oskit/wimpi.h>
#include <put_window.h>

void wimpi_put_str(wimpiToplevelWindow w,char *str,int len)
{
  put_window(w->session,w->win,str,len);
}

void
wimpi_bitcreate (wimpiToplevelWindow w, int depth)
     /* semantics diff from the mgr manual ,
      * here we create the bitmap in the window to use
      * as the bitmap to be downloaded to the framebuf
      */
{
  WINDOW *win = w->win;

  if (win->bitmap != (BITMAP *)0) {
    bit_destroy (win->bitmap);
  }

  win->bitmap = bit_alloc (win->window->wide, 
			   win->window->high,
			   (DATA *)0, depth);
  /* we use ring buffer mem for display, so don't need this */
  free (win->bitmap->data);

  return;
}
