/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: wimpi.c,v $
 *
 * HISTORY
 * $\Log: wimpi.c,v $
 * Revision 1.12  1998/01/31 18:43:17  mjk
 * replaced copyright
 *
 * Revision 1.11  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.10  1997/12/17 20:05:43  acb
 * Fixed bug with screen snapshot, added ctl-op.
 *
 * Revision 1.9  1997/12/17 17:03:59  acb
 * Changed wimp_ctl to pass on ctl ops.
 *
 * Revision 1.8  1997/12/11 20:14:12  acb
 * Changed keymap of ENTER key from 0xa to '\r'
 *
 * Revision 1.7  1997/12/11 16:45:18  mjk
 * Support MPEG extended paths
 *
 * Revision 1.6  1997/12/10 23:21:02  acb
 * Menus customized based on routers in configuration.
 *
 * Revision 1.5  1997/08/28 18:24:59  acb
 * Fixed bug with path deletion.
 *
 * Revision 1.4  1997/08/27 18:00:58  acb
 * Removed some redundant functions from interface; all interface functions
 * now require a winId argument.
 *
 * Revision 1.3  1997/06/09 22:42:52  acb
 * Removed superfluous subwindow creation from wimp_put_bitmap(),
 * added code for title bar.
 *
 * Revision 1.2  1997/05/12 19:59:26  bradym
 * Added traceLogs and changed trace variable from MGR to WIMP.
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * *** WIMP born here ***
 *
 * Revision 1.12  1997/02/04 23:08:27  davidm
 * (mgr_init): Turn of obsolete TGA path creation.
 * (mgrCreate): Don't insist on there being a link to the MGR service, but
 * do require exactly one link to KBD and MOUSE.
 *
 * Revision 1.11  1997/02/03 19:05:47  davidm
 * (mgr_init): Remove 3sec pause after copyright() (it's part of the
 * copyright() loop now).
 *
 * Revision 1.10  1997/01/14 19:02:07  acb
 * Clipping works now
 *
 * Revision 1.9  1997/01/14 18:20:33  bradym
 * Added PathQueue structure to stage.
 * Keep the numInserted and numRemoved fields up to date and set it to the
 * sink queue of the path.
 *
 * Revision 1.8  1997/01/07  15:54:11  acb
 * Added MGR terminal emulation, fleshed out translation of keyboard
 * events to ASCII chars.
 *
 * Revision 1.7  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.6  1996/11/18 20:32:59  bradym
 * make mgr_create_stage() return NULL if init_window() fails
 *
 * Revision 1.5  1996/11/17 23:52:03  bradym
 * Added assert() to draw_win()
 *
 * Revision 1.4  1996/11/12 22:58:26  abhiram
 * Made changes to get attributes properly in mgr_create_stage
 *
 * Revision 1.3  1996/11/04  19:41:31  bradym
 * Merged Window and Stage structs
 *
 * Revision 1.2  1996/10/23 05:03:45  abhiram
 * heapFree data of window.bitmap in bitcreate
 *
 * Revision 1.1  1996/09/29 06:47:36  abhiram
 * Initial revision
 *
 */

#include <stdlib.h>
#include <string.h>

#include <oskit/wimpi.h>

#include <icon_server.h>
#include <new_window.h>
#include <wimp_internal.h>
#include <do_button.h>
#include <shape.h>
#include <cut.h>
#include <device.h>
#include <clip.h>
#include <wimp_wintree.h>
#include <code_to_ascii.h>

#ifdef SVGALIB
#include <oskit/svgalib/vga.h>
#endif

#define WIMPI_TABLE_SIZE 16

extern int mouse_get(struct ms_event *ms_ev, int *x_delta, int *y_delta);
extern void init_colors(BITMAP *bp);
extern void fill_colormap(wimpiSession mr,BITMAP *bp);
extern void erase_win(wimpiSession mr, BITMAP *map);
extern void copyright(wimpiSession mr, BITMAP *where, char *password);

rect clip;

int wimpi_ext_palette = 0;

static int proc_mouse(wimpiSession mr);

static void
send_multichar_event (wimpiSession mr, char *send) {
  int i;
  wimpiEvent event;
  
  for (i = 0; i < strlen(send); i++) {
    event = (wimpiEvent)malloc(sizeof(struct wimpiEvent));
    if (event == NULL) {
      /*
	 XXX
      traceLog (WIMP, TR_ERRORS, 
		"get_kbd_event: heapAlloc failed");
		*/
    }
    event->type = KEYPRESS_EVENT;
    event->winId = mr->active->winId;
    event->event.keyEvent.the_char = send[i];
    wimpiEventDeliver (mr->active->wimpi,
		     event);
  }
}

long
wimpi_mouse_input(wimpiSession session,char butstate,int dx,int dy)
{
  session->ms_ev.ev_butstate=butstate;
  session->ms_ev.ev_dx=dx;
  session->ms_ev.ev_dy=dy;
  return proc_mouse(session);
}

static int
proc_mouse(wimpiSession mr)
{
  int dx, dy;
  BITMAP *screen = mr->screen;
  WINDOW *win;
  register int button, done = 0;

  /* If mouse is in a menu, and we get to here, that means the 
   * thread responsible for handling menu events has been awakened
   * but has not run yet.  Ignore the event in this case.
   */
  if (mr->mouse_state == MOUSE_FREE) {      
    button = mouse_get(&mr->ms_ev,&dx,&dy);
    MOUSE_OFF(mr,screen,mr->mousex,mr->mousey); 
    mr->mousex += 2*dx;
    mr->mousey -= 2*dy;
    mr->mousex = BETWEEN(0,mr->mousex,BIT_WIDE(screen)-1);
    mr->mousey = BETWEEN(0,mr->mousey,BIT_HIGH(screen)-1);
    win = (WINDOW*)wimpi_window_under_mouse(mr);
    if ((dx || dy) && win) {
	      wimpi_send_mouse_event (win, MOUSE_MOVE_EVENT, button);
    }
    if (button != mr->button_state) {
      if (win) {
	wimpi_send_mouse_event (win, (button ? BUTTON_DOWN_EVENT : 
				      BUTTON_UP_EVENT), button);
      }
      do_button(mr, button, screen);
      done++;
    }
    MOUSE_ON(mr,screen,mr->mousex,mr->mousey); 
  }
  return(done);
}


wimpiEventHandler
wimpi_set_event_handler(wimpiSession session, wimpiEventHandler proc)
{
  wimpiEventHandler old = session->handle_event;

  session->handle_event = proc;

  return old;
}

void
wimpi_kbd_input(wimpiSession session, unsigned char c)
{
  unsigned char as_char;
#if 0
  size_t count;
  int i;
#endif
  wimpiToplevelWindow cur_win=NULL;
  unsigned int mod_state;
  wimpiEvent event;

  if (session->active)
    cur_win=session->active->wimpi;
  /*
     XXX
  traceLog (WIMP, TR_EVENTS, "get_kdb_event");
  */
  
  if (!cur_win) {
    /*
       XXX
      traceLog (WIMP, TR_EVENTS, "active window doesn't want events");
      */
      return;
  }
  mod_state = cur_win->mod_key_state;

  /*
     XXX
  traceLog (WIMP, TR_DETAILED, "code: 0x%x", c);
  */
  as_char = code_to_ascii[c][mod_state & 0x3];
  
  if (c < 0x80 && as_char) { 
    /* Then it's a key press */
    switch (as_char) {
    case LSHIFT:
    case RSHIFT:
      cur_win->mod_key_state |= MODIFIER_SHIFT;
      /*
	 XXX
      traceLog (WIMP, TR_DETAILED, "shift down");
      */
      break;
      
    case LCONTROL:
    case RCONTROL:
      cur_win->mod_key_state |= MODIFIER_CONTROL;
      /*
	 XXX
      traceLog (WIMP, TR_DETAILED, "control down");
      */
      break;
      
    case CURSOR_UP:
      send_multichar_event (session, "\E[A");
      break;
      
    case CURSOR_LEFT:
      send_multichar_event (session, "\E[D");
      break;
      
    case CURSOR_RIGHT:
      send_multichar_event (session, "\E[C");
      break;
      
    case CURSOR_DOWN:
      send_multichar_event (session, "\E[B");
      break;
      
    case ALT:
      cur_win->mod_key_state |= MODIFIER_ALT;
      /*
	 XXX
      traceLog (WIMP, TR_DETAILED, "alt down");
      */
      break;
      
    default:
      if (as_char < 0x80) {
	if (cur_win->mod_key_state 
	    & MODIFIER_ALT) 
	  {
	    as_char += 0x80;
	  }
	/*
	   XXX
	traceLog (WIMP, TR_DETAILED, "char: %c", as_char);
	*/
	event = (wimpiEvent)calloc(1, sizeof (struct wimpiEvent));
	if (event == NULL) {
	  /*
	     XXX
	  traceLog (WIMP, TR_ERRORS, 
		    "get_kbd_event: heapAlloc failed");
		    */
	  return;
	}
	event->type = KEYPRESS_EVENT;
	if (cur_win->win)
	  event->winId = cur_win->win->winId;
	else
	  event->winId = 0;
	event->event.keyEvent.the_char = as_char;
	wimpiEventDeliver (cur_win, 
			 event);
      }
    }
  }
  else {
    if (as_char == LSHIFT || as_char == RSHIFT) {
      cur_win->mod_key_state &= ~MODIFIER_SHIFT;
      /*
	 XXX
      traceLog (WIMP, TR_DETAILED, "shift_up");
      */
    }
    else if (as_char == LCONTROL || as_char == RCONTROL) {
      cur_win->mod_key_state &= ~MODIFIER_CONTROL;
      /*
	 XXX
      traceLog (WIMP, TR_DETAILED, "control");
      */
    }	
    else if (as_char == ALT) {
      cur_win->mod_key_state &= ~MODIFIER_ALT;
      /*
	 XXX
      traceLog (WIMP, TR_DETAILED, "alt");
      */
    }	
    else if (as_char == CURSOR_KEY) {
      /* what to do here? */
      /* also right ALT generates this code */
    }
  }

  return;
}

void
wimpi_destroy_toplevel(wimpiToplevelWindow ww)
{
#if 0
  wimpiSession mr = ww->session;
  wimpiToplevelWindow curr, prev;
#endif
  WINDOW *win;
  struct winmap_walk w;

#if 0
  /* We dont' support timed images yet */
  if (ww->rb.size > 0) {
    wimpi_flush_timed_image_queue(&ww->mgr.i, MY_WINDOW);
    
    /* first, unlink stage from display list if it's on there: */
    prev = 0;
    for (curr = mr->display_list; curr; prev = curr, curr = curr->next_stage) {
      if (curr == ww) {
	if (prev) {
	  prev->next_stage = curr->next_stage;
	} else {
	  mr->display_list = curr->next_stage;
	}
	break;
      }
    }
    
    /* now free memory that has been allocated in resize_image: */
    free(ww->rb.img);
  }
#endif

  if (!ww->window_map) {
      /* Single-window path */
      if (ww->win) {
	if (!ROOT_WIN (ww->win->parent)) {
	  /* wimpi_make_child_window() was used */
	  wimpi_remove_sibling(ww->win);
	}
	wimp_internal_destroy_window(ww->win);
      }
  } else {
      /* Multi-window path */
      winmapWalkInit (&w, ww->window_map);
      do {
	  win = winmapWalkNext(&w);
	  if (win)
	    if (win->wimpi == ww)
	      wimp_internal_destroy_window (win);
      } while (win);
      winmapWalkDone (&w);
      
      winmapDelete (ww->window_map);
  }
  
  return;  
}

static void
handle_display (AnyType arg1, AnyType arg2)
{
  /* we don't support timed images yet */
#if 0
  wimpiSession mr = arg1.p;
  u_long now = arg2.ul;
  wimpiToplevelWindow ms;

  for (ms = mr->display_list; ms; ms = ms->next_stage) {
    WinMgrTimedImage image, next_image;
    unsigned rd = ms->rb.rd;
    
    image = ms->rb.img[rd];
    if (image->owner == OWNER_MGR &&
	(long) (now - image->showtime) >= 0)
      {
	Thread t;
	
	/* since we're freeing at least one image, wakeup sleeper: */
	t = ms->rb.blocked_thread;
	if (t) {
	  ms->rb.blocked_thread = 0;
	  threadAsyncWakeup(t);
	}
	/*
	 * Now find and display the latest permissible image
	 * in the buffer:
	 */
	while (1) {
	  image->owner = OWNER_NOBODY;
	  if (++rd >= ms->rb.size) {
	    rd = 0;
	  }
          ms->rb.q.numRemoved++;
	  ms->rb.rd = rd;
	  next_image = ms->rb.img[rd];
	  if (next_image->owner == OWNER_MGR &&
	      (long) (now - next_image->showtime) >= 0)
	    {
	      image = next_image;
	      continue;
	    }
	  /*
	  tga_put_image_pb8(&mr->r, (__u32 *) image->data,
			    (__u32 *) ms->window.vmem_base,
			    ms->window.width, ms->window.height);
			    */
	  wimpi_put_bitmap (&ms->mgr.i, image->data, 8);
	  break;
	}
      }
  }
#endif
  
}

static void
wimpi_menu_snapshot (wimpiSession mr)
{
  /* XXX: need to depath this */
#if 0
  Router r;

  r = routerLookupByName("screendump");
  
  if (r)
    r->ctl(r, SCREENDUMPCTL_GO, 0, 0); 
#endif
}

static void 
nothing (wimpiSession mr)
{
    /* A null menu function */
}

static void
wimpi_menu_destroy_window (wimpiSession mr) 
{
  wimpi_send_destroy_event (mr->active);
  wimp_internal_destroy_window (mr->active);
}

static void
wimpi_fill_main_menu (char ***menu, wfunction **fn) 
{
    int i = 0;
#ifdef SCOUT
    Router r;
#endif

#define MENU_MAX 5

    *menu = (char **)malloc (sizeof(char *) * MENU_MAX);
    *fn = (wfunction *)malloc (sizeof(wfunction) * MENU_MAX);

#ifdef SCOUT
    r = routerLookupByName("rlogin");
    if (r) {
	(*menu)[i] = "rlogin window";
	(*fn)[i++] = rlogin_window;
    }

    r = routerLookupByName("screendump");
    if (r) {
	(*menu)[i] = "take snapshot";
	(*fn)[i++] = wimp_menu_snapshot;
    }
#endif

    (*menu)[i] = "redraw";
    (*fn)[i++] = redraw;

    (*menu)[i] = "quit";
    (*fn)[i++] = quit;

    (*menu)[i] = (char *) 0;
    (*fn)[i] = (wfunction) 0;
}    

static void
wimpi_create_menus (wimpiSession mr) 
{
    static char *active_menu[] = {	  /* active-window menu */
#ifdef STRETCH 
	"move",
	"stretch",
#else
	"move",
	"reshape",
#endif
	"cut",
	"paste",
	"bury",
	"- - - -",
	"destroy",
	(char *) 0};

#if 0
    static char *main_menu[] = {	  /* primary menu */
	"rlogin window",
	"redraw",
	"take snapshot",
	"quit",
	(char *) 0};
#else
    static char **main_menu;
    static wfunction *main_functions;
#endif
    
    static char *full_menu[] = {	  /* primary menu  - no more windows allowed */
	"redraw",
	"quit",
	(char *) 0};
    
    static char *quit_menu[] = {	  /* to verify quit */
	"cancel",
	"lock screen",
	"suspend",
	"- - - -",
	"really quit",
	(char *) 0};
    
/* menu functions - these have a 1-1 correspondance with the menu items */

#if 0
    static wfunction main_functions[] = {
	rlogin_window,
	redraw,
	wimpi_menu_snapshot,
	quit,
	(wfunction) 0,
    };
#endif
    
    static wfunction full_functions[] = {
	(wfunction) 0,
	(wfunction) 0,
	(wfunction) 0 };
    
    static wfunction active_functions[] = {
#ifdef STRETCH
	move_window,
	stretch_window,
#else
	move_window,
	shape_window,
#endif
	rubber_band_cut,
	paste,
	nothing,
	nothing,
	wimpi_menu_destroy_window,
	(wfunction) 0 };

    wimpi_fill_main_menu (&main_menu, &main_functions);
    
    mr->active_menu = active_menu;
    mr->full_menu = full_menu;
    mr->main_menu = main_menu;
    mr->quit_menu = quit_menu;
    mr->main_functions = main_functions;
    mr->full_functions = full_functions;
    mr->active_functions = active_functions;
}

wimpiSession
wimpi_initialize()
{
  wimpiSession new_session;
#if 0
  struct FrameBufCallback fcb;
#endif

#ifdef SVGALIB
  vga_modeinfo *pinfo;
  int mode;
#endif

  new_session=(wimpiSession)malloc(sizeof(struct wimpiSession));
  bzero(new_session, sizeof(*new_session));
  
  /* lots to do, take from wimp_init */
  /* get the default font */
  if (new_session->font == (struct font*) 0) 
    new_session->font = open_font(NULL);
  new_session->font->ident = 0;

#if 0
  /* set up call back */
  fcb.func = handle_display;
  fcb.arg1 = ptrToAny(new_session);
  fcb.arg2 = 0;
  DeviceRegCallback(&fcb);
#endif

#ifdef SVGALIB
  vga_init();
  
  mode = G640x480x256;

  if (!vga_hasmode(mode))
      panic("video card dosen't support video mode %s!\n",	
	    vga_getmodename(mode));

  if ((pinfo = vga_getmodeinfo(mode)) && pinfo->flags & CAPABLE_LINEAR) {

      vga_setmode(mode);

      if (vga_setlinearaddressing() < 0)
	  panic("can't set linear addressing mode!\n");

      if ((pinfo = vga_getmodeinfo(mode)) && !(pinfo->flags & IS_LINEAR))
	  panic("why isn't linear addressing mode set?\n");

      if (pinfo->flags & HAVE_EXT_SET) {
	  if (vga_ext_set(VGA_EXT_AVAILABLE, VGA_AVAIL_FLAGS) &
                VGA_CLUT8) {
                vga_ext_set(VGA_EXT_SET, VGA_CLUT8);
                wimpi_ext_palette = 1;
	  }	
      }

      /* Clear the colormap and set the fg color (vga_getcolors() - 1). */
      {
	  int i;

	  for (i = 1; i < vga_getcolors() - 1; i++)
	      vga_setpalette(i, 0, 0, 0);

	  if (wimpi_ext_palette)
	      vga_setpalette(vga_getcolors() - 1, 255, 255, 255);
	  else
	      vga_setpalette(vga_getcolors() - 1, 63, 63, 63);

      }
      
      new_session->screen = bit_open(vga_getgraphmem(), pinfo->width, 
				     pinfo->height,
				     (pinfo->bytesperpixel * 8), pinfo->width);

      printf("linear address is %x\n", vga_getgraphmem());

  } else
      panic("video card dosen't support linear addressing!\n");
#endif
      
  /* grab images */
  wimpi_get_images(new_session);
  
  /* fill colors */
  init_colors(new_session->screen);
  fill_colormap(new_session,new_session->screen);
  copyright(new_session,new_session->screen,"");
  erase_win(new_session,new_session->screen);
  
  /* init window stuff */
  new_session->next_window = 0;
  new_session->next_winId = 1;
  new_session->active = new_session->last_active = (WINDOW *) 0;
  new_session->root_win = (WINDOW*)malloc(sizeof(WINDOW));
  memset(new_session->root_win, 0, sizeof(WINDOW));
  new_session->root_win->wimpi = (wimpiToplevelWindow)malloc(sizeof(struct wimpiToplevelWindow));
  new_session->root_win->wimpi->session = new_session;
  new_session->root_win->wimpi->win = new_session->root_win;
    
  /* So we can get size of screen from BIT_WIDE(new_session->root_win), etc. */
  new_session->root_win->border = new_session->screen;   
  new_session->root_win->window = new_session->screen;
  new_session->root_win->is_visible = TRUE;

  /* mouse */
  new_session->mousex = 32;
  new_session->mousey = 32;
  new_session->mouse_save=bit_alloc(16,32,0,8);
  new_session->mouse_on = 0;
  new_session->button_state = 0;
  new_session->mouse_state = MOUSE_FREE;
  MOUSE_OFF(new_session,new_session->screen,new_session->mousex,new_session->mousey);
  SETMOUSEICON(new_session,DEFAULT_MOUSE_CURSOR(new_session));
  MOUSE_ON(new_session,new_session->screen,new_session->mousex,new_session->mousey);

  wimpi_create_menus(new_session);

  new_session->handle_event=NULL;
  
  return new_session;
}

wimpiToplevelWindow
wimpi_create_toplevel(wimpiSession session,bool multi,
		  int width,int height,
		  int x,int y,
		  char* title,
		  bool mapped,
		  void* data)
{
  WINDOW* win;
  
  wimpiToplevelWindow new_window;

  new_window=(wimpiToplevelWindow)malloc(sizeof(struct wimpiToplevelWindow));
  bzero(new_window, sizeof(*new_window));
  new_window->session=session;

  new_window->root=(wimpiWindow)malloc(sizeof(struct wimpiWindow));
  bzero(new_window->root, sizeof(*new_window->root));
  new_window->root->w=new_window;
  new_window->root->winId=0;
  
  if (multi != TRUE) {
    /* Single window */
    win=wimp_internal_create_window(session,new_window,NULL,x,y,width,height,TRUE);
    
    if ( ! win) {
      fprintf(stderr, "WIMP: Couldn't create a window \n");
      MOUSE_ON(session, session->screen, session->mousex, session->mousey); 
      return NULL;
    }
    
    new_window->win=win;
    
    wimp_internal_set_window_title(win,title);
    
    if (mapped == TRUE) {
      wimp_internal_map_window(win);
    }
    
    win->no_expose_events=TRUE;

    new_window->window_map = NULL;
  } else {
    /* multi window */
    new_window->window_map = winmapCreate(WIMPI_TABLE_SIZE);
    new_window->win = NULL;
  }

  new_window->data=data;
  return new_window;
}

long wimpiEventDeliver(wimpiToplevelWindow w,wimpiEvent e)
{
  if (w->session->handle_event != NULL) 
    return w->session->handle_event(w,e);

  return 0;
}

wimpiInputRoutine 
wimpi_set_input_routine(wimpiSession session, wimpiInputRoutine proc)
{
  wimpiInputRoutine old = session->input_routine;
  
  session->input_routine = proc;

  return old;
}

void 
wimpi_main_loop(wimpiSession session)
{
  wimpiInputEvent ievent;

  while (1) {
    if (session->input_routine(IMASK_MOUSE | IMASK_KEY,&ievent) != 0) {

      switch (ievent.type) {
      case IMASK_MOUSE:
	wimpi_mouse_input(session,ievent.event.mouseEvent.but_state,
			  ievent.event.mouseEvent.dx,
			  ievent.event.mouseEvent.dy);
	break;
      case IMASK_KEY:
	wimpi_kbd_input(session,ievent.event.kbdEvent.c);
	break;
      default:
	break;
      }
    }
  }
}
