/*
 * Copyright (c) 1994-1999 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include <sys/types.h>

#define NEEDBSDTYPES
#include "native.h"
#include "native_file.h"


/*
 * Set a file descriptor to non-blocking, async notify I/O. This is
 * here cause this file is compiled with /usr/include ahead of oskit
 * include. The calls to fcntl below need the right headers, and I
 * don't want to have any more files compiled this way.
 */
void
set_async_fd(int fd)
{
	int	rc;
	int     mypid = NATIVEOS(getpid)();
	
	rc = NATIVEOS(fcntl)(fd, F_SETFL, O_ASYNC | O_NONBLOCK);
	if (rc == -1)
		perror("set_async_fd: F_SETFL"), exit(0);

	rc = NATIVEOS(fcntl)(fd, F_SETOWN, mypid);
	if (rc == -1)
		perror("set_async_fd: F_SETOWN"), exit(0);
}

void
unset_async_fd(int fd)
{
	int	rc;
	
	rc = NATIVEOS(fcntl)(fd, F_SETFL, 0);
	if (rc == -1)
		perror("set_async_fd: F_SETFL"), exit(0);
}
