/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 *
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 * @COPYRIGHT@
 *
 */

void wimpi_send_expose_event (WINDOW *win);
void wimpi_send_mouse_event (WINDOW *win, wimpiEventType type, int button);
void wimpi_send_move_resize_event (WINDOW *win);
void wimpi_send_destroy_event (WINDOW *win);

/* 
 * These closely correspond to the scout winMgr interface 
 * (scout/winmgr.h).
 */

wimpiWindow wimpi_create_window (wimpiWindow parent, int x, int y, 
			   int wide, int high, int color, int has_border);
void wimpi_destroy_window (wimpiWindow w);
void wimpi_map_window (wimpiWindow w);
void wimpi_unmap_window (wimpiWindow w);
void wimpi_raise_window (wimpiWindow w);
void wimpi_lower_window (wimpiWindow w);
void wimpi_set_window_background (wimpiWindow w, int color);
void wimpi_set_foreground (wimpiWindow w, int color);
void wimpi_clear_area (wimpiWindow w, int x, int y, int wide, 
		      int high, bool exposures);
void wimpi_move_resize_window (wimpiWindow w, int x, int y, 
			      int wide, int high);
void wimpi_fill_rectangle (wimpiWindow w, int x, int y, int wide, 
			  int high);
void wimpi_draw_string (wimpiWindow w, int x, int y, char *string,
		       int length);
void wimpi_draw_line (wimpiWindow w, int x0, int y0, int x1, int y1);
void wimpi_draw_arc (wimpiWindow w, int x, int y, int wide, int high,
                    int angle1, int angle2);
void wimpi_draw_ellipse (wimpiWindow w, int x, int y, int wide, 
			int high);
void wimpi_draw_rectangle (wimpiWindow w, int x, int y, int wide, 
			  int high);
void wimpi_put_image (wimpiWindow w, int x, int y, void * data,
		     int wide, int high, unsigned depth);
void wimpi_copy_area (wimpiWindow w, int src_x, int src_y, 
		     int width, int height, int dst_x, int dst_y);
void wimpi_set_window_title (wimpiWindow w, char *title);
void wimpi_make_child_window (wimpiToplevelWindow w, Window parent, wimpiToplevelWindow child); 
