/*
 * Copyright (c) 1997, 1998 The University of Utah and the Flux Group.
 * 
 * This file is part of the OSKit Linux Glue Libraries, which are free
 * software, also known as "open source;" you can redistribute them and/or
 * modify them under the terms of the GNU General Public License (GPL),
 * version 2, as published by the Free Software Foundation (FSF).
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * Global symbol definitions to be included in all Linux fs code.
 * These defines add FS_LINUX_ prefixes to global Linux symbols
 * to ensure namespace cleanliness and prevent linking conflicts.
 * The Linux drivers themselves and the Linux glue code
 * should still continue to use the unprefixed names.
 */
/*
 * This was generated via:
 *

i486-linux-nm liboskit_linux_fs.a | grep ' [TDRC] ' | egrep -vi ' (oskit_|fs_linux|fdev_)' | awk '{ printf "#define "$3" FS_LINUX_"$3"\n" }' | sort > ! ~/oskit/linux/fs/global.h

 *
 * Note that if the .a file is a.out then you will need to remove leading
 * underscores.
 */
#ifndef _LINUX_FS_GLOBAL_H_
#define _LINUX_FS_GLOBAL_H_

#define ROOT_DEV FS_LINUX_ROOT_DEV
#define V1_minix_sync_file FS_LINUX_V1_minix_sync_file
#define V1_minix_truncate FS_LINUX_V1_minix_truncate
#define V2_minix_sync_file FS_LINUX_V2_minix_sync_file
#define __bforget FS_LINUX___bforget
#define __brelse FS_LINUX___brelse
#define __fput FS_LINUX___fput
#define __iget FS_LINUX___iget
#define __wait_on_super FS_LINUX___wait_on_super
#define affs_add_entry FS_LINUX_affs_add_entry
#define affs_bmap FS_LINUX_affs_bmap
#define affs_checksum_block FS_LINUX_affs_checksum_block
#define affs_count_free_bits FS_LINUX_affs_count_free_bits
#define affs_count_free_blocks FS_LINUX_affs_count_free_blocks
#define affs_create FS_LINUX_affs_create
#define affs_dir_inode_operations FS_LINUX_affs_dir_inode_operations
#define affs_file_inode_operations FS_LINUX_affs_file_inode_operations
#define affs_file_inode_operations_ofs FS_LINUX_affs_file_inode_operations_ofs
#define affs_find_next_hash_entry FS_LINUX_affs_find_next_hash_entry
#define affs_fix_checksum FS_LINUX_affs_fix_checksum
#define affs_fix_hash_pred FS_LINUX_affs_fix_hash_pred
#define affs_fix_link_pred FS_LINUX_affs_fix_link_pred
#define affs_fixup FS_LINUX_affs_fixup
#define affs_free_block FS_LINUX_affs_free_block
#define affs_get_file_name FS_LINUX_affs_get_file_name
#define affs_getblock FS_LINUX_affs_getblock
#define affs_getblock_ofs FS_LINUX_affs_getblock_ofs
#define affs_hash_name FS_LINUX_affs_hash_name
#define affs_link FS_LINUX_affs_link
#define affs_lookup FS_LINUX_affs_lookup
#define affs_make_zones FS_LINUX_affs_make_zones
#define affs_mkdir FS_LINUX_affs_mkdir
#define affs_new_data FS_LINUX_affs_new_data
#define affs_new_header FS_LINUX_affs_new_header
#define affs_new_inode FS_LINUX_affs_new_inode
#define affs_notify_change FS_LINUX_affs_notify_change
#define affs_parent_ino FS_LINUX_affs_parent_ino
#define affs_put_inode FS_LINUX_affs_put_inode
#define affs_put_super FS_LINUX_affs_put_super
#define affs_read_inode FS_LINUX_affs_read_inode
#define affs_read_super FS_LINUX_affs_read_super
#define affs_rename FS_LINUX_affs_rename
#define affs_rmdir FS_LINUX_affs_rmdir
#define affs_statfs FS_LINUX_affs_statfs
#define affs_symlink FS_LINUX_affs_symlink
#define affs_symlink_inode_operations FS_LINUX_affs_symlink_inode_operations
#define affs_truncate FS_LINUX_affs_truncate
#define affs_unlink FS_LINUX_affs_unlink
#define affs_write_inode FS_LINUX_affs_write_inode
#define bdf_prm FS_LINUX_bdf_prm
#define bdflush_max FS_LINUX_bdflush_max
#define bdflush_min FS_LINUX_bdflush_min
#define blk_size FS_LINUX_blk_size
#define blkdev_inode_operations FS_LINUX_blkdev_inode_operations
#define blkdev_open FS_LINUX_blkdev_open
#define blksize_size FS_LINUX_blksize_size
#define bmap FS_LINUX_bmap
#define bread FS_LINUX_bread
#define breada FS_LINUX_breada
#define buffer_init FS_LINUX_buffer_init
#define buffer_usage FS_LINUX_buffer_usage
#define buffermem FS_LINUX_buffermem
#define buffers_lav FS_LINUX_buffers_lav
#define cache_add FS_LINUX_cache_add
#define cache_init FS_LINUX_cache_init
#define cache_lookup FS_LINUX_cache_lookup
#define chrdev_inode_operations FS_LINUX_chrdev_inode_operations
#define clear_inode FS_LINUX_clear_inode
#define date_dos2unix FS_LINUX_date_dos2unix
#define dcache_add FS_LINUX_dcache_add
#define dcache_lookup FS_LINUX_dcache_lookup
#define do_link FS_LINUX_do_link
#define do_mkdir FS_LINUX_do_mkdir
#define do_mknod FS_LINUX_do_mknod
#define do_rename FS_LINUX_do_rename
#define do_rmdir FS_LINUX_do_rmdir
#define do_symlink FS_LINUX_do_symlink
#define do_truncate FS_LINUX_do_truncate
#define do_unlink FS_LINUX_do_unlink
#define dquot_drop FS_LINUX_dquot_drop
#define dquot_init FS_LINUX_dquot_init
#define dquot_initialize FS_LINUX_dquot_initialize
#define event FS_LINUX_event
#define ext2_bmap FS_LINUX_ext2_bmap
#define ext2_bread FS_LINUX_ext2_bread
#define ext2_check_blocks_bitmap FS_LINUX_ext2_check_blocks_bitmap
#define ext2_check_dir_entry FS_LINUX_ext2_check_dir_entry
#define ext2_check_inodes_bitmap FS_LINUX_ext2_check_inodes_bitmap
#define ext2_count_free FS_LINUX_ext2_count_free
#define ext2_count_free_blocks FS_LINUX_ext2_count_free_blocks
#define ext2_count_free_inodes FS_LINUX_ext2_count_free_inodes
#define ext2_create FS_LINUX_ext2_create
#define ext2_dir_inode_operations FS_LINUX_ext2_dir_inode_operations
#define ext2_discard_prealloc FS_LINUX_ext2_discard_prealloc
#define ext2_error FS_LINUX_ext2_error
#define ext2_file_inode_operations FS_LINUX_ext2_file_inode_operations
#define ext2_free_blocks FS_LINUX_ext2_free_blocks
#define ext2_free_inode FS_LINUX_ext2_free_inode
#define ext2_getblk FS_LINUX_ext2_getblk
#define ext2_getcluster FS_LINUX_ext2_getcluster
#define ext2_ioctl FS_LINUX_ext2_ioctl
#define ext2_link FS_LINUX_ext2_link
#define ext2_lookup FS_LINUX_ext2_lookup
#define ext2_mkdir FS_LINUX_ext2_mkdir
#define ext2_mknod FS_LINUX_ext2_mknod
#define ext2_new_block FS_LINUX_ext2_new_block
#define ext2_new_inode FS_LINUX_ext2_new_inode
#define ext2_panic FS_LINUX_ext2_panic
#define ext2_permission FS_LINUX_ext2_permission
#define ext2_put_inode FS_LINUX_ext2_put_inode
#define ext2_put_super FS_LINUX_ext2_put_super
#define ext2_read_inode FS_LINUX_ext2_read_inode
#define ext2_read_super FS_LINUX_ext2_read_super
#define ext2_remount FS_LINUX_ext2_remount
#define ext2_rename FS_LINUX_ext2_rename
#define ext2_rmdir FS_LINUX_ext2_rmdir
#define ext2_statfs FS_LINUX_ext2_statfs
#define ext2_symlink FS_LINUX_ext2_symlink
#define ext2_symlink_inode_operations FS_LINUX_ext2_symlink_inode_operations
#define ext2_sync_file FS_LINUX_ext2_sync_file
#define ext2_sync_inode FS_LINUX_ext2_sync_inode
#define ext2_truncate FS_LINUX_ext2_truncate
#define ext2_unlink FS_LINUX_ext2_unlink
#define ext2_warning FS_LINUX_ext2_warning
#define ext2_write_inode FS_LINUX_ext2_write_inode
#define ext2_write_super FS_LINUX_ext2_write_super
#define ext_bmap FS_LINUX_ext_bmap
#define ext_bread FS_LINUX_ext_bread
#define ext_count_free_blocks FS_LINUX_ext_count_free_blocks
#define ext_count_free_inodes FS_LINUX_ext_count_free_inodes
#define ext_create FS_LINUX_ext_create
#define ext_dir_inode_operations FS_LINUX_ext_dir_inode_operations
#define ext_file_inode_operations FS_LINUX_ext_file_inode_operations
#define ext_free_block FS_LINUX_ext_free_block
#define ext_free_inode FS_LINUX_ext_free_inode
#define ext_getblk FS_LINUX_ext_getblk
#define ext_link FS_LINUX_ext_link
#define ext_lookup FS_LINUX_ext_lookup
#define ext_mkdir FS_LINUX_ext_mkdir
#define ext_mknod FS_LINUX_ext_mknod
#define ext_new_block FS_LINUX_ext_new_block
#define ext_new_inode FS_LINUX_ext_new_inode
#define ext_put_inode FS_LINUX_ext_put_inode
#define ext_put_super FS_LINUX_ext_put_super
#define ext_read_inode FS_LINUX_ext_read_inode
#define ext_read_super FS_LINUX_ext_read_super
#define ext_release FS_LINUX_ext_release
#define ext_rename FS_LINUX_ext_rename
#define ext_rmdir FS_LINUX_ext_rmdir
#define ext_statfs FS_LINUX_ext_statfs
#define ext_symlink FS_LINUX_ext_symlink
#define ext_symlink_inode_operations FS_LINUX_ext_symlink_inode_operations
#define ext_sync_file FS_LINUX_ext_sync_file
#define ext_sync_inode FS_LINUX_ext_sync_inode
#define ext_truncate FS_LINUX_ext_truncate
#define ext_unlink FS_LINUX_ext_unlink
#define ext_write_inode FS_LINUX_ext_write_inode
#define ext_write_super FS_LINUX_ext_write_super
#define fat_a2alias FS_LINUX_fat_a2alias
#define fat_a2uni FS_LINUX_fat_a2uni
#define fat_access FS_LINUX_fat_access
#define fat_add_cluster FS_LINUX_fat_add_cluster
#define fat_bmap FS_LINUX_fat_bmap
#define fat_bread FS_LINUX_fat_bread
#define fat_brelse FS_LINUX_fat_brelse
#define fat_cache_inval_dev FS_LINUX_fat_cache_inval_dev
#define fat_cache_inval_inode FS_LINUX_fat_cache_inval_inode
#define fat_code2uni FS_LINUX_fat_code2uni
#define fat_date_unix2dos FS_LINUX_fat_date_unix2dos
#define fat_dir_ioctl FS_LINUX_fat_dir_ioctl
#define fat_dir_operations FS_LINUX_fat_dir_operations
#define fat_file_inode_operations FS_LINUX_fat_file_inode_operations
#define fat_file_inode_operations_1024 FS_LINUX_fat_file_inode_operations_1024
#define fat_file_read FS_LINUX_fat_file_read
#define fat_file_write FS_LINUX_fat_file_write
#define fat_free FS_LINUX_fat_free
#define fat_fs_panic FS_LINUX_fat_fs_panic
#define fat_get_entry FS_LINUX_fat_get_entry
#define fat_getblk FS_LINUX_fat_getblk
#define fat_is_uptodate FS_LINUX_fat_is_uptodate
#define fat_ll_rw_block FS_LINUX_fat_ll_rw_block
#define fat_lock_creation FS_LINUX_fat_lock_creation
#define fat_mark_buffer_dirty FS_LINUX_fat_mark_buffer_dirty
#define fat_mmap FS_LINUX_fat_mmap
#define fat_notify_change FS_LINUX_fat_notify_change
#define fat_parent_ino FS_LINUX_fat_parent_ino
#define fat_put_inode FS_LINUX_fat_put_inode
#define fat_put_super FS_LINUX_fat_put_super
#define fat_read_inode FS_LINUX_fat_read_inode
#define fat_read_super FS_LINUX_fat_read_super
#define fat_readdir FS_LINUX_fat_readdir
#define fat_readdirx FS_LINUX_fat_readdirx
#define fat_scan FS_LINUX_fat_scan
#define fat_set_uptodate FS_LINUX_fat_set_uptodate
#define fat_smap FS_LINUX_fat_smap
#define fat_statfs FS_LINUX_fat_statfs
#define fat_subdirs FS_LINUX_fat_subdirs
#define fat_truncate FS_LINUX_fat_truncate
#define fat_uni2asc_pg FS_LINUX_fat_uni2asc_pg
#define fat_uni2code FS_LINUX_fat_uni2code
#define fat_unlock_creation FS_LINUX_fat_unlock_creation
#define fat_write_inode FS_LINUX_fat_write_inode
#define file_fsync FS_LINUX_file_fsync
#define find_rock_ridge_relocation FS_LINUX_find_rock_ridge_relocation
#define follow_link FS_LINUX_follow_link
#define fs_may_mount FS_LINUX_fs_may_mount
#define fs_may_umount FS_LINUX_fs_may_umount
#define fsync_dev FS_LINUX_fsync_dev
#define generate_cluster FS_LINUX_generate_cluster
#define generic_file_read FS_LINUX_generic_file_read
#define generic_readpage FS_LINUX_generic_readpage
#define get_cluster FS_LINUX_get_cluster
#define get_empty_inode FS_LINUX_get_empty_inode
#define get_fs_type FS_LINUX_get_fs_type
#define get_hash_table FS_LINUX_get_hash_table
#define get_rock_ridge_filename FS_LINUX_get_rock_ridge_filename
#define get_rock_ridge_symlink FS_LINUX_get_rock_ridge_symlink
#define get_write_access FS_LINUX_get_write_access
#define getblk FS_LINUX_getblk
#define getname FS_LINUX_getname
#define gfile_create FS_LINUX_gfile_create
#define gopenfile_create FS_LINUX_gopenfile_create
#define grow_inodes FS_LINUX_grow_inodes
#define hardsect_size FS_LINUX_hardsect_size
#define hpfs_char_to_linux FS_LINUX_hpfs_char_to_linux
#define hpfs_char_to_lower_linux FS_LINUX_hpfs_char_to_lower_linux
#define hpfs_char_to_upper_linux FS_LINUX_hpfs_char_to_upper_linux
#define hpfs_read_super FS_LINUX_hpfs_read_super
#define in_group_p FS_LINUX_in_group_p
#define init_affs_fs FS_LINUX_init_affs_fs
#define init_ext2_fs FS_LINUX_init_ext2_fs
#define init_ext_fs FS_LINUX_init_ext_fs
#define init_fat_fs FS_LINUX_init_fat_fs
#define init_hpfs_fs FS_LINUX_init_hpfs_fs
#define init_iso9660_fs FS_LINUX_init_iso9660_fs
#define init_minix_fs FS_LINUX_init_minix_fs
#define init_msdos_fs FS_LINUX_init_msdos_fs
#define init_sysv_fs FS_LINUX_init_sysv_fs
#define init_vfat_fs FS_LINUX_init_vfat_fs
#define init_xiafs_fs FS_LINUX_init_xiafs_fs
#define inode_change_ok FS_LINUX_inode_change_ok
#define inode_init FS_LINUX_inode_init
#define inode_setattr FS_LINUX_inode_setattr
#define insert_inode_hash FS_LINUX_insert_inode_hash
#define internal_error_message FS_LINUX_internal_error_message
#define invalidate_buffers FS_LINUX_invalidate_buffers
#define invalidate_dquots FS_LINUX_invalidate_dquots
#define invalidate_inodes FS_LINUX_invalidate_inodes
#define iput FS_LINUX_iput
#define is_binary FS_LINUX_is_binary
#define iso_date FS_LINUX_iso_date
#define isofs_bmap FS_LINUX_isofs_bmap
#define isofs_dir_inode_operations FS_LINUX_isofs_dir_inode_operations
#define isofs_file_inode_operations FS_LINUX_isofs_file_inode_operations
#define isofs_lookup FS_LINUX_isofs_lookup
#define isofs_lookup_grandparent FS_LINUX_isofs_lookup_grandparent
#define isofs_put_super FS_LINUX_isofs_put_super
#define isofs_read_inode FS_LINUX_isofs_read_inode
#define isofs_read_super FS_LINUX_isofs_read_super
#define isofs_statfs FS_LINUX_isofs_statfs
#define isofs_symlink_inode_operations FS_LINUX_isofs_symlink_inode_operations
#define isonum_711 FS_LINUX_isonum_711
#define isonum_712 FS_LINUX_isonum_712
#define isonum_721 FS_LINUX_isonum_721
#define isonum_722 FS_LINUX_isonum_722
#define isonum_723 FS_LINUX_isonum_723
#define isonum_731 FS_LINUX_isonum_731
#define isonum_732 FS_LINUX_isonum_732
#define isonum_733 FS_LINUX_isonum_733
#define linux_char_to_upper_linux FS_LINUX_linux_char_to_upper_linux
#define linux_errno_to_oskit_error FS_LINUX_linux_errno_to_oskit_error
#define ll_rw_block FS_LINUX_ll_rw_block
#define lnamei FS_LINUX_lnamei
#define lock_fat FS_LINUX_lock_fat
#define lookup FS_LINUX_lookup
#define mark_buffer_uptodate FS_LINUX_mark_buffer_uptodate
#define max_inodes FS_LINUX_max_inodes
#define mem_map FS_LINUX_mem_map
#define min_free_pages FS_LINUX_min_free_pages
#define minix_bmap FS_LINUX_minix_bmap
#define minix_bread FS_LINUX_minix_bread
#define minix_count_free_blocks FS_LINUX_minix_count_free_blocks
#define minix_count_free_inodes FS_LINUX_minix_count_free_inodes
#define minix_create FS_LINUX_minix_create
#define minix_dir_inode_operations FS_LINUX_minix_dir_inode_operations
#define minix_file_inode_operations FS_LINUX_minix_file_inode_operations
#define minix_free_block FS_LINUX_minix_free_block
#define minix_free_inode FS_LINUX_minix_free_inode
#define minix_getblk FS_LINUX_minix_getblk
#define minix_link FS_LINUX_minix_link
#define minix_lookup FS_LINUX_minix_lookup
#define minix_mkdir FS_LINUX_minix_mkdir
#define minix_mknod FS_LINUX_minix_mknod
#define minix_new_block FS_LINUX_minix_new_block
#define minix_new_inode FS_LINUX_minix_new_inode
#define minix_put_inode FS_LINUX_minix_put_inode
#define minix_put_super FS_LINUX_minix_put_super
#define minix_read_inode FS_LINUX_minix_read_inode
#define minix_read_super FS_LINUX_minix_read_super
#define minix_remount FS_LINUX_minix_remount
#define minix_rename FS_LINUX_minix_rename
#define minix_rmdir FS_LINUX_minix_rmdir
#define minix_statfs FS_LINUX_minix_statfs
#define minix_symlink FS_LINUX_minix_symlink
#define minix_symlink_inode_operations FS_LINUX_minix_symlink_inode_operations
#define minix_sync_file FS_LINUX_minix_sync_file
#define minix_sync_inode FS_LINUX_minix_sync_inode
#define minix_truncate FS_LINUX_minix_truncate
#define minix_unlink FS_LINUX_minix_unlink
#define minix_update_inode FS_LINUX_minix_update_inode
#define minix_write_inode FS_LINUX_minix_write_inode
#define minix_write_super FS_LINUX_minix_write_super
#define mode_to_prot FS_LINUX_mode_to_prot
#define mount_root FS_LINUX_mount_root
#define msdos_create FS_LINUX_msdos_create
#define msdos_dir_inode_operations FS_LINUX_msdos_dir_inode_operations
#define msdos_fs_type FS_LINUX_msdos_fs_type
#define msdos_lookup FS_LINUX_msdos_lookup
#define msdos_mkdir FS_LINUX_msdos_mkdir
#define msdos_put_super FS_LINUX_msdos_put_super
#define msdos_read_inode FS_LINUX_msdos_read_inode
#define msdos_read_super FS_LINUX_msdos_read_super
#define msdos_rename FS_LINUX_msdos_rename
#define msdos_rmdir FS_LINUX_msdos_rmdir
#define msdos_sops FS_LINUX_msdos_sops
#define msdos_unlink FS_LINUX_msdos_unlink
#define msdos_unlink_umsdos FS_LINUX_msdos_unlink_umsdos
#define name_cache_init FS_LINUX_name_cache_init
#define namei FS_LINUX_namei
#define notify_change FS_LINUX_notify_change
#define nr_buffer_heads FS_LINUX_nr_buffer_heads
#define nr_buffers FS_LINUX_nr_buffers
#define nr_buffers_size FS_LINUX_nr_buffers_size
#define nr_buffers_st FS_LINUX_nr_buffers_st
#define nr_buffers_type FS_LINUX_nr_buffers_type
#define nr_free FS_LINUX_nr_free
#define nr_free_inodes FS_LINUX_nr_free_inodes
#define nr_free_pages FS_LINUX_nr_free_pages
#define nr_inodes FS_LINUX_nr_inodes
#define open_namei FS_LINUX_open_namei
#define parse_rock_ridge_inode FS_LINUX_parse_rock_ridge_inode
#define permission FS_LINUX_permission
#define prot_to_mode FS_LINUX_prot_to_mode
#define put_super FS_LINUX_put_super
#define put_write_access FS_LINUX_put_write_access
#define putname FS_LINUX_putname
#define quota_off FS_LINUX_quota_off
#define quota_on FS_LINUX_quota_on
#define read_ahead FS_LINUX_read_ahead
#define refile_buffer FS_LINUX_refile_buffer
#define refill_freelist FS_LINUX_refill_freelist
#define refilled FS_LINUX_refilled
#define register_filesystem FS_LINUX_register_filesystem
#define reuse_list FS_LINUX_reuse_list
#define secs_to_datestamp FS_LINUX_secs_to_datestamp
#define securelevel FS_LINUX_securelevel
#define set_blocksize FS_LINUX_set_blocksize
#define set_writetime FS_LINUX_set_writetime
#define show_buffers FS_LINUX_show_buffers
#define super_blocks FS_LINUX_super_blocks
#define swap_control FS_LINUX_swap_control
#define sync_dev FS_LINUX_sync_dev
#define sync_dquots FS_LINUX_sync_dquots
#define sync_inodes FS_LINUX_sync_inodes
#define sync_supers FS_LINUX_sync_supers
#define sys_link FS_LINUX_sys_link
#define sys_mkdir FS_LINUX_sys_mkdir
#define sys_mknod FS_LINUX_sys_mknod
#define sys_quotactl FS_LINUX_sys_quotactl
#define sys_rename FS_LINUX_sys_rename
#define sys_rmdir FS_LINUX_sys_rmdir
#define sys_symlink FS_LINUX_sys_symlink
#define sys_sync FS_LINUX_sys_sync
#define sys_tz FS_LINUX_sys_tz
#define sys_unlink FS_LINUX_sys_unlink
#define sysv_bmap FS_LINUX_sysv_bmap
#define sysv_count_free_blocks FS_LINUX_sysv_count_free_blocks
#define sysv_count_free_inodes FS_LINUX_sysv_count_free_inodes
#define sysv_create FS_LINUX_sysv_create
#define sysv_dir_inode_operations FS_LINUX_sysv_dir_inode_operations
#define sysv_file_bread FS_LINUX_sysv_file_bread
#define sysv_file_inode_operations FS_LINUX_sysv_file_inode_operations
#define sysv_file_read FS_LINUX_sysv_file_read
#define sysv_free_block FS_LINUX_sysv_free_block
#define sysv_free_inode FS_LINUX_sysv_free_inode
#define sysv_getblk FS_LINUX_sysv_getblk
#define sysv_link FS_LINUX_sysv_link
#define sysv_lookup FS_LINUX_sysv_lookup
#define sysv_mkdir FS_LINUX_sysv_mkdir
#define sysv_mknod FS_LINUX_sysv_mknod
#define sysv_new_block FS_LINUX_sysv_new_block
#define sysv_new_inode FS_LINUX_sysv_new_inode
#define sysv_notify_change FS_LINUX_sysv_notify_change
#define sysv_put_inode FS_LINUX_sysv_put_inode
#define sysv_put_super FS_LINUX_sysv_put_super
#define sysv_read_inode FS_LINUX_sysv_read_inode
#define sysv_read_super FS_LINUX_sysv_read_super
#define sysv_rename FS_LINUX_sysv_rename
#define sysv_rmdir FS_LINUX_sysv_rmdir
#define sysv_statfs FS_LINUX_sysv_statfs
#define sysv_symlink FS_LINUX_sysv_symlink
#define sysv_symlink_inode_operations FS_LINUX_sysv_symlink_inode_operations
#define sysv_sync_file FS_LINUX_sysv_sync_file
#define sysv_sync_inode FS_LINUX_sysv_sync_inode
#define sysv_truncate FS_LINUX_sysv_truncate
#define sysv_unlink FS_LINUX_sysv_unlink
#define sysv_write_inode FS_LINUX_sysv_write_inode
#define sysv_write_super FS_LINUX_sysv_write_super
#define tq_disk FS_LINUX_tq_disk
#define try_to_free_buffer FS_LINUX_try_to_free_buffer
#define unlock_fat FS_LINUX_unlock_fat
#define vfat_create FS_LINUX_vfat_create
#define vfat_dir_inode_operations FS_LINUX_vfat_dir_inode_operations
#define vfat_lookup FS_LINUX_vfat_lookup
#define vfat_mkdir FS_LINUX_vfat_mkdir
#define vfat_put_super FS_LINUX_vfat_put_super
#define vfat_read_inode FS_LINUX_vfat_read_inode
#define vfat_read_super FS_LINUX_vfat_read_super
#define vfat_rename FS_LINUX_vfat_rename
#define vfat_rmdir FS_LINUX_vfat_rmdir
#define vfat_unlink FS_LINUX_vfat_unlink
#define xiafs_bmap FS_LINUX_xiafs_bmap
#define xiafs_bread FS_LINUX_xiafs_bread
#define xiafs_count_free_inodes FS_LINUX_xiafs_count_free_inodes
#define xiafs_count_free_zones FS_LINUX_xiafs_count_free_zones
#define xiafs_create FS_LINUX_xiafs_create
#define xiafs_dir_inode_operations FS_LINUX_xiafs_dir_inode_operations
#define xiafs_file_inode_operations FS_LINUX_xiafs_file_inode_operations
#define xiafs_free_inode FS_LINUX_xiafs_free_inode
#define xiafs_free_zone FS_LINUX_xiafs_free_zone
#define xiafs_getblk FS_LINUX_xiafs_getblk
#define xiafs_link FS_LINUX_xiafs_link
#define xiafs_lookup FS_LINUX_xiafs_lookup
#define xiafs_mkdir FS_LINUX_xiafs_mkdir
#define xiafs_mknod FS_LINUX_xiafs_mknod
#define xiafs_new_inode FS_LINUX_xiafs_new_inode
#define xiafs_new_zone FS_LINUX_xiafs_new_zone
#define xiafs_put_inode FS_LINUX_xiafs_put_inode
#define xiafs_put_super FS_LINUX_xiafs_put_super
#define xiafs_read_inode FS_LINUX_xiafs_read_inode
#define xiafs_read_super FS_LINUX_xiafs_read_super
#define xiafs_rename FS_LINUX_xiafs_rename
#define xiafs_rmdir FS_LINUX_xiafs_rmdir
#define xiafs_statfs FS_LINUX_xiafs_statfs
#define xiafs_symlink FS_LINUX_xiafs_symlink
#define xiafs_symlink_inode_operations FS_LINUX_xiafs_symlink_inode_operations
#define xiafs_sync_file FS_LINUX_xiafs_sync_file
#define xiafs_sync_inode FS_LINUX_xiafs_sync_inode
#define xiafs_truncate FS_LINUX_xiafs_truncate
#define xiafs_unlink FS_LINUX_xiafs_unlink
#define xiafs_write_inode FS_LINUX_xiafs_write_inode

#endif /* _LINUX_FS_GLOBAL_H_ */
