/*
 * Copyright (c) 1997-1999 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * Example program to test the wimpi window manager.
 */
/*
 * To use this program with the x11video library, you'll need to 
 * make sure that you've got an XF86Config file in your boot image.
 * 
 * ie. mkbsdimage wimpirun XF86Config:/etc/XF86config
 *
 */
#include <stdlib.h>
#include <oskit/types.h>
#include <oskit/c/fs.h>
#include <oskit/c/fd.h>
#include <oskit/io/mouse.h>
#include <oskit/io/ttystream.h>
#include <oskit/fs/memfs.h>
#include <oskit/fs/file.h>      /* XXX OSKIT_O_RDWR */
#include <oskit/dev/dev.h>
#include <oskit/dev/tty.h>
#include <oskit/dev/freebsd.h>
#include <oskit/x86/pc/direct_cons.h>
#include <oskit/startup.h>
#include <oskit/clientos.h>
#include <oskit/dev/osenv.h>

#include <oskit/wimpi.h>

wimpiSession s;
int mx, my;
wimpiToplevelWindow wa, wb;
int curx, cury;


int InputRoutine(int mask,wimpiInputEvent *event);
void InputHandler();
void KBHandler(int scancode);

long 
handle_wimpi_event(wimpiToplevelWindow w, wimpiEvent e)
{
	wimpiEvent c = e;
  
	char s[2] = {'\0','\0'};

	if (e->type == KEYPRESS_EVENT) {
		s[0] = c->event.keyEvent.the_char;
		wimpi_draw_string(wa->root, curx, cury, s, 1);
		curx += 10;
		
		if (curx > 90) {
			curx = 10;
			cury += 10;
			if (cury > 90) {
				cury = 10;
			}
		}
	}
	
	return 0;
}

int 
handle_wimpi_input(int mask, wimpiInputEvent *event)
{
	int sc;
	oskit_mouse_packet_t *p;
  
	if (mask & IMASK_MOUSE) {
		/* Currently this is a blocking call, because of the 
		 * FreeBSD psm mouse driver which defaults to blocking
		 * mode.  This can cause some bizzare behavior. =(
		 */ 
		p = oskit_mouse_get_packet();

		if (p != NULL) {
			event->type=IMASK_MOUSE;
			event->event.mouseEvent.dx = p->dx;
			event->event.mouseEvent.dy = p->dy;
			event->event.mouseEvent.but_state = p->buttons;

			return 1;
		}
	}
  
	if (mask & IMASK_KEY) {
		if ((sc = direct_cons_getchar()) != -1) {
			event->type = IMASK_KEY;
			event->event.kbdEvent.c = sc;

			return 1;
		}
	}
  
	return 0;
}

void 
KBHandler(int scancode)
{
	wimpi_kbd_input(s, scancode);
}


int
main(int argc, char *argv[])
{
	wimpiWindow wba, wbb;
	oskit_ttydev_t **ttydev;
	oskit_ttystream_t *strm;
	int rc, ndev;
	oskit_osenv_t *osenv;

	curx = cury = 10;
	mx = my = 0;

	oskit_clientos_init();
	start_fs_bmod();
	osenv = start_osenv();
	start_clock();
	
	oskit_dev_init(osenv);
	oskit_freebsd_init_osenv(osenv);
	oskit_freebsd_init_psm();
	oskit_dump_drivers();
	oskit_dev_probe();
	oskit_dump_devices();

	ndev = osenv_device_lookup(&oskit_ttydev_iid, (void***)&ttydev);
	if (ndev <= 0)
		panic("no devices found!");

	/*
	 * Open the first TTY device found, which should be the mouse,
	 * since that's the only device we initialized.
	 */
	rc = oskit_ttydev_open(ttydev[0], OSKIT_O_RDWR, &strm);
	if (rc)
		panic("unable to open psm!: %d", rc);

	if (!oskit_mouse_init(strm, P_PS2, 150))
		panic("couldn't initialize mouse!\n");

	direct_cons_set_flags(DC_RAW | DC_NONBLOCK);

	/* wimpi initialization */
	s = wimpi_initialize();
	
	wimpi_set_event_handler(s, &handle_wimpi_event);
	wimpi_set_input_routine(s, &handle_wimpi_input);

	wa = wimpi_create_toplevel(s, 0, 100, 100, 20, 20, 
				   "WINDOW A", 1, NULL);
	wb = wimpi_create_toplevel(s,1,200,200,20,20,
				   "WINDOW B",1,NULL);

	wba = wimpi_create_window(wb->root, 0, 0, 200, 200, 1, 1);
	wbb = wimpi_create_window(wba, 10, 10, 30, 30, 2, 0);
	wimpi_map_window(wba);
	wimpi_map_window(wbb);
    
	wimpi_draw_string(wbb, 100, 100, "bye", 3);
  
	wimpi_main_loop(s);

	return 0;
}
      


  






