#include <errno.h>
#include <string.h>
#include <sys/socket.h>

#include <oskit/net/socket.h>


typedef struct {
    int a, b;
} opts;

static opts xlate_so_opts[] = {
    { OSKIT_SO_DEBUG, SO_DEBUG },
    /* OSKIT_SO_ACCEPTCON */
    { OSKIT_SO_REUSEADDR, SO_REUSEADDR },
    { OSKIT_SO_KEEPALIVE, SO_KEEPALIVE },
    { OSKIT_SO_DONTROUTE, SO_DONTROUTE },
    { OSKIT_SO_BROADCAST, SO_BROADCAST },
    /* OSKIT_SO_USELOOPBACK */
    { OSKIT_SO_LINGER, SO_LINGER },
    { OSKIT_SO_OOBINLINE, SO_OOBINLINE },
    /* OSKIT_SO_REUSEPORT */
    /* OSKIT_SO_SIDREFLECT */
    { OSKIT_SO_SNDBUF, SO_SNDBUF },
    { OSKIT_SO_RCVBUF, SO_RCVBUF },
#ifdef SO_SNDTIMEO
    { OSKIT_SO_SNDLOWAT, SO_SNDLOWAT },
    { OSKIT_SO_RCVLOWAT, SO_RCVLOWAT },
    { OSKIT_SO_SNDTIMEO, SO_SNDTIMEO },
    { OSKIT_SO_RCVTIMEO, SO_RCVTIMEO },
#endif
    { OSKIT_SO_ERROR, SO_ERROR },
    { OSKIT_SO_TYPE, SO_TYPE },
    /* OSKIT_SO_NETIO */	
    0,
};


int
native_setsockopt(int s, int level, int optname, const void *optval, int optlen)
{
    /* Linux and the oskit don't agree on the value of SOL_SOCKET. */
    if (level == OSKIT_SOL_SOCKET) {
	opts *p = &xlate_so_opts[0];

	level = SOL_SOCKET;
	
	for (; p; p++) {
	    if (p->a == optname) {
		optname = p->b;
		break;
	    } 
	}
	
	if (!p) {
	    native___set_errno(ENOPROTOOPT);
	    return -1;
	}
    }
	
    return native___setsockopt(s, level, optname, optval, 
			       optlen);
}
