#include <oskit/error.h>


static oskit_error_t errtab[] = {
    0,
    OSKIT_EPERM, 
    OSKIT_ENOENT, 
    OSKIT_ESRCH, 
    OSKIT_EINTR, 
    OSKIT_EIO, 
    OSKIT_ENXIO, 
    OSKIT_E2BIG, 
    OSKIT_ENOEXEC, 
    OSKIT_EBADF, 
    OSKIT_ECHILD, 
    OSKIT_EAGAIN, 
    OSKIT_ENOMEM, 
    OSKIT_EACCES, 
    OSKIT_EFAULT, 
    OSKIT_EINVAL,	/* ENOTBLK */
    OSKIT_EBUSY, 
    OSKIT_EEXIST, 
    OSKIT_EXDEV, 
    OSKIT_ENODEV, 
    OSKIT_ENOTDIR, 
    OSKIT_EISDIR, 
    OSKIT_EINVAL, 
    OSKIT_ENFILE, 
    OSKIT_EMFILE, 
    OSKIT_ENOTTY, 
    OSKIT_ETXTBSY, 
    OSKIT_EFBIG, 
    OSKIT_ENOSPC, 
    OSKIT_ESPIPE, 
    OSKIT_EROFS, 
    OSKIT_EMLINK, 
    OSKIT_EPIPE, 
    OSKIT_EDOM, 
    OSKIT_ERANGE, 
    OSKIT_EDEADLK, 
    OSKIT_ENAMETOOLONG, 
    OSKIT_ENOLCK, 
    OSKIT_ENOSYS, 
    OSKIT_ENOTEMPTY, 
    OSKIT_ELOOP, 
    OSKIT_EAGAIN, 
    OSKIT_ENOMSG, 
    OSKIT_EIDRM, 
    OSKIT_E_UNEXPECTED,		/* ECHRNG */
    OSKIT_E_UNEXPECTED,		/* EL2NSYNC */
    OSKIT_E_UNEXPECTED,		/* EL3HLT */
    OSKIT_E_UNEXPECTED,		/* EL3RST */
    OSKIT_E_UNEXPECTED,		/* ELNRNG */
    OSKIT_E_UNEXPECTED,		/* EUNATCH */
    OSKIT_E_UNEXPECTED,		/* ENOCSI */
    OSKIT_E_UNEXPECTED,		/* EL2HLT */
    OSKIT_E_UNEXPECTED,		/* EBADE */
    OSKIT_E_UNEXPECTED,		/* EBADR */
    OSKIT_E_UNEXPECTED,		/* EXFULL */
    OSKIT_E_UNEXPECTED, 	/* ENOANO */
    OSKIT_E_UNEXPECTED,		/* EBADRQC */
    OSKIT_E_UNEXPECTED,		/* EBADSLT */
    OSKIT_EDEADLK, 
    OSKIT_E_UNEXPECTED,		/* EBFONT */
    OSKIT_ENOSTR,
    OSKIT_ENODATA,
    OSKIT_ETIME,
    OSKIT_ENOSR,
    OSKIT_E_UNEXPECTED,		/* ENONET */
    OSKIT_E_UNEXPECTED,		/* ENOPKG */
    OSKIT_E_UNEXPECTED,		/* EREMOTE */
    OSKIT_ENOLINK, 
    OSKIT_E_UNEXPECTED,		/* EADV */
    OSKIT_E_UNEXPECTED,		/* ESRMNT */
    OSKIT_E_UNEXPECTED,		/* ECOMM */
    OSKIT_EPROTO, 
    OSKIT_EMULTIHOP, 
    OSKIT_E_UNEXPECTED,		/* EDOTDOT */
    OSKIT_EBADMSG, 
    OSKIT_EOVERFLOW, 
    OSKIT_E_UNEXPECTED,		/* ENOTUNIQ */
    OSKIT_E_UNEXPECTED,		/* EBADFD */
    OSKIT_E_UNEXPECTED, 	/* EREMCHG */
    OSKIT_E_UNEXPECTED,		/* ELIBACC */
    OSKIT_E_UNEXPECTED,		/* ELIBBAD */
    OSKIT_E_UNEXPECTED,		/* ELIBSCN */
    OSKIT_E_UNEXPECTED, 	/* ELIBMAX */
    OSKIT_E_UNEXPECTED,		/* ELIBEXEC */
    OSKIT_EILSEQ, 
    OSKIT_E_UNEXPECTED,		/* ERESTART */
    OSKIT_E_UNEXPECTED,		/* ESTRPIPE */
    OSKIT_E_UNEXPECTED,		/* EUSERS */
    OSKIT_ENOTSOCK, 
    OSKIT_EDESTADDRREQ, 
    OSKIT_EMSGSIZE, 
    OSKIT_EPROTOTYPE, 
    OSKIT_ENOPROTOOPT, 
    OSKIT_EPROTONOSUPPORT, 
    OSKIT_E_UNEXPECTED,		/* ESOCKTNOSUPPORT */
    OSKIT_EOPNOTSUPP, 
    OSKIT_E_UNEXPECTED,		/* EPFNOSUPPORT */
    OSKIT_EAFNOSUPPORT, 
    OSKIT_EADDRINUSE, 
    OSKIT_EADDRNOTAVAIL, 
    OSKIT_ENETDOWN,
    OSKIT_ENETUNREACH, 
    OSKIT_E_UNEXPECTED,		/* ENETRESET */
    OSKIT_ECONNABORTED, 
    OSKIT_ECONNRESET, 
    OSKIT_ENOBUFS, 
    OSKIT_EISCONN, 
    OSKIT_ENOTCONN, 
    OSKIT_E_UNEXPECTED,		/* ESHUTDOWN */
    OSKIT_E_UNEXPECTED,		/* ETOOMANYREFS */
    OSKIT_ETIMEDOUT, 
    OSKIT_ECONNREFUSED, 
    OSKIT_E_UNEXPECTED,		/* EHOSTDOWN */
    OSKIT_EHOSTUNREACH, 
    OSKIT_EALREADY, 
    OSKIT_EINPROGRESS, 
    OSKIT_ESTALE, 
    OSKIT_E_UNEXPECTED,		/* EUCLEAN */
    OSKIT_E_UNEXPECTED,		/* ENOTNAM */
    OSKIT_E_UNEXPECTED,		/* ENAVAIL */
    OSKIT_E_UNEXPECTED,		/* EISNAM */
    OSKIT_E_UNEXPECTED,		/* EREMOTEIO */
    OSKIT_EDQUOT, 
    OSKIT_E_UNEXPECTED,		/* ENOMEDIUM */
    OSKIT_E_UNEXPECTED		/* EMEDIUMTYPE */
};


oskit_error_t oskit_linux_xlate_errno(int _error)
{
        if (_error <= 0 || _error > sizeof(errtab)/sizeof(errtab[0]))
                return OSKIT_E_UNEXPECTED;

        return errtab[_error];
}

