/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
#include <stdio.h>
#include <sys/types.h>
#include <stdarg.h>
#include <fcntl.h>
#include <errno.h>

int
fcntl (int fd, int cmd, ...) 
{
	va_list		ap;

	/* XXX We don't actually do anything yet... */

	va_start (ap, cmd);

	switch (cmd) {
	case F_DUPFD:
		return EMFILE;	/* XXX Yeah, sure... */
	case F_GETFD:
#ifdef DEBUG_FCNTL
		printf("%s: trying to get close-on-exec status for fd %d!\n",
		       __FUNCTION__, fd);
#endif
		break;
	case F_SETFD:
#ifdef DEBUG_FCNTL
		printf("%s: trying to set close-on-exec status for fd %d! (arg = %x)\n",
		       __FUNCTION__, fd, va_arg (ap, int));
#endif
		break;
	case F_GETFL:
#ifdef DEBUG_FCNTL
		printf("%s: trying to get flags for fd %d\n", __FUNCTION__,
		       fd);
#endif
		break;
	case F_SETFL:
#ifdef DEBUG_FCNTL
		printf("%s: trying to set flags for fd %d, arg %x\n",
		       __FUNCTION__, fd, va_arg (ap, int));
#endif
		break;

	default:
		printf("%s: called with fd %x, UNKNOWN cmd %x, arg %x\n", 
		       __FUNCTION__, fd, cmd, va_arg (ap, int));
	}

	return 0;
}
