/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: screen.h,v $
 *
 * HISTORY
 * $\Log: screen.h,v $
 * Revision 1.3  1998/01/31 18:43:15  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.2  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 * Revision 1.1  1996/10/22 23:53:34  abhiram
 * Initial revision
 *
 */


#define DATA unsigned char

#include <bitblit.h>

#define LOGBITS 3
#define BITS (~(~(unsigned)0<<LOGBITS))

#define bit_linesize(wide,depth) ((((depth)*(wide)+BITS)&~BITS)>>3)

#define BIT_SIZE(m) BIT_Size(BIT_WIDE(m), BIT_HIGH(m), BIT_DEPTH(m))
#define BIT_Size(wide,high,depth) (((((depth)*(wide)+BITS)&~BITS)*(high))>>3)
#define BIT_LINE(x) ((((x)->primary->depth*(x)->primary->wide+BITS)&~BITS)>>LOGBITS)

/*{{{}}}*/


#ifndef __STDC__
#ifndef __GNUC__
#define	_PROTOTYPE(_function, _params)	_function()
#endif
#endif
#ifndef _PROTOTYPE
#define	_PROTOTYPE(_function, _params)	_function _params
#endif

#include <sys/types.h>

#if !defined(__FreeBSD__) && !defined(OSKIT)
_PROTOTYPE( extern int ioctl, (int _fd, int _request, ...));
_PROTOTYPE( extern int fprintf, (FILE *_stream, const char *_format, ...));
_PROTOTYPE( extern size_t fread, (void *_ptr, size_t _size, size_t _nmemb, FILE *_stream));
_PROTOTYPE( size_t fwrite, (const void *_ptr, size_t _size, size_t _nmemb, FILE *_stream));
_PROTOTYPE( extern int fseek, (FILE *_stream, long _offset, int _whence));
_PROTOTYPE( extern int fflush, (FILE *_stream));
_PROTOTYPE( extern int fclose, (FILE *_stream));
_PROTOTYPE( extern void *memset, (void *_s, int _c, size_t _n));
#endif

_PROTOTYPE( extern void display_close, (BITMAP *bitmap));

_PROTOTYPE( extern BITMAP *bit_expand, (BITMAP *map,int fg,int bg));

_PROTOTYPE( extern void flip, (DATA *s,int count));

_PROTOTYPE( extern int rop_invert, (int op));

_PROTOTYPE( extern int mem_rop, (BITMAP *dst_map,int x_dst,int y_dst,
				 int wide,int high,int op,
				 BITMAP *src_map,int x_src,int y_src));





