/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 * 
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 * $\RCSfile: destroy.c,v $
 *
 * HISTORY
 * $\Log: destroy.c,v $
 * Revision 1.3  1998/01/31 18:43:07  mjk
 * replaced copyright
 *
 * Revision 1.2  1998/01/28 18:23:56  mjk
 * copyright
 *
 * Revision 1.1  1997/04/15 18:15:49  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/25 22:19:39  acb
 * Initial revision
 *
 * Revision 1.1  1997/03/12 18:01:14  acb
 * Initial revision
 *
 * Revision 1.3  1996/12/19  21:12:41  acb
 * * Eliminated most global variables
 * * Rlogin windows can be created from menu
 * * 'Destroy window' and 'quit' menu options work now
 * * Moved location of header files
 * * Many small display glitches fixed
 *
 */

/*{{{}}}*/
/*{{{  Notes*/

/* destroy a window */
/*}}}  */
/*{{{  #includes*/
#include <bitblit.h>
#include <oskit/wimpi.h>
#include <font.h>
#include <window.h>
#include <sys/time.h>
#include <stdlib.h>
#include <stdio.h>

#include "defs.h"

#include "border.h"
#include "colormap.h"
#include "erase_win.h"
#include "font_subs.h"
#include "get_menus.h"
#include "icon_server.h"
#include "put_window.h"
#include "subs.h"
#include "clip.h"
#include "update.h"
#include "destroy.h"

/*}}}  */
/*{{{  #defines*/
#define ALL	1


/*{{{  unlink_win -- free all space associated with a window*/
void unlink_win(win,how) register WINDOW *win;		/* window to unlink */
int how;			/* if how, unlink window stack as well */
   {
   register int i;

   dbgprintf('u',(stderr,"Unlinking %s %s\n",W(tty),how?"ALL":""));

   /*
    *   if (how && W(stack))
    *      unlink_win(W(stack),how);
    */
   if (W(window))
     bit_destroy(W(window));
   for(i=0; i< MAXBITMAPS;i++)
     if (W(bitmaps)[i])
       bit_destroy(W(bitmaps)[i]);

   bit_destroy(W(cursor));	
   /* usually noop because static */
   if (W(border))
       bit_destroy(W(border));
   if (W(save))
       bit_destroy(W(save));
   if (W(snarf))
     free(W(snarf));
   if (W(bitmap))
      free(W(bitmap));

   zap_cliplist(win);

   for(i=0; i< MAXEVENTS;i++)
       if (W(events)[i])
          free(W(events)[i]);

   for(i=0; i< MAXMENU;i++)
     if (W(menus)[i])
       menu_destroy(W(menus)[i]);

   }
/*}}}  */

/*{{{  destroy -- destroy a window*/
int destroy(mr, win) 
wimpiSession mr;
register WINDOW *win;
{
   if (win == (WINDOW *) 0)
      return(-1);


   if (mr->next_window > 0)
       mr->next_window--;
   
   MOUSE_OFF(mr,mr->screen,mr->mousex,mr->mousey);
   cursor_off(mr);

   if (win != mr->active) {
      ACTIVE_OFF(mr);
      expose(mr, win);
   }

   mr->active = W(next);

   /* deallocate window slot */

   if (mr->active)
      ACTIVE(mr,prev) = W(prev);

   /* remove window from screen */

   erase_win(mr,W(border));

   /* fix up display if any windows left */

   SETMOUSEICON(mr,DEFAULT_MOUSE_CURSOR(mr));	
   /* because active win chg */

   if (mr->active) {
      repair(mr, win);
      un_covered(mr);
      clip_bad(win);  
      ACTIVE_ON(mr);
      cursor_on(mr);
      }

   /* free space associated with dead window */

   unlink_win(win,ALL);

   dbgprintf('d',(stderr,"Active: %s-%d\r\n",
	     mr->active?ACTIVE(mr,tty):"NONE", mr->active?ACTIVE(mr,num):0));

   MOUSE_ON(mr,mr->screen,mr->mousex,mr->mousey);

   return(0);
   }
/*}}}  */

/*{{{  destroy_window -- mark active window for destruction*/
void destroy_window(wimpiSession mr)
{
    ACTIVE(mr,flags) |= W_DIED;    
}
/*}}}  */

