/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#ifndef WINMAP_H
#define WINMAP_H

typedef struct winmap_e winmap_e;
struct winmap_e {
  struct winmap_e *next;
  int key;
  WINDOW* value;
};

typedef struct winmap winmap;
struct winmap {
  int size;
  winmap_e **hash;
};

typedef struct winmap_walk winmap_walk;
struct winmap_walk {
  winmap *m;
  winmap_e *curh;
  int curi;
};

winmap* winmapCreate(int size);
int winmapBind(winmap* m,int key,WINDOW* value);
int winmapUnbind(winmap* m,int key);
int winmapResolve(winmap* m,int key,WINDOW** value);
int winmapDelete(winmap* m);
void winmapWalkInit(winmap_walk* w,winmap *m);
void winmapWalkDone(winmap_walk* w);
WINDOW* winmapWalkNext(winmap_walk* w);

#define WME_OK        0
#define WME_BADMAP    1
#define WME_DUPENTRY  2
#define WME_NOMATCH   3

#endif
